# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetCertificateAuthorityResult',
    'AwaitableGetCertificateAuthorityResult',
    'get_certificate_authority',
    'get_certificate_authority_output',
]

@pulumi.output_type
class GetCertificateAuthorityResult:
    def __init__(__self__, arn=None, certificate_signing_request=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if certificate_signing_request and not isinstance(certificate_signing_request, str):
            raise TypeError("Expected argument 'certificate_signing_request' to be a str")
        pulumi.set(__self__, "certificate_signing_request", certificate_signing_request)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the certificate authority.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> Optional[builtins.str]:
        """
        The base64 PEM-encoded certificate signing request (CSR) for your certificate authority certificate.
        """
        return pulumi.get(self, "certificate_signing_request")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetCertificateAuthorityResult(GetCertificateAuthorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateAuthorityResult(
            arn=self.arn,
            certificate_signing_request=self.certificate_signing_request,
            tags=self.tags)


def get_certificate_authority(arn: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateAuthorityResult:
    """
    Private certificate authority.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the certificate authority.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:acmpca:getCertificateAuthority', __args__, opts=opts, typ=GetCertificateAuthorityResult).value

    return AwaitableGetCertificateAuthorityResult(
        arn=pulumi.get(__ret__, 'arn'),
        certificate_signing_request=pulumi.get(__ret__, 'certificate_signing_request'),
        tags=pulumi.get(__ret__, 'tags'))
def get_certificate_authority_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateAuthorityResult]:
    """
    Private certificate authority.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the certificate authority.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:acmpca:getCertificateAuthority', __args__, opts=opts, typ=GetCertificateAuthorityResult)
    return __ret__.apply(lambda __response__: GetCertificateAuthorityResult(
        arn=pulumi.get(__response__, 'arn'),
        certificate_signing_request=pulumi.get(__response__, 'certificate_signing_request'),
        tags=pulumi.get(__response__, 'tags')))
