# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AnalyzerAnalysisRuleCriteria',
    'AnalyzerArchiveRule',
    'AnalyzerConfigurationProperties',
    'AnalyzerFilter',
    'AnalyzerTag',
    'AnalyzerUnusedAccessConfiguration',
    'AnalyzerUnusedAccessConfigurationAnalysisRuleProperties',
]

@pulumi.output_type
class AnalyzerAnalysisRuleCriteria(dict):
    """
    The criteria for an analysis rule for an analyzer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountIds":
            suggest = "account_ids"
        elif key == "resourceTags":
            suggest = "resource_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyzerAnalysisRuleCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyzerAnalysisRuleCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyzerAnalysisRuleCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_ids: Optional[Sequence[builtins.str]] = None,
                 resource_tags: Optional[Sequence[Sequence['outputs.AnalyzerTag']]] = None):
        """
        The criteria for an analysis rule for an analyzer.
        :param Sequence[builtins.str] account_ids: A list of AWS account IDs to apply to the analysis rule criteria. The accounts cannot include the organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for organization-level analyzers.
        :param Sequence[Sequence['AnalyzerTag']] resource_tags: An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
               
               For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with aws:.
               
               For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value is 0 characters, the rule is applied to all principals with the specified tag key.
        """
        if account_ids is not None:
            pulumi.set(__self__, "account_ids", account_ids)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)

    @property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of AWS account IDs to apply to the analysis rule criteria. The accounts cannot include the organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for organization-level analyzers.
        """
        return pulumi.get(self, "account_ids")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[Sequence[Sequence['outputs.AnalyzerTag']]]:
        """
        An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.

        For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with aws:.

        For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value is 0 characters, the rule is applied to all principals with the specified tag key.
        """
        return pulumi.get(self, "resource_tags")


@pulumi.output_type
class AnalyzerArchiveRule(dict):
    """
    An Access Analyzer archive rule. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyzerArchiveRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyzerArchiveRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyzerArchiveRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: Sequence['outputs.AnalyzerFilter'],
                 rule_name: builtins.str):
        """
        An Access Analyzer archive rule. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
        :param Sequence['AnalyzerFilter'] filter: The criteria for the rule.
        :param builtins.str rule_name: The archive rule name
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter
    def filter(self) -> Sequence['outputs.AnalyzerFilter']:
        """
        The criteria for the rule.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> builtins.str:
        """
        The archive rule name
        """
        return pulumi.get(self, "rule_name")


@pulumi.output_type
class AnalyzerConfigurationProperties(dict):
    """
    The configuration for the analyzer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unusedAccessConfiguration":
            suggest = "unused_access_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyzerConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyzerConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyzerConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unused_access_configuration: Optional['outputs.AnalyzerUnusedAccessConfiguration'] = None):
        """
        The configuration for the analyzer
        :param 'AnalyzerUnusedAccessConfiguration' unused_access_configuration: Specifies the configuration of an unused access analyzer for an AWS organization or account.
        """
        if unused_access_configuration is not None:
            pulumi.set(__self__, "unused_access_configuration", unused_access_configuration)

    @property
    @pulumi.getter(name="unusedAccessConfiguration")
    def unused_access_configuration(self) -> Optional['outputs.AnalyzerUnusedAccessConfiguration']:
        """
        Specifies the configuration of an unused access analyzer for an AWS organization or account.
        """
        return pulumi.get(self, "unused_access_configuration")


@pulumi.output_type
class AnalyzerFilter(dict):
    def __init__(__self__, *,
                 property: builtins.str,
                 contains: Optional[Sequence[builtins.str]] = None,
                 eq: Optional[Sequence[builtins.str]] = None,
                 exists: Optional[builtins.bool] = None,
                 neq: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str property: The property used to define the criteria in the filter for the rule.
        :param Sequence[builtins.str] contains: A "contains" condition to match for the rule.
        :param Sequence[builtins.str] eq: An "equals" condition to match for the rule.
        :param builtins.bool exists: An "exists" condition to match for the rule.
        :param Sequence[builtins.str] neq: A "not equal" condition to match for the rule.
        """
        pulumi.set(__self__, "property", property)
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if eq is not None:
            pulumi.set(__self__, "eq", eq)
        if exists is not None:
            pulumi.set(__self__, "exists", exists)
        if neq is not None:
            pulumi.set(__self__, "neq", neq)

    @property
    @pulumi.getter
    def contains(self) -> Optional[Sequence[builtins.str]]:
        """
        A "contains" condition to match for the rule.
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def eq(self) -> Optional[Sequence[builtins.str]]:
        """
        An "equals" condition to match for the rule.
        """
        return pulumi.get(self, "eq")

    @property
    @pulumi.getter
    def exists(self) -> Optional[builtins.bool]:
        """
        An "exists" condition to match for the rule.
        """
        return pulumi.get(self, "exists")

    @property
    @pulumi.getter
    def neq(self) -> Optional[Sequence[builtins.str]]:
        """
        A "not equal" condition to match for the rule.
        """
        return pulumi.get(self, "neq")

    @property
    @pulumi.getter
    def property(self) -> builtins.str:
        """
        The property used to define the criteria in the filter for the rule.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class AnalyzerTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: Optional[builtins.str] = None):
        """
        A key-value pair to associate with a resource.
        :param builtins.str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param builtins.str value: The value for the tag. You can specify a value that is 0 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value for the tag. You can specify a value that is 0 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AnalyzerUnusedAccessConfiguration(dict):
    """
    The Configuration for Unused Access Analyzer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisRule":
            suggest = "analysis_rule"
        elif key == "unusedAccessAge":
            suggest = "unused_access_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyzerUnusedAccessConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyzerUnusedAccessConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyzerUnusedAccessConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_rule: Optional['outputs.AnalyzerUnusedAccessConfigurationAnalysisRuleProperties'] = None,
                 unused_access_age: Optional[builtins.int] = None):
        """
        The Configuration for Unused Access Analyzer
        :param 'AnalyzerUnusedAccessConfigurationAnalysisRuleProperties' analysis_rule: Contains information about rules for the analyzer.
        :param builtins.int unused_access_age: The specified access age in days for which to generate findings for unused access. For example, if you specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value between 1 and 365 days.
        """
        if analysis_rule is not None:
            pulumi.set(__self__, "analysis_rule", analysis_rule)
        if unused_access_age is not None:
            pulumi.set(__self__, "unused_access_age", unused_access_age)

    @property
    @pulumi.getter(name="analysisRule")
    def analysis_rule(self) -> Optional['outputs.AnalyzerUnusedAccessConfigurationAnalysisRuleProperties']:
        """
        Contains information about rules for the analyzer.
        """
        return pulumi.get(self, "analysis_rule")

    @property
    @pulumi.getter(name="unusedAccessAge")
    def unused_access_age(self) -> Optional[builtins.int]:
        """
        The specified access age in days for which to generate findings for unused access. For example, if you specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value between 1 and 365 days.
        """
        return pulumi.get(self, "unused_access_age")


@pulumi.output_type
class AnalyzerUnusedAccessConfigurationAnalysisRuleProperties(dict):
    """
    Contains information about rules for the analyzer.
    """
    def __init__(__self__, *,
                 exclusions: Optional[Sequence['outputs.AnalyzerAnalysisRuleCriteria']] = None):
        """
        Contains information about rules for the analyzer.
        :param Sequence['AnalyzerAnalysisRuleCriteria'] exclusions: A list of rules for the analyzer containing criteria to exclude from analysis. Entities that meet the rule criteria will not generate findings.
        """
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.AnalyzerAnalysisRuleCriteria']]:
        """
        A list of rules for the analyzer containing criteria to exclude from analysis. Entities that meet the rule criteria will not generate findings.
        """
        return pulumi.get(self, "exclusions")


