# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetAnalyzerResult',
    'AwaitableGetAnalyzerResult',
    'get_analyzer',
    'get_analyzer_output',
]

@pulumi.output_type
class GetAnalyzerResult:
    def __init__(__self__, analyzer_configuration=None, archive_rules=None, arn=None, tags=None):
        if analyzer_configuration and not isinstance(analyzer_configuration, dict):
            raise TypeError("Expected argument 'analyzer_configuration' to be a dict")
        pulumi.set(__self__, "analyzer_configuration", analyzer_configuration)
        if archive_rules and not isinstance(archive_rules, list):
            raise TypeError("Expected argument 'archive_rules' to be a list")
        pulumi.set(__self__, "archive_rules", archive_rules)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="analyzerConfiguration")
    def analyzer_configuration(self) -> Optional['outputs.AnalyzerConfigurationProperties']:
        """
        The configuration for the analyzer
        """
        return pulumi.get(self, "analyzer_configuration")

    @property
    @pulumi.getter(name="archiveRules")
    def archive_rules(self) -> Optional[Sequence['outputs.AnalyzerArchiveRule']]:
        """
        Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.
        """
        return pulumi.get(self, "archive_rules")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of the analyzer
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAnalyzerResult(GetAnalyzerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnalyzerResult(
            analyzer_configuration=self.analyzer_configuration,
            archive_rules=self.archive_rules,
            arn=self.arn,
            tags=self.tags)


def get_analyzer(arn: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnalyzerResult:
    """
    The AWS::AccessAnalyzer::Analyzer type specifies an analyzer of the user's account


    :param builtins.str arn: Amazon Resource Name (ARN) of the analyzer
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:accessanalyzer:getAnalyzer', __args__, opts=opts, typ=GetAnalyzerResult).value

    return AwaitableGetAnalyzerResult(
        analyzer_configuration=pulumi.get(__ret__, 'analyzer_configuration'),
        archive_rules=pulumi.get(__ret__, 'archive_rules'),
        arn=pulumi.get(__ret__, 'arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_analyzer_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAnalyzerResult]:
    """
    The AWS::AccessAnalyzer::Analyzer type specifies an analyzer of the user's account


    :param builtins.str arn: Amazon Resource Name (ARN) of the analyzer
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:accessanalyzer:getAnalyzer', __args__, opts=opts, typ=GetAnalyzerResult)
    return __ret__.apply(lambda __response__: GetAnalyzerResult(
        analyzer_configuration=pulumi.get(__response__, 'analyzer_configuration'),
        archive_rules=pulumi.get(__response__, 'archive_rules'),
        arn=pulumi.get(__response__, 'arn'),
        tags=pulumi.get(__response__, 'tags')))
