# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AnalyzerAnalysisRuleCriteriaArgs',
    'AnalyzerAnalysisRuleCriteriaArgsDict',
    'AnalyzerArchiveRuleArgs',
    'AnalyzerArchiveRuleArgsDict',
    'AnalyzerConfigurationPropertiesArgs',
    'AnalyzerConfigurationPropertiesArgsDict',
    'AnalyzerFilterArgs',
    'AnalyzerFilterArgsDict',
    'AnalyzerTagArgs',
    'AnalyzerTagArgsDict',
    'AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgs',
    'AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgsDict',
    'AnalyzerUnusedAccessConfigurationArgs',
    'AnalyzerUnusedAccessConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class AnalyzerAnalysisRuleCriteriaArgsDict(TypedDict):
        """
        The criteria for an analysis rule for an analyzer.
        """
        account_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of AWS account IDs to apply to the analysis rule criteria. The accounts cannot include the organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for organization-level analyzers.
        """
        resource_tags: NotRequired[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['AnalyzerTagArgsDict']]]]]]
        """
        An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.

        For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with aws:.

        For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value is 0 characters, the rule is applied to all principals with the specified tag key.
        """
elif False:
    AnalyzerAnalysisRuleCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnalyzerAnalysisRuleCriteriaArgs:
    def __init__(__self__, *,
                 account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['AnalyzerTagArgs']]]]]] = None):
        """
        The criteria for an analysis rule for an analyzer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] account_ids: A list of AWS account IDs to apply to the analysis rule criteria. The accounts cannot include the organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for organization-level analyzers.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['AnalyzerTagArgs']]]]] resource_tags: An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
               
               For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with aws:.
               
               For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value is 0 characters, the rule is applied to all principals with the specified tag key.
        """
        if account_ids is not None:
            pulumi.set(__self__, "account_ids", account_ids)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)

    @property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of AWS account IDs to apply to the analysis rule criteria. The accounts cannot include the organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for organization-level analyzers.
        """
        return pulumi.get(self, "account_ids")

    @account_ids.setter
    def account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "account_ids", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['AnalyzerTagArgs']]]]]]:
        """
        An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.

        For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with aws:.

        For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value is 0 characters, the rule is applied to all principals with the specified tag key.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['AnalyzerTagArgs']]]]]]):
        pulumi.set(self, "resource_tags", value)


if not MYPY:
    class AnalyzerArchiveRuleArgsDict(TypedDict):
        """
        An Access Analyzer archive rule. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
        """
        filter: pulumi.Input[Sequence[pulumi.Input['AnalyzerFilterArgsDict']]]
        """
        The criteria for the rule.
        """
        rule_name: pulumi.Input[builtins.str]
        """
        The archive rule name
        """
elif False:
    AnalyzerArchiveRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnalyzerArchiveRuleArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[Sequence[pulumi.Input['AnalyzerFilterArgs']]],
                 rule_name: pulumi.Input[builtins.str]):
        """
        An Access Analyzer archive rule. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyzerFilterArgs']]] filter: The criteria for the rule.
        :param pulumi.Input[builtins.str] rule_name: The archive rule name
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[Sequence[pulumi.Input['AnalyzerFilterArgs']]]:
        """
        The criteria for the rule.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[Sequence[pulumi.Input['AnalyzerFilterArgs']]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[builtins.str]:
        """
        The archive rule name
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_name", value)


if not MYPY:
    class AnalyzerConfigurationPropertiesArgsDict(TypedDict):
        """
        The configuration for the analyzer
        """
        unused_access_configuration: NotRequired[pulumi.Input['AnalyzerUnusedAccessConfigurationArgsDict']]
        """
        Specifies the configuration of an unused access analyzer for an AWS organization or account.
        """
elif False:
    AnalyzerConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnalyzerConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 unused_access_configuration: Optional[pulumi.Input['AnalyzerUnusedAccessConfigurationArgs']] = None):
        """
        The configuration for the analyzer
        :param pulumi.Input['AnalyzerUnusedAccessConfigurationArgs'] unused_access_configuration: Specifies the configuration of an unused access analyzer for an AWS organization or account.
        """
        if unused_access_configuration is not None:
            pulumi.set(__self__, "unused_access_configuration", unused_access_configuration)

    @property
    @pulumi.getter(name="unusedAccessConfiguration")
    def unused_access_configuration(self) -> Optional[pulumi.Input['AnalyzerUnusedAccessConfigurationArgs']]:
        """
        Specifies the configuration of an unused access analyzer for an AWS organization or account.
        """
        return pulumi.get(self, "unused_access_configuration")

    @unused_access_configuration.setter
    def unused_access_configuration(self, value: Optional[pulumi.Input['AnalyzerUnusedAccessConfigurationArgs']]):
        pulumi.set(self, "unused_access_configuration", value)


if not MYPY:
    class AnalyzerFilterArgsDict(TypedDict):
        property: pulumi.Input[builtins.str]
        """
        The property used to define the criteria in the filter for the rule.
        """
        contains: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A "contains" condition to match for the rule.
        """
        eq: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        An "equals" condition to match for the rule.
        """
        exists: NotRequired[pulumi.Input[builtins.bool]]
        """
        An "exists" condition to match for the rule.
        """
        neq: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A "not equal" condition to match for the rule.
        """
elif False:
    AnalyzerFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnalyzerFilterArgs:
    def __init__(__self__, *,
                 property: pulumi.Input[builtins.str],
                 contains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 eq: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 exists: Optional[pulumi.Input[builtins.bool]] = None,
                 neq: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] property: The property used to define the criteria in the filter for the rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] contains: A "contains" condition to match for the rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] eq: An "equals" condition to match for the rule.
        :param pulumi.Input[builtins.bool] exists: An "exists" condition to match for the rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] neq: A "not equal" condition to match for the rule.
        """
        pulumi.set(__self__, "property", property)
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if eq is not None:
            pulumi.set(__self__, "eq", eq)
        if exists is not None:
            pulumi.set(__self__, "exists", exists)
        if neq is not None:
            pulumi.set(__self__, "neq", neq)

    @property
    @pulumi.getter
    def contains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A "contains" condition to match for the rule.
        """
        return pulumi.get(self, "contains")

    @contains.setter
    def contains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "contains", value)

    @property
    @pulumi.getter
    def eq(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An "equals" condition to match for the rule.
        """
        return pulumi.get(self, "eq")

    @eq.setter
    def eq(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "eq", value)

    @property
    @pulumi.getter
    def exists(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        An "exists" condition to match for the rule.
        """
        return pulumi.get(self, "exists")

    @exists.setter
    def exists(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exists", value)

    @property
    @pulumi.getter
    def neq(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A "not equal" condition to match for the rule.
        """
        return pulumi.get(self, "neq")

    @neq.setter
    def neq(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "neq", value)

    @property
    @pulumi.getter
    def property(self) -> pulumi.Input[builtins.str]:
        """
        The property used to define the criteria in the filter for the rule.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "property", value)


if not MYPY:
    class AnalyzerTagArgsDict(TypedDict):
        """
        A key-value pair to associate with a resource.
        """
        key: pulumi.Input[builtins.str]
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value for the tag. You can specify a value that is 0 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
elif False:
    AnalyzerTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnalyzerTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[builtins.str] key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param pulumi.Input[builtins.str] value: The value for the tag. You can specify a value that is 0 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value for the tag. You can specify a value that is 0 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgsDict(TypedDict):
        """
        Contains information about rules for the analyzer.
        """
        exclusions: NotRequired[pulumi.Input[Sequence[pulumi.Input['AnalyzerAnalysisRuleCriteriaArgsDict']]]]
        """
        A list of rules for the analyzer containing criteria to exclude from analysis. Entities that meet the rule criteria will not generate findings.
        """
elif False:
    AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgs:
    def __init__(__self__, *,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyzerAnalysisRuleCriteriaArgs']]]] = None):
        """
        Contains information about rules for the analyzer.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyzerAnalysisRuleCriteriaArgs']]] exclusions: A list of rules for the analyzer containing criteria to exclude from analysis. Entities that meet the rule criteria will not generate findings.
        """
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnalyzerAnalysisRuleCriteriaArgs']]]]:
        """
        A list of rules for the analyzer containing criteria to exclude from analysis. Entities that meet the rule criteria will not generate findings.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyzerAnalysisRuleCriteriaArgs']]]]):
        pulumi.set(self, "exclusions", value)


if not MYPY:
    class AnalyzerUnusedAccessConfigurationArgsDict(TypedDict):
        """
        The Configuration for Unused Access Analyzer
        """
        analysis_rule: NotRequired[pulumi.Input['AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgsDict']]
        """
        Contains information about rules for the analyzer.
        """
        unused_access_age: NotRequired[pulumi.Input[builtins.int]]
        """
        The specified access age in days for which to generate findings for unused access. For example, if you specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value between 1 and 365 days.
        """
elif False:
    AnalyzerUnusedAccessConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnalyzerUnusedAccessConfigurationArgs:
    def __init__(__self__, *,
                 analysis_rule: Optional[pulumi.Input['AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgs']] = None,
                 unused_access_age: Optional[pulumi.Input[builtins.int]] = None):
        """
        The Configuration for Unused Access Analyzer
        :param pulumi.Input['AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgs'] analysis_rule: Contains information about rules for the analyzer.
        :param pulumi.Input[builtins.int] unused_access_age: The specified access age in days for which to generate findings for unused access. For example, if you specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value between 1 and 365 days.
        """
        if analysis_rule is not None:
            pulumi.set(__self__, "analysis_rule", analysis_rule)
        if unused_access_age is not None:
            pulumi.set(__self__, "unused_access_age", unused_access_age)

    @property
    @pulumi.getter(name="analysisRule")
    def analysis_rule(self) -> Optional[pulumi.Input['AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgs']]:
        """
        Contains information about rules for the analyzer.
        """
        return pulumi.get(self, "analysis_rule")

    @analysis_rule.setter
    def analysis_rule(self, value: Optional[pulumi.Input['AnalyzerUnusedAccessConfigurationAnalysisRulePropertiesArgs']]):
        pulumi.set(self, "analysis_rule", value)

    @property
    @pulumi.getter(name="unusedAccessAge")
    def unused_access_age(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The specified access age in days for which to generate findings for unused access. For example, if you specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value between 1 and 365 days.
        """
        return pulumi.get(self, "unused_access_age")

    @unused_access_age.setter
    def unused_access_age(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "unused_access_age", value)


