"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkCloudwatchAutoRetention = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class CdkCloudwatchAutoRetention extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        var _b;
        super(scope, id);
        // Create Lambda function
        const handler = new aws_lambda_1.Function(this, 'LambdaCloudwatchAutoRetention', {
            handler: 'run.handler',
            code: aws_lambda_1.Code.fromAsset('functions'),
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            architecture: aws_lambda_1.Architecture.ARM_64,
            description: 'Lambda that gets triggered the first of the month. Checks all Cloudwatch log groups and changes those with never-expire to one month.',
        });
        // Set task role and permissions
        const cloudwatchListSetRetention = new aws_iam_1.PolicyStatement({
            actions: [
                'logs:DescribeLogGroups',
                'logs:PutRetentionPolicy',
            ],
            resources: ['arn:aws:logs:*:*:log-group:*'],
        });
        (_b = handler.role) === null || _b === void 0 ? void 0 : _b.attachInlinePolicy(new aws_iam_1.Policy(this, 'cloudwatch-list-set-retention', {
            statements: [cloudwatchListSetRetention],
        }));
        // Run this script once a month on the first of the month
        const rule = new aws_events_1.Rule(this, 'ScheduleCloudwatchAutoRetention', {
            schedule: aws_events_1.Schedule.cron({ minute: '0', hour: '1', day: '1' }),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(handler));
    }
}
exports.CdkCloudwatchAutoRetention = CdkCloudwatchAutoRetention;
_a = JSII_RTTI_SYMBOL_1;
CdkCloudwatchAutoRetention[_a] = { fqn: "cloudwatch-auto-retention.CdkCloudwatchAutoRetention", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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