# AUTOGENERATED! DO NOT EDIT! File to edit: ../../notebooks/api/02c_pds.apps.ipynb.

# %% auto 0
__all__ = ['find_indexes', 'get_index', 'find_instruments']

# %% ../../notebooks/api/02c_pds.apps.ipynb 3
import pandas as pd
from ..config import config
from .indexes import Index

# %% ../../notebooks/api/02c_pds.apps.ipynb 4
def find_indexes(
    instrument: str,  # Dotted mission.instrument key, e.g. cassini.iss
) -> list:            # List of configured index names
    "Find existing indexes for an instrument."
    return config.list_indexes(instrument)

# %% ../../notebooks/api/02c_pds.apps.ipynb 6
def get_index(
    instr: str,  # Dotted instrument index, e.g. cassini.iss
    index_name: str='',  # Index name, for exmample 'moon_summary. Optional'
    refresh: bool=False,  # switch to force a refresh of an index
) -> pd.DataFrame:  # The PDS index convert to pandas DataFrame
    """Example: get_index("cassini.iss", "index")"""
    if not index_name:
        index = Index(instr)
    else:
        index = Index(instr + ".indexes." + index_name)
    if not index.local_table_path.exists() or refresh:
        index.download()
    if index.update_available:
        print("An updated index is available.")
        print("Call `get_index` with `refresh=True` to get the updated version.")
    return index.parquet

# %% ../../notebooks/api/02c_pds.apps.ipynb 13
def find_instruments(
    mission: str,  # Mission string, e.g. "cassini"
) -> list:  # List of configured instrument names
    "Find existing instruments for a mission."
    return config.list_instruments(mission)
