# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.spreadsheetss = SpreadsheetsService(self)
        



class SpreadsheetsService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def condition_formats_batch_create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsConditionFormatsBatchCreateReqBody, str, str, int) -> SpreadsheetsConditionFormatsBatchCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsConditionFormatsBatchCreateReqCall(self, body, request_opts=request_opts)

    def condition_formats_batch_delete(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsConditionFormatsBatchDeleteReqBody, str, str, int) -> SpreadsheetsConditionFormatsBatchDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsConditionFormatsBatchDeleteReqCall(self, body, request_opts=request_opts)

    def condition_formats_batch_get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> SpreadsheetsConditionFormatsBatchGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsConditionFormatsBatchGetReqCall(self, request_opts=request_opts)

    def condition_formats_batch_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsConditionFormatsBatchUpdateReqBody, str, str, int) -> SpreadsheetsConditionFormatsBatchUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsConditionFormatsBatchUpdateReqCall(self, body, request_opts=request_opts)

    def data_validation_create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsDataValidationCreateReqBody, str, str, int) -> SpreadsheetsDataValidationCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsDataValidationCreateReqCall(self, body, request_opts=request_opts)

    def data_validation_delete(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsDataValidationDeleteReqBody, str, str, int) -> SpreadsheetsDataValidationDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsDataValidationDeleteReqCall(self, body, request_opts=request_opts)

    def data_validation_get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> SpreadsheetsDataValidationGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsDataValidationGetReqCall(self, request_opts=request_opts)

    def data_validation_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsDataValidationUpdateReqBody, str, str, int) -> SpreadsheetsDataValidationUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsDataValidationUpdateReqCall(self, body, request_opts=request_opts)

    def dimension_range_add(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsDimensionRangeAddReqBody, str, str, int) -> SpreadsheetsDimensionRangeAddReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsDimensionRangeAddReqCall(self, body, request_opts=request_opts)

    def dimension_range_delete(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsDimensionRangeDeleteReqBody, str, str, int) -> SpreadsheetsDimensionRangeDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsDimensionRangeDeleteReqCall(self, body, request_opts=request_opts)

    def dimension_range_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsDimensionRangeUpdateReqBody, str, str, int) -> SpreadsheetsDimensionRangeUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsDimensionRangeUpdateReqCall(self, body, request_opts=request_opts)

    def import_(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsImportReqBody, str, str, int) -> SpreadsheetsImportReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsImportReqCall(self, body, request_opts=request_opts)

    def import_result(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> SpreadsheetsImportResultReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsImportResultReqCall(self, request_opts=request_opts)

    def insert_dimension_range(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsInsertDimensionRangeReqBody, str, str, int) -> SpreadsheetsInsertDimensionRangeReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsInsertDimensionRangeReqCall(self, body, request_opts=request_opts)

    def merge_cells(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsMergeCellsReqBody, str, str, int) -> SpreadsheetsMergeCellsReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsMergeCellsReqCall(self, body, request_opts=request_opts)

    def metainfo(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> SpreadsheetsMetainfoReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsMetainfoReqCall(self, request_opts=request_opts)

    def protected_range_batch_create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsProtectedRangeBatchCreateReqBody, str, str, int) -> SpreadsheetsProtectedRangeBatchCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsProtectedRangeBatchCreateReqCall(self, body, request_opts=request_opts)

    def protected_range_batch_delete(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsProtectedRangeBatchDeleteReqBody, str, str, int) -> SpreadsheetsProtectedRangeBatchDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsProtectedRangeBatchDeleteReqCall(self, body, request_opts=request_opts)

    def protected_range_batch_get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> SpreadsheetsProtectedRangeBatchGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsProtectedRangeBatchGetReqCall(self, request_opts=request_opts)

    def protected_range_batch_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsProtectedRangeBatchUpdateReqBody, str, str, int) -> SpreadsheetsProtectedRangeBatchUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsProtectedRangeBatchUpdateReqCall(self, body, request_opts=request_opts)

    def sheets_batch_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsSheetsBatchUpdateReqBody, str, str, int) -> SpreadsheetsSheetsBatchUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsSheetsBatchUpdateReqCall(self, body, request_opts=request_opts)

    def sheets_update_properties(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsSheetsUpdatePropertiesReqBody, str, str, int) -> SpreadsheetsSheetsUpdatePropertiesReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsSheetsUpdatePropertiesReqCall(self, body, request_opts=request_opts)

    def style_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsStyleUpdateReqBody, str, str, int) -> SpreadsheetsStyleUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsStyleUpdateReqCall(self, body, request_opts=request_opts)

    def styles_batch_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsStylesBatchUpdateReqBody, str, str, int) -> SpreadsheetsStylesBatchUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsStylesBatchUpdateReqCall(self, body, request_opts=request_opts)

    def unmerge_cells(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsUnmergeCellsReqBody, str, str, int) -> SpreadsheetsUnmergeCellsReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsUnmergeCellsReqCall(self, body, request_opts=request_opts)

    def values_append(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsValuesAppendReqBody, str, str, int) -> SpreadsheetsValuesAppendReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsValuesAppendReqCall(self, body, request_opts=request_opts)

    def values_batch_get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> SpreadsheetsValuesBatchGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsValuesBatchGetReqCall(self, request_opts=request_opts)

    def values_batch_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsValuesBatchUpdateReqBody, str, str, int) -> SpreadsheetsValuesBatchUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsValuesBatchUpdateReqCall(self, body, request_opts=request_opts)

    def values_get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> SpreadsheetsValuesGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsValuesGetReqCall(self, request_opts=request_opts)

    def values_image(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsValuesImageReqBody, str, str, int) -> SpreadsheetsValuesImageReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsValuesImageReqCall(self, body, request_opts=request_opts)

    def values_prepend(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsValuesPrependReqBody, str, str, int) -> SpreadsheetsValuesPrependReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsValuesPrependReqCall(self, body, request_opts=request_opts)

    def values_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (SpreadsheetsValuesUpdateReqBody, str, str, int) -> SpreadsheetsValuesUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SpreadsheetsValuesUpdateReqCall(self, body, request_opts=request_opts)



class SpreadsheetsConditionFormatsBatchCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsConditionFormatsBatchCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsConditionFormatsBatchCreateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsConditionFormatsBatchCreateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/condition_formats/batch_create', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsConditionFormatsBatchCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsConditionFormatsBatchDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsConditionFormatsBatchDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsConditionFormatsBatchDeleteReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsConditionFormatsBatchDeleteResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/condition_formats/batch_delete', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsConditionFormatsBatchDeleteResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsConditionFormatsBatchGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (SpreadsheetsService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsConditionFormatsBatchGetReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_sheet_ids(self, sheet_ids):
        # type: (List[str]) -> SpreadsheetsConditionFormatsBatchGetReqCall
        self.query_params['sheet_ids'] = sheet_ids
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsConditionFormatsBatchGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/condition_formats', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=SpreadsheetsConditionFormatsBatchGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsConditionFormatsBatchUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsConditionFormatsBatchUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsConditionFormatsBatchUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsConditionFormatsBatchUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/condition_formats/batch_update', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsConditionFormatsBatchUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsDataValidationCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsDataValidationCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsDataValidationCreateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/dataValidation', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsDataValidationDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsDataValidationDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsDataValidationDeleteReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsDataValidationDeleteResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/dataValidation', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsDataValidationDeleteResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsDataValidationGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (SpreadsheetsService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsDataValidationGetReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_range(self, range):
        # type: (str) -> SpreadsheetsDataValidationGetReqCall
        self.path_params['range'] = range
        return self

    def set_dataValidationType(self, data_validation_type):
        # type: (str) -> SpreadsheetsDataValidationGetReqCall
        self.path_params['dataValidationType'] = data_validation_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsDataValidationGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/dataValidation', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=SpreadsheetsDataValidationGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsDataValidationUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsDataValidationUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsDataValidationUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_sheetId(self, sheet_id):
        # type: (str) -> SpreadsheetsDataValidationUpdateReqCall
        self.path_params['sheetId'] = sheet_id
        return self

    def set_dataValidationId(self, data_validation_id):
        # type: (int) -> SpreadsheetsDataValidationUpdateReqCall
        self.path_params['dataValidationId'] = data_validation_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsDataValidationUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/dataValidation/:sheetId/:dataValidationId', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsDataValidationUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsDimensionRangeAddReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsDimensionRangeAddReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsDimensionRangeAddReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsDimensionRangeAddResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/dimension_range', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsDimensionRangeAddResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsDimensionRangeDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsDimensionRangeDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsDimensionRangeDeleteReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsDimensionRangeDeleteResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/dimension_range', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsDimensionRangeDeleteResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsDimensionRangeUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsDimensionRangeUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsDimensionRangeUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/dimension_range', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsImportReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsImportReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsImportResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/sheets/v2/import', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsImportResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsImportResultReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (SpreadsheetsService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_ticket(self, ticket):
        # type: (str) -> SpreadsheetsImportResultReqCall
        self.query_params['ticket'] = ticket
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsImportResultResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/sheets/v2/import/result', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=SpreadsheetsImportResultResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsInsertDimensionRangeReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsInsertDimensionRangeReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsInsertDimensionRangeReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/insert_dimension_range', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsMergeCellsReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsMergeCellsReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsMergeCellsReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsMergeCellsResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/merge_cells', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsMergeCellsResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsMetainfoReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (SpreadsheetsService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsMetainfoReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_extFields(self, ext_fields):
        # type: (str) -> SpreadsheetsMetainfoReqCall
        self.query_params['extFields'] = ext_fields
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsMetainfoResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/metainfo', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=SpreadsheetsMetainfoResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsProtectedRangeBatchCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsProtectedRangeBatchCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsProtectedRangeBatchCreateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsProtectedRangeBatchCreateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/protected_dimension', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsProtectedRangeBatchCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsProtectedRangeBatchDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsProtectedRangeBatchDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsProtectedRangeBatchDeleteReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsProtectedRangeBatchDeleteResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/protected_range_batch_del', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsProtectedRangeBatchDeleteResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsProtectedRangeBatchGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (SpreadsheetsService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsProtectedRangeBatchGetReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_protectIds(self, protect_ids):
        # type: (List[str]) -> SpreadsheetsProtectedRangeBatchGetReqCall
        self.query_params['protectIds'] = protect_ids
        return self

    def set_memberType(self, member_type):
        # type: (str) -> SpreadsheetsProtectedRangeBatchGetReqCall
        self.query_params['memberType'] = member_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsProtectedRangeBatchGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/protected_range_batch_get', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=SpreadsheetsProtectedRangeBatchGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsProtectedRangeBatchUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsProtectedRangeBatchUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsProtectedRangeBatchUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsProtectedRangeBatchUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/protected_range_batch_update', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsProtectedRangeBatchUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsSheetsBatchUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsSheetsBatchUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsSheetsBatchUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsSheetsBatchUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/sheets_batch_update', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsSheetsBatchUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsSheetsUpdatePropertiesReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsSheetsUpdatePropertiesReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsSheetsUpdatePropertiesReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsSheetsUpdatePropertiesResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/properties', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsSheetsUpdatePropertiesResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsStyleUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsStyleUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsStyleUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsStyleUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/style', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsStyleUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsStylesBatchUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsStylesBatchUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsStylesBatchUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsStylesBatchUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/styles_batch_update', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsStylesBatchUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsUnmergeCellsReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsUnmergeCellsReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsUnmergeCellsReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsUnmergeCellsResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/unmerge_cells', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsUnmergeCellsResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsValuesAppendReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsValuesAppendReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsValuesAppendReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_insertDataOption(self, insert_data_option):
        # type: (str) -> SpreadsheetsValuesAppendReqCall
        self.query_params['insertDataOption'] = insert_data_option
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsValuesAppendResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/values_append', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsValuesAppendResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsValuesBatchGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (SpreadsheetsService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsValuesBatchGetReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_ranges(self, ranges):
        # type: (List[str]) -> SpreadsheetsValuesBatchGetReqCall
        self.query_params['ranges'] = ranges
        return self

    def set_valueRenderOption(self, value_render_option):
        # type: (str) -> SpreadsheetsValuesBatchGetReqCall
        self.query_params['valueRenderOption'] = value_render_option
        return self

    def set_dateTimeRenderOption(self, date_time_render_option):
        # type: (str) -> SpreadsheetsValuesBatchGetReqCall
        self.query_params['dateTimeRenderOption'] = date_time_render_option
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsValuesBatchGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/values_batch_get', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=SpreadsheetsValuesBatchGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsValuesBatchUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsValuesBatchUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsValuesBatchUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsValuesBatchUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/values_batch_update', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsValuesBatchUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsValuesGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (SpreadsheetsService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsValuesGetReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def set_range(self, range):
        # type: (str) -> SpreadsheetsValuesGetReqCall
        self.path_params['range'] = range
        return self

    def set_valueRenderOption(self, value_render_option):
        # type: (str) -> SpreadsheetsValuesGetReqCall
        self.query_params['valueRenderOption'] = value_render_option
        return self

    def set_dateTimeRenderOption(self, date_time_render_option):
        # type: (str) -> SpreadsheetsValuesGetReqCall
        self.query_params['dateTimeRenderOption'] = date_time_render_option
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsValuesGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/values/:range', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=SpreadsheetsValuesGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsValuesImageReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsValuesImageReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsValuesImageReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsValuesImageResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/values_image', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsValuesImageResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsValuesPrependReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsValuesPrependReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsValuesPrependReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsValuesPrependResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/values_prepend', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsValuesPrependResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpreadsheetsValuesUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpreadsheetsService, SpreadsheetsValuesUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_spreadsheetToken(self, spreadsheet_token):
        # type: (str) -> SpreadsheetsValuesUpdateReqCall
        self.path_params['spreadsheetToken'] = spreadsheet_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[SpreadsheetsValuesUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/sheets/v2/spreadsheets/:spreadsheetToken/values', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=SpreadsheetsValuesUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

