# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_no_data_field, set_user_access_token, \
    set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.bots = BotService(self)


class BotService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> BotGetReqCall

        request_opts = [set_no_data_field()]  # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return BotGetReqCall(self, request_opts=request_opts)


class BotGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (BotService, List[Any]) -> None

        self.service = service

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[BotGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('bot/v3/info', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=BotGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp
