# AUTOGENERATED! DO NOT EDIT! File to edit: ../../notebooks/01_b_download.ipynb.

# %% auto 0
__all__ = ['download_datasets']

# %% ../../notebooks/01_b_download.ipynb 27
#| code-fold: true
import os
from .utils import timer_func, find_filepaths


@timer_func  # | hide_line
def download_datasets():
    """
    Download the datasets using scripts and verifies the image counts.

    Uses `find_filepaths` to recursively find paths for all files in a directory.
    """

    data_dict = {
        1: {"script": "rocks_classifier/scripts/dataset1.sh", "filecount": 2083},
        2: {"script": "rocks_classifier/scripts/dataset2.sh", "filecount": 4553},
    }
    for dataset_id in data_dict:
        if not os.path.exists(
            os.path.join("data", "1_extracted", f"dataset{dataset_id}")
        ):
            print(f"Downloading dataset {dataset_id}...")
            os.system(f"sh {data_dict[dataset_id]['script']}")
        else:
            _, count = find_filepaths(
                os.path.join("data", "1_extracted", f"dataset{dataset_id}")
            )
            # assert count == data_dict[dataset_id]["filecount"]
            print(f"dataset{dataset_id} already exists.")
            print(f"Total Files in dataset{dataset_id}:- {count}.\n")

# %% ../../notebooks/01_b_download.ipynb 28
#| eval: false
if __name__ == "__main__":
    download_datasets()
