# pytest-zephyr-scale-integration

![PyPI](https://img.shields.io/pypi/v/pytest-zephyr-scale-integration)
![License](https://img.shields.io/badge/license-MIT-blue.svg)
![Python](https://img.shields.io/badge/python-3.6%2B-brightgreen.svg)

`pytest-zephyr-scale-integration` — это библиотека для интеграции `pytest` с Jira Zephyr (Adaptavist\TM4J). 
Она позволяет автоматически создавать тестовые циклы в Zephyr, запускать тесты и обновлять их статусы в Jira.

## Возможности

- Автоматическое создание тестовых циклов в Zephyr (с возможностью создания папки или добавления в существующую).
- Обновление статусов тестов в Jira Zephyr.
- Поддержка параметризованных тестов.
- Гибкая настройка через файл `.env`.

## Установка

Установить библиотеку можно через `pip`:
```bash
pip install pytest_zephyr_scale_integration
```

## Запуск
1. Создать файл `.env` и заполнить его полями
```commandline
# Конфигурация JIRA
JIRA_PROJECT_ID=12345 # id проекта, можно узнать вызвав `GET /rest/tests/1.0/project`
JIRA_URL='https://your-jira-instance.atlassian.net'
FOLDER_NAME='Regress v1.0.0'
```
2. Называть тесты нужно по имени ключа тест-кейса  Jira Zephyr, например, `"test_T123"`.
3. При запуске автотестов через `pyest` нужно указать дополнительные параметры: <br>
`--zephyr` - необязательный. Вкл процесса интеграции. После прохождения автотестов будет автоматически 
создан тестовый цикл. <br>
`--jira_token` - токен ТУЗ'а, у которого настроена электронная почта. Обязательное поле, если `--zephyr`.
`--zephyr_test_run_name` - необязательный. Наименования тестового цикла, по-умолчанию - "Test Run Cycle". <br>
Например, <br>
```pytest --zephyr --zephyr_test_run_name="Regress v.1.1.0"```

## Логика создания тестового цикла
- Если FOLDER_NAME в `.env` пустой, то тестовый цикл с пройденными тестами будет создан в корневой папке.
- Если FOLDER_NAME в `.env` заполнен, то:
  - Если указанная папка уже есть, то тестовый цикл создастся в ней.
  - Если указанной папки нет, то она авматотически создастся в корне и ней будет находится созданный тестовый цикл.

## Логика установки статусов тест-кейсам в Jira Zephyr
Всем тест-кейсам устанавливаются соответствующие pytest'у статусы в Jira Zephyr. <br>

Если в Jira Zephyr написан параметризованный тест, то в тестовом 
цикле он будет выглядеть как один тест с тестовыми скриптами в 
колчичестве равном набору параметров в тест-кейсе. Каждый такой набор называется `Test Script`. <br>
При автоматизации такого тест-кейса нужно делать параметризацию и в коде. Наборы в `pyest` должны идти
в том же порядке, что и в Zephyr, так как `pyest` выполняет их по порядку.

В тестовом цикле результаты прохождения одного параметризованного теста отображаются в 
шагах `Test Script'а`, чтобы можно было явно определить какой из всех наборов оказался упавшим.
Логика установки статусов у шагов параметризованных тестов:
- Если набор пройден успешно, то все шаги `Test Script'а` - PASS
- Если набор упал, то все шаги `Test Script'а` - FAIL.

Логики по сопоставлению действий в `pytest' и шагов в Zephyr нет.

Логика установки статусов и тест-кейсов:
- Если все наборы пройдены успешно, то тест-кейс - PASS
- Если хотя бы один набор упал, то тест-кейса отмечается как FAIL.

