import unittest

from transformers import ViTConfig
from transformers.testing_utils import require_torch

from .composition.test_parallel import ParallelAdapterInferenceTestMixin, ParallelTrainingMixin
from .methods import AllMethodsTestMixin
from .test_adapter import VisionAdapterTestBase, make_config
from .test_adapter_backward_compability import CompabilityTestMixin
from .test_adapter_conversion import ModelClassConversionTestMixin
from .test_adapter_fusion_common import AdapterFusionModelTestMixin
from .test_adapter_heads import PredictionHeadModelTestMixin


class ViTAdapterTestBase(VisionAdapterTestBase):
    config_class = ViTConfig
    config = make_config(
        ViTConfig,
        image_size=224,
        hidden_size=32,
        num_hidden_layers=4,
        num_attention_heads=4,
        intermediate_size=37,
    )
    feature_extractor_name = "google/vit-base-patch16-224-in21k"


@require_torch
class ViTAdapterTest(
    AllMethodsTestMixin,
    AdapterFusionModelTestMixin,
    CompabilityTestMixin,
    PredictionHeadModelTestMixin,
    ParallelAdapterInferenceTestMixin,
    ParallelTrainingMixin,
    ViTAdapterTestBase,
    unittest.TestCase,
):
    pass


@require_torch
class ViTClassConversionTest(
    ModelClassConversionTestMixin,
    ViTAdapterTestBase,
    unittest.TestCase,
):
    pass
