"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class CloudFrontMetrics {
    static requestsSum(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'Requests',
            dimensions,
            statistic: 'Sum',
        };
    }
    static totalErrorRateAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'TotalErrorRate',
            dimensions,
            statistic: 'Average',
        };
    }
    static bytesDownloadedSum(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'BytesDownloaded',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesUploadedAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'BytesUploaded',
            dimensions,
            statistic: 'Average',
        };
    }
    static _4XxErrorRateAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: '4xxErrorRate',
            dimensions,
            statistic: 'Average',
        };
    }
    static _5XxErrorRateAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: '5xxErrorRate',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.CloudFrontMetrics = CloudFrontMetrics;
//# sourceMappingURL=data:application/json;base64,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