# NinjaParser
`NinjaParser` is a Python module to parse `.ninja_log` files and print build times.

If you have been complaining about long build times you may have switched to `ninja` from `make`. If not, you should give it a [try](https://ninja-build.org/). 
Along with being faster, `ninja` also provides a log file, `.ninja_log` containing timings for each built object. 
This information can be helpful to understand the bottlenecks in your building process. However, this file needs to be parsed to be comprehensible.
`NinjaParser` prints a sorted list of built times with percentages for the top ten objects. You can also use `-f` option to filter objects that
you want to print aggregated stats.

## Usage
```
ninjaparser [-h] [-t TOP] [-f FILTER] [path ...]

Parse .ninja_log files.

positional arguments:
  path                  Path to .ninja_log file or the directory that contains it. Default is the current directory. (default: None)

optional arguments:
  -h, --help            show this help message and exit
  -t TOP, --top TOP     Print only top `n` items. Prints top 10 by default. Use -t -1 to print all. (default: 10)
  -f FILTER, --filter FILTER
                        Print aggregated stats for objects that includes the filter. Default is an empty string, no filtering. (default: )
```

## Installation

`NinjaParser` is just a single file, you can either download the file and start using it or you can use `pip` to install it.

`pip install ninjaparser`
