# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/04-deployment.ipynb (unless otherwise specified).

__all__ = ['app', 'download_mkt_prices', 'download_aircraft_accounts', 'download_installation_accounts',
           'download_all_accounts_data']

# Cell
from etswatch import prices
from .eutl import accounts

import os
import typer

# Cell
app = typer.Typer()

# Cell
@app.command()
def download_mkt_prices(data_dir='data', print_dataset_head=True):
    api_key = os.getenv('QUANDL_API_KEY')
    df_ets = prices.get_ets_mkt_data(api_key)

    df_ets.to_csv(f'{data_dir}/market_prices.csv')

    if print_dataset_head == True:
        print(f'Output Tail (n=3):\n\n{df_ets.tail(3)}')

    return

# Cell
@app.command()
def download_aircraft_accounts(data_dir='data', redownload=True, print_dataset_heads=True):
    df_search = accounts.get_search_df(data_dir=f'{data_dir}/..', redownload=redownload)

    aircraft_dfs = accounts.get_aircraft_dfs(
        df_search,
        data_dir=data_dir,
        redownload=redownload
    )

    if print_dataset_heads == True:
        for dataset_name, df in aircraft_dfs.items():
            print(f'{dataset_name} (head, n=3):\n\n{df.head(3)}\n\n\n')

    return

# Cell
@app.command()
def download_installation_accounts(data_dir='data', redownload=True, print_dataset_heads=True):
    df_search = accounts.get_search_df(data_dir=f'{data_dir}/..', redownload=redownload)

    installation_dfs = accounts.get_installation_dfs(
        df_search,
        data_dir=data_dir,
        redownload=redownload
    )

    if print_dataset_heads == True:
        for dataset_name, df in installation_dfs.items():
            print(f'{dataset_name} (head, n=3):\n\n{df.head(3)}\n\n\n')

    return

# Cell
@app.command()
def download_all_accounts_data(data_dir='data', search=True, installations=True, aircraft=True):
    all_dfs = accounts.retrieve_all_data(data_dir=data_dir, redownload_search=search, redownload_installations=installations, redownload_aircraft=aircraft)

    return

# Cell
if __name__ == '__main__' and '__file__' in globals():
    app()