"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestoreSecretRequest = exports.ReplicateSecretToRegionsResponse = exports.ReplicateSecretToRegionsRequest = exports.RemoveRegionsFromReplicationResponse = exports.RemoveRegionsFromReplicationRequest = exports.PutSecretValueResponse = exports.PutSecretValueRequest = exports.PutResourcePolicyResponse = exports.PutResourcePolicyRequest = exports.PublicPolicyException = exports.ListSecretVersionIdsResponse = exports.SecretVersionsListEntry = exports.ListSecretVersionIdsRequest = exports.ListSecretsResponse = exports.SecretListEntry = exports.ListSecretsRequest = exports.SortOrderType = exports.InvalidNextTokenException = exports.GetSecretValueResponse = exports.GetSecretValueRequest = exports.GetResourcePolicyResponse = exports.GetResourcePolicyRequest = exports.GetRandomPasswordResponse = exports.GetRandomPasswordRequest = exports.Filter = exports.DescribeSecretResponse = exports.RotationRulesType = exports.DescribeSecretRequest = exports.DeleteSecretResponse = exports.DeleteSecretRequest = exports.DeleteResourcePolicyResponse = exports.DeleteResourcePolicyRequest = exports.ResourceExistsException = exports.PreconditionNotMetException = exports.MalformedPolicyDocumentException = exports.LimitExceededException = exports.EncryptionFailure = exports.DecryptionFailure = exports.CreateSecretResponse = exports.ReplicationStatusType = exports.StatusType = exports.CreateSecretRequest = exports.Tag = exports.ResourceNotFoundException = exports.InvalidRequestException = exports.InvalidParameterException = exports.InternalServiceError = exports.CancelRotateSecretResponse = exports.CancelRotateSecretRequest = exports.ReplicaRegionType = void 0;
exports.ValidateResourcePolicyResponse = exports.ValidationErrorsEntry = exports.ValidateResourcePolicyRequest = exports.UpdateSecretVersionStageResponse = exports.UpdateSecretVersionStageRequest = exports.UpdateSecretResponse = exports.UpdateSecretRequest = exports.UntagResourceRequest = exports.TagResourceRequest = exports.StopReplicationToReplicaResponse = exports.StopReplicationToReplicaRequest = exports.RotateSecretResponse = exports.RotateSecretRequest = exports.RestoreSecretResponse = void 0;
const smithy_client_1 = require("@aws-sdk/smithy-client");
const SecretsManagerServiceException_1 = require("./SecretsManagerServiceException");
var ReplicaRegionType;
(function (ReplicaRegionType) {
    ReplicaRegionType.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ReplicaRegionType = exports.ReplicaRegionType || (exports.ReplicaRegionType = {}));
var CancelRotateSecretRequest;
(function (CancelRotateSecretRequest) {
    CancelRotateSecretRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CancelRotateSecretRequest = exports.CancelRotateSecretRequest || (exports.CancelRotateSecretRequest = {}));
var CancelRotateSecretResponse;
(function (CancelRotateSecretResponse) {
    CancelRotateSecretResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CancelRotateSecretResponse = exports.CancelRotateSecretResponse || (exports.CancelRotateSecretResponse = {}));
class InternalServiceError extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "InternalServiceError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServiceError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServiceError.prototype);
        this.Message = opts.Message;
    }
}
exports.InternalServiceError = InternalServiceError;
class InvalidParameterException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "InvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameterException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidParameterException = InvalidParameterException;
class InvalidRequestException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "InvalidRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRequestException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidRequestException = InvalidRequestException;
class ResourceNotFoundException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceNotFoundException = ResourceNotFoundException;
var Tag;
(function (Tag) {
    Tag.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(Tag = exports.Tag || (exports.Tag = {}));
var CreateSecretRequest;
(function (CreateSecretRequest) {
    CreateSecretRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.SecretBinary && { SecretBinary: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.SecretString && { SecretString: smithy_client_1.SENSITIVE_STRING }),
    });
})(CreateSecretRequest = exports.CreateSecretRequest || (exports.CreateSecretRequest = {}));
var StatusType;
(function (StatusType) {
    StatusType["Failed"] = "Failed";
    StatusType["InProgress"] = "InProgress";
    StatusType["InSync"] = "InSync";
})(StatusType = exports.StatusType || (exports.StatusType = {}));
var ReplicationStatusType;
(function (ReplicationStatusType) {
    ReplicationStatusType.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ReplicationStatusType = exports.ReplicationStatusType || (exports.ReplicationStatusType = {}));
var CreateSecretResponse;
(function (CreateSecretResponse) {
    CreateSecretResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateSecretResponse = exports.CreateSecretResponse || (exports.CreateSecretResponse = {}));
class DecryptionFailure extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "DecryptionFailure",
            $fault: "client",
            ...opts,
        });
        this.name = "DecryptionFailure";
        this.$fault = "client";
        Object.setPrototypeOf(this, DecryptionFailure.prototype);
        this.Message = opts.Message;
    }
}
exports.DecryptionFailure = DecryptionFailure;
class EncryptionFailure extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "EncryptionFailure",
            $fault: "client",
            ...opts,
        });
        this.name = "EncryptionFailure";
        this.$fault = "client";
        Object.setPrototypeOf(this, EncryptionFailure.prototype);
        this.Message = opts.Message;
    }
}
exports.EncryptionFailure = EncryptionFailure;
class LimitExceededException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.LimitExceededException = LimitExceededException;
class MalformedPolicyDocumentException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "MalformedPolicyDocumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "MalformedPolicyDocumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MalformedPolicyDocumentException.prototype);
        this.Message = opts.Message;
    }
}
exports.MalformedPolicyDocumentException = MalformedPolicyDocumentException;
class PreconditionNotMetException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "PreconditionNotMetException",
            $fault: "client",
            ...opts,
        });
        this.name = "PreconditionNotMetException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PreconditionNotMetException.prototype);
        this.Message = opts.Message;
    }
}
exports.PreconditionNotMetException = PreconditionNotMetException;
class ResourceExistsException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "ResourceExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceExistsException = ResourceExistsException;
var DeleteResourcePolicyRequest;
(function (DeleteResourcePolicyRequest) {
    DeleteResourcePolicyRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteResourcePolicyRequest = exports.DeleteResourcePolicyRequest || (exports.DeleteResourcePolicyRequest = {}));
var DeleteResourcePolicyResponse;
(function (DeleteResourcePolicyResponse) {
    DeleteResourcePolicyResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteResourcePolicyResponse = exports.DeleteResourcePolicyResponse || (exports.DeleteResourcePolicyResponse = {}));
var DeleteSecretRequest;
(function (DeleteSecretRequest) {
    DeleteSecretRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteSecretRequest = exports.DeleteSecretRequest || (exports.DeleteSecretRequest = {}));
var DeleteSecretResponse;
(function (DeleteSecretResponse) {
    DeleteSecretResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteSecretResponse = exports.DeleteSecretResponse || (exports.DeleteSecretResponse = {}));
var DescribeSecretRequest;
(function (DescribeSecretRequest) {
    DescribeSecretRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeSecretRequest = exports.DescribeSecretRequest || (exports.DescribeSecretRequest = {}));
var RotationRulesType;
(function (RotationRulesType) {
    RotationRulesType.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RotationRulesType = exports.RotationRulesType || (exports.RotationRulesType = {}));
var DescribeSecretResponse;
(function (DescribeSecretResponse) {
    DescribeSecretResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeSecretResponse = exports.DescribeSecretResponse || (exports.DescribeSecretResponse = {}));
var Filter;
(function (Filter) {
    Filter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(Filter = exports.Filter || (exports.Filter = {}));
var GetRandomPasswordRequest;
(function (GetRandomPasswordRequest) {
    GetRandomPasswordRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(GetRandomPasswordRequest = exports.GetRandomPasswordRequest || (exports.GetRandomPasswordRequest = {}));
var GetRandomPasswordResponse;
(function (GetRandomPasswordResponse) {
    GetRandomPasswordResponse.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.RandomPassword && { RandomPassword: smithy_client_1.SENSITIVE_STRING }),
    });
})(GetRandomPasswordResponse = exports.GetRandomPasswordResponse || (exports.GetRandomPasswordResponse = {}));
var GetResourcePolicyRequest;
(function (GetResourcePolicyRequest) {
    GetResourcePolicyRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(GetResourcePolicyRequest = exports.GetResourcePolicyRequest || (exports.GetResourcePolicyRequest = {}));
var GetResourcePolicyResponse;
(function (GetResourcePolicyResponse) {
    GetResourcePolicyResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(GetResourcePolicyResponse = exports.GetResourcePolicyResponse || (exports.GetResourcePolicyResponse = {}));
var GetSecretValueRequest;
(function (GetSecretValueRequest) {
    GetSecretValueRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(GetSecretValueRequest = exports.GetSecretValueRequest || (exports.GetSecretValueRequest = {}));
var GetSecretValueResponse;
(function (GetSecretValueResponse) {
    GetSecretValueResponse.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.SecretBinary && { SecretBinary: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.SecretString && { SecretString: smithy_client_1.SENSITIVE_STRING }),
    });
})(GetSecretValueResponse = exports.GetSecretValueResponse || (exports.GetSecretValueResponse = {}));
class InvalidNextTokenException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "InvalidNextTokenException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextTokenException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidNextTokenException = InvalidNextTokenException;
var SortOrderType;
(function (SortOrderType) {
    SortOrderType["asc"] = "asc";
    SortOrderType["desc"] = "desc";
})(SortOrderType = exports.SortOrderType || (exports.SortOrderType = {}));
var ListSecretsRequest;
(function (ListSecretsRequest) {
    ListSecretsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ListSecretsRequest = exports.ListSecretsRequest || (exports.ListSecretsRequest = {}));
var SecretListEntry;
(function (SecretListEntry) {
    SecretListEntry.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(SecretListEntry = exports.SecretListEntry || (exports.SecretListEntry = {}));
var ListSecretsResponse;
(function (ListSecretsResponse) {
    ListSecretsResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ListSecretsResponse = exports.ListSecretsResponse || (exports.ListSecretsResponse = {}));
var ListSecretVersionIdsRequest;
(function (ListSecretVersionIdsRequest) {
    ListSecretVersionIdsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ListSecretVersionIdsRequest = exports.ListSecretVersionIdsRequest || (exports.ListSecretVersionIdsRequest = {}));
var SecretVersionsListEntry;
(function (SecretVersionsListEntry) {
    SecretVersionsListEntry.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(SecretVersionsListEntry = exports.SecretVersionsListEntry || (exports.SecretVersionsListEntry = {}));
var ListSecretVersionIdsResponse;
(function (ListSecretVersionIdsResponse) {
    ListSecretVersionIdsResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ListSecretVersionIdsResponse = exports.ListSecretVersionIdsResponse || (exports.ListSecretVersionIdsResponse = {}));
class PublicPolicyException extends SecretsManagerServiceException_1.SecretsManagerServiceException {
    constructor(opts) {
        super({
            name: "PublicPolicyException",
            $fault: "client",
            ...opts,
        });
        this.name = "PublicPolicyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PublicPolicyException.prototype);
        this.Message = opts.Message;
    }
}
exports.PublicPolicyException = PublicPolicyException;
var PutResourcePolicyRequest;
(function (PutResourcePolicyRequest) {
    PutResourcePolicyRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PutResourcePolicyRequest = exports.PutResourcePolicyRequest || (exports.PutResourcePolicyRequest = {}));
var PutResourcePolicyResponse;
(function (PutResourcePolicyResponse) {
    PutResourcePolicyResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PutResourcePolicyResponse = exports.PutResourcePolicyResponse || (exports.PutResourcePolicyResponse = {}));
var PutSecretValueRequest;
(function (PutSecretValueRequest) {
    PutSecretValueRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.SecretBinary && { SecretBinary: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.SecretString && { SecretString: smithy_client_1.SENSITIVE_STRING }),
    });
})(PutSecretValueRequest = exports.PutSecretValueRequest || (exports.PutSecretValueRequest = {}));
var PutSecretValueResponse;
(function (PutSecretValueResponse) {
    PutSecretValueResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PutSecretValueResponse = exports.PutSecretValueResponse || (exports.PutSecretValueResponse = {}));
var RemoveRegionsFromReplicationRequest;
(function (RemoveRegionsFromReplicationRequest) {
    RemoveRegionsFromReplicationRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RemoveRegionsFromReplicationRequest = exports.RemoveRegionsFromReplicationRequest || (exports.RemoveRegionsFromReplicationRequest = {}));
var RemoveRegionsFromReplicationResponse;
(function (RemoveRegionsFromReplicationResponse) {
    RemoveRegionsFromReplicationResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RemoveRegionsFromReplicationResponse = exports.RemoveRegionsFromReplicationResponse || (exports.RemoveRegionsFromReplicationResponse = {}));
var ReplicateSecretToRegionsRequest;
(function (ReplicateSecretToRegionsRequest) {
    ReplicateSecretToRegionsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ReplicateSecretToRegionsRequest = exports.ReplicateSecretToRegionsRequest || (exports.ReplicateSecretToRegionsRequest = {}));
var ReplicateSecretToRegionsResponse;
(function (ReplicateSecretToRegionsResponse) {
    ReplicateSecretToRegionsResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ReplicateSecretToRegionsResponse = exports.ReplicateSecretToRegionsResponse || (exports.ReplicateSecretToRegionsResponse = {}));
var RestoreSecretRequest;
(function (RestoreSecretRequest) {
    RestoreSecretRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RestoreSecretRequest = exports.RestoreSecretRequest || (exports.RestoreSecretRequest = {}));
var RestoreSecretResponse;
(function (RestoreSecretResponse) {
    RestoreSecretResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RestoreSecretResponse = exports.RestoreSecretResponse || (exports.RestoreSecretResponse = {}));
var RotateSecretRequest;
(function (RotateSecretRequest) {
    RotateSecretRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RotateSecretRequest = exports.RotateSecretRequest || (exports.RotateSecretRequest = {}));
var RotateSecretResponse;
(function (RotateSecretResponse) {
    RotateSecretResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RotateSecretResponse = exports.RotateSecretResponse || (exports.RotateSecretResponse = {}));
var StopReplicationToReplicaRequest;
(function (StopReplicationToReplicaRequest) {
    StopReplicationToReplicaRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(StopReplicationToReplicaRequest = exports.StopReplicationToReplicaRequest || (exports.StopReplicationToReplicaRequest = {}));
var StopReplicationToReplicaResponse;
(function (StopReplicationToReplicaResponse) {
    StopReplicationToReplicaResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(StopReplicationToReplicaResponse = exports.StopReplicationToReplicaResponse || (exports.StopReplicationToReplicaResponse = {}));
var TagResourceRequest;
(function (TagResourceRequest) {
    TagResourceRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(TagResourceRequest = exports.TagResourceRequest || (exports.TagResourceRequest = {}));
var UntagResourceRequest;
(function (UntagResourceRequest) {
    UntagResourceRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UntagResourceRequest = exports.UntagResourceRequest || (exports.UntagResourceRequest = {}));
var UpdateSecretRequest;
(function (UpdateSecretRequest) {
    UpdateSecretRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.SecretBinary && { SecretBinary: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.SecretString && { SecretString: smithy_client_1.SENSITIVE_STRING }),
    });
})(UpdateSecretRequest = exports.UpdateSecretRequest || (exports.UpdateSecretRequest = {}));
var UpdateSecretResponse;
(function (UpdateSecretResponse) {
    UpdateSecretResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateSecretResponse = exports.UpdateSecretResponse || (exports.UpdateSecretResponse = {}));
var UpdateSecretVersionStageRequest;
(function (UpdateSecretVersionStageRequest) {
    UpdateSecretVersionStageRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateSecretVersionStageRequest = exports.UpdateSecretVersionStageRequest || (exports.UpdateSecretVersionStageRequest = {}));
var UpdateSecretVersionStageResponse;
(function (UpdateSecretVersionStageResponse) {
    UpdateSecretVersionStageResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateSecretVersionStageResponse = exports.UpdateSecretVersionStageResponse || (exports.UpdateSecretVersionStageResponse = {}));
var ValidateResourcePolicyRequest;
(function (ValidateResourcePolicyRequest) {
    ValidateResourcePolicyRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ValidateResourcePolicyRequest = exports.ValidateResourcePolicyRequest || (exports.ValidateResourcePolicyRequest = {}));
var ValidationErrorsEntry;
(function (ValidationErrorsEntry) {
    ValidationErrorsEntry.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ValidationErrorsEntry = exports.ValidationErrorsEntry || (exports.ValidationErrorsEntry = {}));
var ValidateResourcePolicyResponse;
(function (ValidateResourcePolicyResponse) {
    ValidateResourcePolicyResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ValidateResourcePolicyResponse = exports.ValidateResourcePolicyResponse || (exports.ValidateResourcePolicyResponse = {}));
