/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OGLMMetrics;
import ai.h2o.sparkling.ml.metrics.H2OOrdinalMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all ordinal metrics supported by GLM algorithm.")
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011A\u0003\u0013\u001aP\u001fJ$\u0017N\\1m\u000f2kU*\u001a;sS\u000e\u001c(BA\u0002\u0005\u0003\u001diW\r\u001e:jGNT!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003%\u0019\b/\u0019:lY&twM\u0003\u0002\n\u0015\u0005\u0019\u0001NM8\u000b\u0003-\t!!Y5\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!!\u0005%3\u001f>\u0013H-\u001b8bY6+GO]5dgB\u0011qbE\u0005\u0003)\t\u0011Q\u0002\u0013\u001aP\u000f2kU*\u001a;sS\u000e\u001c\b\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011I\f\u0002\u0007ULG-F\u0001\u0019!\tIrD\u0004\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2$\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0005\u0012aa\u0015;sS:<'B\u0001\u0010\u001c\u0011!\u0019\u0003A!A!\u0002\u0013A\u0012\u0001B;jI\u0002BQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDCA\u0014)!\ty\u0001\u0001C\u0003\u0017I\u0001\u0007\u0001\u0004C\u0003&\u0001\u0011\u0005!\u0006F\u0001(\u0011\u001da\u0003A1A\u0005\u00125\n\u0001C]3tS\u0012,\u0018\r\u001c#fm&\fgnY3\u0016\u00039\u0002\"aL\u001d\u000e\u0003AR!!\r\u001a\u0002\u000bA\f'/Y7\u000b\u0005\u0015\u0019$B\u0001\u001b6\u0003\u0015\u0019\b/\u0019:l\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\u0002$a\u0003#pk\ndW\rU1sC6Da\u0001\u0010\u0001!\u0002\u0013q\u0013!\u0005:fg&$W/\u00197EKZL\u0017M\\2fA!9a\b\u0001b\u0001\n#i\u0013\u0001\u00048vY2$UM^5b]\u000e,\u0007B\u0002!\u0001A\u0003%a&A\u0007ok2dG)\u001a<jC:\u001cW\r\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0005.\u0003\r\t\u0017n\u0019\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u0018\u0002\t\u0005L7\r\t\u0005\b\r\u0002\u0011\r\u0011\"\u0005H\u0003QqW\u000f\u001c7EK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[V\t\u0001\n\u0005\u00020\u0013&\u0011!\n\r\u0002\n\u0019>tw\rU1sC6Da\u0001\u0014\u0001!\u0002\u0013A\u0015!\u00068vY2$Um\u001a:fKN|eM\u0012:fK\u0012|W\u000e\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0005H\u0003a\u0011Xm]5ek\u0006dG)Z4sK\u0016\u001cxJ\u001a$sK\u0016$w.\u001c\u0005\u0007!\u0002\u0001\u000b\u0011\u0002%\u00023I,7/\u001b3vC2$Um\u001a:fKN|eM\u0012:fK\u0012|W\u000e\t\u0005\u0006%\u0002!\taU\u0001\u0014O\u0016$(+Z:jIV\fG\u000eR3wS\u0006t7-\u001a\u000b\u0002)B\u0011!$V\u0005\u0003-n\u0011a\u0001R8vE2,\u0007\"\u0002-\u0001\t\u0003\u0019\u0016aD4fi:+H\u000e\u001c#fm&\fgnY3\t\u000bi\u0003A\u0011A*\u0002\r\u001d,G/Q%D\u0011\u0015a\u0006\u0001\"\u0001^\u0003]9W\r\u001e(vY2$Um\u001a:fKN|eM\u0012:fK\u0012|W\u000eF\u0001_!\tQr,\u0003\u0002a7\t!Aj\u001c8h\u0011\u0015\u0011\u0007\u0001\"\u0001^\u0003m9W\r\u001e*fg&$W/\u00197EK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[\")A\r\u0001C!K\u0006Q1/\u001a;NKR\u0014\u0018nY:\u0015\u0007\u0019LW\u000f\u0005\u0002\u001bO&\u0011\u0001n\u0007\u0002\u0005+:LG\u000fC\u0003kG\u0002\u00071.\u0001\u0003kg>t\u0007C\u00017t\u001b\u0005i'B\u00018p\u0003\u001197o\u001c8\u000b\u0005A\f\u0018AB4p_\u001edWMC\u0001s\u0003\r\u0019w.\\\u0005\u0003i6\u0014!BS:p]>\u0013'.Z2u\u0011\u001518\r1\u0001\u0019\u0003\u001d\u0019wN\u001c;fqRDQ\u0001\u001f\u0001\u0005Be\fAaY8qsR\u0011!p_\u0007\u0002\u0001!)Ap\u001ea\u0001{\u0006)Q\r\u001f;sCB\u0011qF`\u0005\u0003\u007fB\u0012\u0001\u0002U1sC6l\u0015\r\u001d\u0015\b\u0001\u0005\r\u0011\u0011BA\u0006!\ry\u0011QA\u0005\u0004\u0003\u000f\u0011!AE'fiJL7m\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\u0012\u0011QB\u0001J)\",\u0007e\u00197bgN\u0004S.Y6fg\u0002\ng/Y5mC\ndW\rI1mY\u0002z'\u000fZ5oC2\u0004S.\u001a;sS\u000e\u001c\be];qa>\u0014H/\u001a3!Ef\u0004s\tT'!C2<wN]5uQ6t\u0003")
public class H2OOrdinalGLMMetrics
extends H2OOrdinalMetrics
implements H2OGLMMetrics {
    private final String uid;
    private final DoubleParam residualDeviance;
    private final DoubleParam nullDeviance;
    private final DoubleParam aic;
    private final LongParam nullDegreesOfFreedom;
    private final LongParam residualDegreesOfFreedom;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam residualDeviance() {
        return this.residualDeviance;
    }

    public DoubleParam nullDeviance() {
        return this.nullDeviance;
    }

    public DoubleParam aic() {
        return this.aic;
    }

    public LongParam nullDegreesOfFreedom() {
        return this.nullDegreesOfFreedom;
    }

    public LongParam residualDegreesOfFreedom() {
        return this.residualDegreesOfFreedom;
    }

    @Override
    public double getResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.residualDeviance()));
    }

    @Override
    public double getNullDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.nullDeviance()));
    }

    @Override
    public double getAIC() {
        return BoxesRunTime.unboxToDouble(this.$(this.aic()));
    }

    @Override
    public long getNullDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.nullDegreesOfFreedom()));
    }

    @Override
    public long getResidualDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.residualDegreesOfFreedom()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        Params params4;
        super.setMetrics(json, context);
        if (json.has("residual_deviance")) {
            try {
                params4 = this.set("residualDeviance", BoxesRunTime.boxToDouble((double)json.get("residual_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params4 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params4 = BoxedUnit.UNIT;
        }
        if (json.has("null_deviance")) {
            try {
                params3 = this.set("nullDeviance", BoxesRunTime.boxToDouble((double)json.get("null_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("AIC")) {
            try {
                params2 = this.set("aic", BoxesRunTime.boxToDouble((double)json.get("AIC").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'AIC' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'AIC' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("null_degrees_of_freedom")) {
            try {
                params = this.set("nullDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("null_degrees_of_freedom").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("residual_degrees_of_freedom")) {
            try {
                this.set("residualDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("residual_degrees_of_freedom").getAsLong()));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 == null) throw throwable;
                Throwable throwable11 = throwable10;
                String string = System.getProperty("spark.testing", "false");
                String string10 = "true";
                if (string == null) {
                    if (string10 == null) throw throwable;
                } else if (string.equals(string10)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable11);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null) {
                if (string11 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string11)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$5;

                public final String apply() {
                    return this.message$5;
                }
                {
                    this.message$5 = message$5;
                }
            });
            return;
        }
    }

    @Override
    public H2OOrdinalGLMMetrics copy(ParamMap extra) {
        return (H2OOrdinalGLMMetrics)this.defaultCopy(extra);
    }

    public H2OOrdinalGLMMetrics(String uid) {
        this.uid = uid;
        this.residualDeviance = this.doubleParam("residualDeviance", "residual deviance.");
        this.nullDeviance = this.doubleParam("nullDeviance", "null deviance.");
        this.aic = this.doubleParam("aic", "AIC.");
        this.nullDegreesOfFreedom = this.longParam("nullDegreesOfFreedom", "null DOF.");
        this.residualDegreesOfFreedom = this.longParam("residualDegreesOfFreedom", "residual DOF.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.residualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.nullDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aic().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OOrdinalGLMMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OOrdinalGLMMetrics"));
    }
}

