# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from leo_station_keeping.models.along_track_tolerance import AlongTrackTolerance
    from leo_station_keeping.models.sma_tolerance import SmaTolerance

class Tolerance(BaseModel):
    """
    The station keeping window, defined either by specifying the maximum value allowed for the semi-major axis decay due to drag (SMA tolerance), or by  specifying the size of an along-track box in which the spacecraft must remain  (ALONG_TRACK tolerance).   Every time the box is crossed, a maneuver is performed in order to bring the  spacecraft above the initial orbit.  
    """ # noqa: E501
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SMA', 'ALONG_TRACK']):
            raise ValueError("must be one of enum values ('SMA', 'ALONG_TRACK')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'ALONG_TRACK': 'AlongTrackTolerance','SMA': 'SmaTolerance'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[AlongTrackTolerance, SmaTolerance]]:
        """Create an instance of Tolerance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[AlongTrackTolerance, SmaTolerance]]:
        """Create an instance of Tolerance from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'AlongTrackTolerance':
            return import_module("leo_station_keeping.models.along_track_tolerance").AlongTrackTolerance.from_dict(obj)
        if object_type ==  'SmaTolerance':
            return import_module("leo_station_keeping.models.sma_tolerance").SmaTolerance.from_dict(obj)

        raise ValueError("Tolerance failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


