# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from leo_station_keeping.models.body_solar_array import BodySolarArray
    from leo_station_keeping.models.deployable_fixed_solar_array import DeployableFixedSolarArray
    from leo_station_keeping.models.deployable_rotating_solar_array import DeployableRotatingSolarArray

class SolarArray(BaseModel):
    """
    SolarArray
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="The type of solar array")
    __properties: ClassVar[List[str]] = ["type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BODY', 'DEPLOYABLE_FIXED', 'DEPLOYABLE_ROTATING']):
            raise ValueError("must be one of enum values ('BODY', 'DEPLOYABLE_FIXED', 'DEPLOYABLE_ROTATING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'BODY': 'BodySolarArray','DEPLOYABLE_FIXED': 'DeployableFixedSolarArray','DEPLOYABLE_ROTATING': 'DeployableRotatingSolarArray'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[BodySolarArray, DeployableFixedSolarArray, DeployableRotatingSolarArray]]:
        """Create an instance of SolarArray from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[BodySolarArray, DeployableFixedSolarArray, DeployableRotatingSolarArray]]:
        """Create an instance of SolarArray from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'BodySolarArray':
            return import_module("leo_station_keeping.models.body_solar_array").BodySolarArray.from_dict(obj)
        if object_type ==  'DeployableFixedSolarArray':
            return import_module("leo_station_keeping.models.deployable_fixed_solar_array").DeployableFixedSolarArray.from_dict(obj)
        if object_type ==  'DeployableRotatingSolarArray':
            return import_module("leo_station_keeping.models.deployable_rotating_solar_array").DeployableRotatingSolarArray.from_dict(obj)

        raise ValueError("SolarArray failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


