# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from leo_station_keeping.models.circular_altitude_orbit_parameters import CircularAltitudeOrbitParameters
    from leo_station_keeping.models.circular_ground_track_repeated_orbit_parameters import CircularGroundTrackRepeatedOrbitParameters
    from leo_station_keeping.models.elliptical_ground_track_repeated_eccentricity_orbit_parameters import EllipticalGroundTrackRepeatedEccentricityOrbitParameters
    from leo_station_keeping.models.elliptical_perigee_alt_apogee_alt_orbit_parameters import EllipticalPerigeeAltApogeeAltOrbitParameters
    from leo_station_keeping.models.elliptical_perigee_alt_eccentricity_orbit_parameters import EllipticalPerigeeAltEccentricityOrbitParameters
    from leo_station_keeping.models.elliptical_sma_eccentricity_orbit_parameters import EllipticalSmaEccentricityOrbitParameters

class OrbitParameters(BaseModel):
    """
    The orbit parameters
    """ # noqa: E501
    parameters_type: Optional[StrictStr] = Field(default=None, description="The orbit parameters type", alias="parametersType")
    __properties: ClassVar[List[str]] = ["parametersType"]

    @field_validator('parameters_type')
    def parameters_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CIRCULAR_ALTITUDE', 'CIRCULAR_GROUND_TRACK_REPEATED', 'ELLIPTICAL_PERIGEE_ALTITUDE_ECC', 'ELLIPTICAL_GROUND_TRACK_REPEATED_ECC', 'ELLIPTICAL_PERIGEE_ALTITUDE_APOGEE_ALTITUDE', 'ELLIPTICAL_SMA_ECC']):
            raise ValueError("must be one of enum values ('CIRCULAR_ALTITUDE', 'CIRCULAR_GROUND_TRACK_REPEATED', 'ELLIPTICAL_PERIGEE_ALTITUDE_ECC', 'ELLIPTICAL_GROUND_TRACK_REPEATED_ECC', 'ELLIPTICAL_PERIGEE_ALTITUDE_APOGEE_ALTITUDE', 'ELLIPTICAL_SMA_ECC')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'parametersType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'CIRCULAR_ALTITUDE': 'CircularAltitudeOrbitParameters','CIRCULAR_GROUND_TRACK_REPEATED': 'CircularGroundTrackRepeatedOrbitParameters','ELLIPTICAL_GROUND_TRACK_REPEATED_ECC': 'EllipticalGroundTrackRepeatedEccentricityOrbitParameters','ELLIPTICAL_PERIGEE_ALTITUDE_APOGEE_ALTITUDE': 'EllipticalPerigeeAltApogeeAltOrbitParameters','ELLIPTICAL_PERIGEE_ALTITUDE_ECC': 'EllipticalPerigeeAltEccentricityOrbitParameters','ELLIPTICAL_SMA_ECC': 'EllipticalSmaEccentricityOrbitParameters'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[CircularAltitudeOrbitParameters, CircularGroundTrackRepeatedOrbitParameters, EllipticalGroundTrackRepeatedEccentricityOrbitParameters, EllipticalPerigeeAltApogeeAltOrbitParameters, EllipticalPerigeeAltEccentricityOrbitParameters, EllipticalSmaEccentricityOrbitParameters]]:
        """Create an instance of OrbitParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[CircularAltitudeOrbitParameters, CircularGroundTrackRepeatedOrbitParameters, EllipticalGroundTrackRepeatedEccentricityOrbitParameters, EllipticalPerigeeAltApogeeAltOrbitParameters, EllipticalPerigeeAltEccentricityOrbitParameters, EllipticalSmaEccentricityOrbitParameters]]:
        """Create an instance of OrbitParameters from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'CircularAltitudeOrbitParameters':
            return import_module("leo_station_keeping.models.circular_altitude_orbit_parameters").CircularAltitudeOrbitParameters.from_dict(obj)
        if object_type ==  'CircularGroundTrackRepeatedOrbitParameters':
            return import_module("leo_station_keeping.models.circular_ground_track_repeated_orbit_parameters").CircularGroundTrackRepeatedOrbitParameters.from_dict(obj)
        if object_type ==  'EllipticalGroundTrackRepeatedEccentricityOrbitParameters':
            return import_module("leo_station_keeping.models.elliptical_ground_track_repeated_eccentricity_orbit_parameters").EllipticalGroundTrackRepeatedEccentricityOrbitParameters.from_dict(obj)
        if object_type ==  'EllipticalPerigeeAltApogeeAltOrbitParameters':
            return import_module("leo_station_keeping.models.elliptical_perigee_alt_apogee_alt_orbit_parameters").EllipticalPerigeeAltApogeeAltOrbitParameters.from_dict(obj)
        if object_type ==  'EllipticalPerigeeAltEccentricityOrbitParameters':
            return import_module("leo_station_keeping.models.elliptical_perigee_alt_eccentricity_orbit_parameters").EllipticalPerigeeAltEccentricityOrbitParameters.from_dict(obj)
        if object_type ==  'EllipticalSmaEccentricityOrbitParameters':
            return import_module("leo_station_keeping.models.elliptical_sma_eccentricity_orbit_parameters").EllipticalSmaEccentricityOrbitParameters.from_dict(obj)

        raise ValueError("OrbitParameters failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


