# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from leo_station_keeping.models.advanced_orbit_parameters import AdvancedOrbitParameters
from leo_station_keeping.models.orbit_parameters import OrbitParameters
from typing import Optional, Set
from typing_extensions import Self

class Orbit(BaseModel):
    """
    Orbit
    """ # noqa: E501
    inclination: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description=" The orbit inclination (in radians)")
    sma: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The orbit semi-major axis (in meters)")
    eccentricity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The orbit eccentricity")
    parameters: Optional[OrbitParameters] = None
    advanced_parameters: Optional[AdvancedOrbitParameters] = Field(default=None, alias="advancedParameters")
    __properties: ClassVar[List[str]] = ["inclination", "sma", "eccentricity", "parameters", "advancedParameters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Orbit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parameters
        if self.parameters:
            _dict['parameters'] = self.parameters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of advanced_parameters
        if self.advanced_parameters:
            _dict['advancedParameters'] = self.advanced_parameters.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Orbit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "inclination": obj.get("inclination"),
            "sma": obj.get("sma"),
            "eccentricity": obj.get("eccentricity"),
            "parameters": OrbitParameters.from_dict(obj["parameters"]) if obj.get("parameters") is not None else None,
            "advancedParameters": AdvancedOrbitParameters.from_dict(obj["advancedParameters"]) if obj.get("advancedParameters") is not None else None
        })
        return _obj


