# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class NumericalLeoStationKeepingResponseThrustEphemerides(BaseModel):
    """
    TODO
    """ # noqa: E501
    timestamps: Optional[List[StrictStr]] = Field(default=None, description="The timestamps of the thrust ephemerides")
    direction_delta: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="The direction delta at each time step", alias="directionDelta")
    direction_alpha: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="The direction alpha at each time step", alias="directionAlpha")
    total_consumption: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="The thruster total consumption (in kg) at each time step", alias="totalConsumption")
    __properties: ClassVar[List[str]] = ["timestamps", "directionDelta", "directionAlpha", "totalConsumption"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponseThrustEphemerides from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponseThrustEphemerides from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timestamps": obj.get("timestamps"),
            "directionDelta": obj.get("directionDelta"),
            "directionAlpha": obj.get("directionAlpha"),
            "totalConsumption": obj.get("totalConsumption")
        })
        return _obj


