# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from leo_station_keeping.models.mean_or_osculating_spacecraft_states import MeanOrOsculatingSpacecraftStates
from leo_station_keeping.models.numerical_leo_station_keeping_response_spacecraft_states_thrusting_inner import NumericalLeoStationKeepingResponseSpacecraftStatesThrustingInner
from typing import Optional, Set
from typing_extensions import Self

class NumericalLeoStationKeepingResponseSpacecraftStates(BaseModel):
    """
    The spacecraft states during all the simulation duration.   The timestamp of the spacecraft states depends on the orbit altitude: <ul>   <li>For LEO orbits, the spacecraft states are computed every <b>2 minutes</b>.</li>   <li>For GEO orbits, the spacecraft states are computed every <b>10 minutes</b>.</li> </ul> 
    """ # noqa: E501
    mu: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The gravitational constant of the central body")
    ephemerides_frame: Optional[StrictStr] = Field(default=None, description="The ephemerides frame", alias="ephemeridesFrame")
    timestamps: Optional[List[StrictStr]] = Field(default=None, description="The timestamps of the mean spacecraft states")
    thrusting: Optional[List[NumericalLeoStationKeepingResponseSpacecraftStatesThrustingInner]] = Field(default=None, description="List of thrusting periods")
    mass: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="The mass of the spacecraft at each time step")
    mean: Optional[MeanOrOsculatingSpacecraftStates] = None
    osculating: Optional[MeanOrOsculatingSpacecraftStates] = None
    __properties: ClassVar[List[str]] = ["mu", "ephemeridesFrame", "timestamps", "thrusting", "mass", "mean", "osculating"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponseSpacecraftStates from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in thrusting (list)
        _items = []
        if self.thrusting:
            for _item in self.thrusting:
                if _item:
                    _items.append(_item.to_dict())
            _dict['thrusting'] = _items
        # override the default output from pydantic by calling `to_dict()` of mean
        if self.mean:
            _dict['mean'] = self.mean.to_dict()
        # override the default output from pydantic by calling `to_dict()` of osculating
        if self.osculating:
            _dict['osculating'] = self.osculating.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponseSpacecraftStates from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "mu": obj.get("mu"),
            "ephemeridesFrame": obj.get("ephemeridesFrame"),
            "timestamps": obj.get("timestamps"),
            "thrusting": [NumericalLeoStationKeepingResponseSpacecraftStatesThrustingInner.from_dict(_item) for _item in obj["thrusting"]] if obj.get("thrusting") is not None else None,
            "mass": obj.get("mass"),
            "mean": MeanOrOsculatingSpacecraftStates.from_dict(obj["mean"]) if obj.get("mean") is not None else None,
            "osculating": MeanOrOsculatingSpacecraftStates.from_dict(obj["osculating"]) if obj.get("osculating") is not None else None
        })
        return _obj


