# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from leo_station_keeping.models.orbit import Orbit
from typing import Optional, Set
from typing_extensions import Self

class NumericalLeoStationKeepingResponseResults(BaseModel):
    """
    The results of the numerical LEO Station Keeping, at the end of the simulation. 
    """ # noqa: E501
    number_of_burns: Optional[StrictInt] = Field(default=None, description="The total number of burns required to reach the target orbit. ", alias="numberOfBurns")
    thrust_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total thrust duration required to reach the target orbit. ", alias="thrustDuration")
    used_propellant: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total propellant mass used to reach the target orbit. ", alias="usedPropellant")
    delta_v: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total delta-V required to reach the target orbit. ", alias="deltaV")
    thruster_mean_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The mean duty cycle of the thruster during the mission. ", alias="thrusterMeanDutyCycle")
    total_warmup_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total warm-up duty cycle of the thruster during the mission. ", alias="totalWarmupDutyCycle")
    mean_burn_duration_estimation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The mean burn duration estimation. ", alias="meanBurnDurationEstimation")
    mission_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total mission duration. ", alias="missionDuration")
    number_of_periods: Optional[StrictInt] = Field(default=None, description="The total number of periods. ", alias="numberOfPeriods")
    total_impulse: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total impulse. ", alias="totalImpulse")
    final_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The final duty cycle. ", alias="finalDutyCycle")
    maneuver_model: Optional[StrictStr] = Field(default=None, description="The maneuver model. ", alias="maneuverModel")
    final_orbit: Optional[Orbit] = Field(default=None, alias="finalOrbit")
    __properties: ClassVar[List[str]] = ["numberOfBurns", "thrustDuration", "usedPropellant", "deltaV", "thrusterMeanDutyCycle", "totalWarmupDutyCycle", "meanBurnDurationEstimation", "missionDuration", "numberOfPeriods", "totalImpulse", "finalDutyCycle", "maneuverModel", "finalOrbit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponseResults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of final_orbit
        if self.final_orbit:
            _dict['finalOrbit'] = self.final_orbit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponseResults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "numberOfBurns": obj.get("numberOfBurns"),
            "thrustDuration": obj.get("thrustDuration"),
            "usedPropellant": obj.get("usedPropellant"),
            "deltaV": obj.get("deltaV"),
            "thrusterMeanDutyCycle": obj.get("thrusterMeanDutyCycle"),
            "totalWarmupDutyCycle": obj.get("totalWarmupDutyCycle"),
            "meanBurnDurationEstimation": obj.get("meanBurnDurationEstimation"),
            "missionDuration": obj.get("missionDuration"),
            "numberOfPeriods": obj.get("numberOfPeriods"),
            "totalImpulse": obj.get("totalImpulse"),
            "finalDutyCycle": obj.get("finalDutyCycle"),
            "maneuverModel": obj.get("maneuverModel"),
            "finalOrbit": Orbit.from_dict(obj["finalOrbit"]) if obj.get("finalOrbit") is not None else None
        })
        return _obj


