# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from leo_station_keeping.models.numerical_leo_station_keeping_response_field_indexes_inner import NumericalLeoStationKeepingResponseFieldIndexesInner
from leo_station_keeping.models.numerical_leo_station_keeping_response_orbital_ephemerides import NumericalLeoStationKeepingResponseOrbitalEphemerides
from leo_station_keeping.models.numerical_leo_station_keeping_response_results import NumericalLeoStationKeepingResponseResults
from leo_station_keeping.models.numerical_leo_station_keeping_response_spacecraft_states import NumericalLeoStationKeepingResponseSpacecraftStates
from leo_station_keeping.models.numerical_leo_station_keeping_response_thrust_ephemerides import NumericalLeoStationKeepingResponseThrustEphemerides
from typing import Optional, Set
from typing_extensions import Self

class NumericalLeoStationKeepingResponse(BaseModel):
    """
    NumericalLeoStationKeepingResponse
    """ # noqa: E501
    results: Optional[NumericalLeoStationKeepingResponseResults] = None
    spacecraft_states: Optional[NumericalLeoStationKeepingResponseSpacecraftStates] = Field(default=None, alias="spacecraftStates")
    ephemerides: Optional[List[List[Union[StrictFloat, StrictInt]]]] = Field(default=None, description="A list of all the requested ephemerides at each timestep")
    field_indexes: Optional[List[NumericalLeoStationKeepingResponseFieldIndexesInner]] = Field(default=None, description="A map between the generated ephemerides labels and their indexes in the ephemerides array", alias="fieldIndexes")
    orbital_ephemerides: Optional[NumericalLeoStationKeepingResponseOrbitalEphemerides] = Field(default=None, alias="orbitalEphemerides")
    thrust_ephemerides: Optional[NumericalLeoStationKeepingResponseThrustEphemerides] = Field(default=None, alias="thrustEphemerides")
    errors: Optional[List[StrictStr]] = None
    warnings: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["results", "spacecraftStates", "ephemerides", "fieldIndexes", "orbitalEphemerides", "thrustEphemerides", "errors", "warnings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of results
        if self.results:
            _dict['results'] = self.results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spacecraft_states
        if self.spacecraft_states:
            _dict['spacecraftStates'] = self.spacecraft_states.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in field_indexes (list)
        _items = []
        if self.field_indexes:
            for _item in self.field_indexes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fieldIndexes'] = _items
        # override the default output from pydantic by calling `to_dict()` of orbital_ephemerides
        if self.orbital_ephemerides:
            _dict['orbitalEphemerides'] = self.orbital_ephemerides.to_dict()
        # override the default output from pydantic by calling `to_dict()` of thrust_ephemerides
        if self.thrust_ephemerides:
            _dict['thrustEphemerides'] = self.thrust_ephemerides.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "results": NumericalLeoStationKeepingResponseResults.from_dict(obj["results"]) if obj.get("results") is not None else None,
            "spacecraftStates": NumericalLeoStationKeepingResponseSpacecraftStates.from_dict(obj["spacecraftStates"]) if obj.get("spacecraftStates") is not None else None,
            "ephemerides": obj.get("ephemerides"),
            "fieldIndexes": [NumericalLeoStationKeepingResponseFieldIndexesInner.from_dict(_item) for _item in obj["fieldIndexes"]] if obj.get("fieldIndexes") is not None else None,
            "orbitalEphemerides": NumericalLeoStationKeepingResponseOrbitalEphemerides.from_dict(obj["orbitalEphemerides"]) if obj.get("orbitalEphemerides") is not None else None,
            "thrustEphemerides": NumericalLeoStationKeepingResponseThrustEphemerides.from_dict(obj["thrustEphemerides"]) if obj.get("thrustEphemerides") is not None else None,
            "errors": obj.get("errors"),
            "warnings": obj.get("warnings")
        })
        return _obj


