# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides(BaseModel):
    """
    Configuration of the interpolated ephemerides that have to be generated. 
    """ # noqa: E501
    types: Optional[List[StrictStr]] = Field(default=None, description="The types of ephemerides to generate.  ")
    timestep: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The time step (in seconds) at which the ephemerides have to be generated.  This is the time step at which the ephemerides are interpolated.  The smaller the time step, the more accurate the ephemerides but the longer the computation time. ")
    mean: Optional[StrictBool] = Field(default=False, description="Indicates whether mean ephemerides have to be generated or not.  These elements account for secular and long periodic variations only.  This means that the short periodic effects (less than the orbital period) of  perturbations are filtered out. Thus, mean elements change slowly with time  (except for the anomaly). Usually they can be derived from analytical theories or  by numerical procedures.  Mean ephemerides request adds an extra step to the computation, so it may take longer.  ")
    osculating: Optional[StrictBool] = Field(default=False, description="Indicates whether osculating ephemerides have to be generated or not.   Osculating elements are the instantaneous values of the orbital elements at a given time.  They are the most accurate representation of the orbit at a given time.   However, they are not suitable for long-term propagation because they are subject to  short-periodic variations due to perturbations. ")
    __properties: ClassVar[List[str]] = ["types", "timestep", "mean", "osculating"]

    @field_validator('types')
    def types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['CARTESIAN', 'KEPLERIAN']):
                raise ValueError("each list item must be one of ('CARTESIAN', 'KEPLERIAN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "types": obj.get("types"),
            "timestep": obj.get("timestep"),
            "mean": obj.get("mean") if obj.get("mean") is not None else False,
            "osculating": obj.get("osculating") if obj.get("osculating") is not None else False
        })
        return _obj


