# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from leo_station_keeping.models.numerical_leo_station_keeping_request_outputs_orbital_ephemerides import NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides
from leo_station_keeping.models.numerical_leo_station_keeping_request_outputs_spacecraft_states import NumericalLeoStationKeepingRequestOutputsSpacecraftStates
from leo_station_keeping.models.numerical_leo_station_keeping_request_outputs_thrust_ephemerides import NumericalLeoStationKeepingRequestOutputsThrustEphemerides
from typing import Optional, Set
from typing_extensions import Self

class NumericalLeoStationKeepingRequestOutputs(BaseModel):
    """
    Configuration of the expected computation outputs. 
    """ # noqa: E501
    thrust_ephemerides: Optional[NumericalLeoStationKeepingRequestOutputsThrustEphemerides] = Field(default=None, alias="thrustEphemerides")
    orbital_ephemerides: Optional[NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides] = Field(default=None, alias="orbitalEphemerides")
    spacecraft_states: Optional[NumericalLeoStationKeepingRequestOutputsSpacecraftStates] = Field(default=None, alias="spacecraftStates")
    __properties: ClassVar[List[str]] = ["thrustEphemerides", "orbitalEphemerides", "spacecraftStates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingRequestOutputs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of thrust_ephemerides
        if self.thrust_ephemerides:
            _dict['thrustEphemerides'] = self.thrust_ephemerides.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbital_ephemerides
        if self.orbital_ephemerides:
            _dict['orbitalEphemerides'] = self.orbital_ephemerides.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spacecraft_states
        if self.spacecraft_states:
            _dict['spacecraftStates'] = self.spacecraft_states.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalLeoStationKeepingRequestOutputs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "thrustEphemerides": NumericalLeoStationKeepingRequestOutputsThrustEphemerides.from_dict(obj["thrustEphemerides"]) if obj.get("thrustEphemerides") is not None else None,
            "orbitalEphemerides": NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides.from_dict(obj["orbitalEphemerides"]) if obj.get("orbitalEphemerides") is not None else None,
            "spacecraftStates": NumericalLeoStationKeepingRequestOutputsSpacecraftStates.from_dict(obj["spacecraftStates"]) if obj.get("spacecraftStates") is not None else None
        })
        return _obj


