# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from leo_station_keeping.models.mean_or_osculating_spacecraft_states_attitude import MeanOrOsculatingSpacecraftStatesAttitude
from leo_station_keeping.models.mean_or_osculating_spacecraft_states_pv_coordinates import MeanOrOsculatingSpacecraftStatesPvCoordinates
from typing import Optional, Set
from typing_extensions import Self

class MeanOrOsculatingSpacecraftStates(BaseModel):
    """
    The mean or osculating spacecraft states during all the simulation duration. 
    """ # noqa: E501
    pv_coordinates: Optional[MeanOrOsculatingSpacecraftStatesPvCoordinates] = Field(default=None, alias="pvCoordinates")
    attitude: Optional[MeanOrOsculatingSpacecraftStatesAttitude] = None
    __properties: ClassVar[List[str]] = ["pvCoordinates", "attitude"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeanOrOsculatingSpacecraftStates from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pv_coordinates
        if self.pv_coordinates:
            _dict['pvCoordinates'] = self.pv_coordinates.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attitude
        if self.attitude:
            _dict['attitude'] = self.attitude.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeanOrOsculatingSpacecraftStates from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pvCoordinates": MeanOrOsculatingSpacecraftStatesPvCoordinates.from_dict(obj["pvCoordinates"]) if obj.get("pvCoordinates") is not None else None,
            "attitude": MeanOrOsculatingSpacecraftStatesAttitude.from_dict(obj["attitude"]) if obj.get("attitude") is not None else None
        })
        return _obj


