# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class KeplerianEphemerides(BaseModel):
    """
    TODO
    """ # noqa: E501
    true_anomaly: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="The true anomaly at each time step", alias="trueAnomaly")
    mean_anomaly: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO", alias="meanAnomaly")
    inclination: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO")
    eccentric_anomaly: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO", alias="eccentricAnomaly")
    perigee_altitude: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO", alias="perigeeAltitude")
    ltan: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO")
    altitude: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO")
    semi_major_axis: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO", alias="semiMajorAxis")
    eccentricity: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO")
    raan: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="TODO")
    __properties: ClassVar[List[str]] = ["trueAnomaly", "meanAnomaly", "inclination", "eccentricAnomaly", "perigeeAltitude", "ltan", "altitude", "semiMajorAxis", "eccentricity", "raan"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeplerianEphemerides from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeplerianEphemerides from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trueAnomaly": obj.get("trueAnomaly"),
            "meanAnomaly": obj.get("meanAnomaly"),
            "inclination": obj.get("inclination"),
            "eccentricAnomaly": obj.get("eccentricAnomaly"),
            "perigeeAltitude": obj.get("perigeeAltitude"),
            "ltan": obj.get("ltan"),
            "altitude": obj.get("altitude"),
            "semiMajorAxis": obj.get("semiMajorAxis"),
            "eccentricity": obj.get("eccentricity"),
            "raan": obj.get("raan")
        })
        return _obj


