# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from leo_station_keeping.models.axis import Axis
from leo_station_keeping.models.solar_array import SolarArray
from leo_station_keeping.models.spacecraft_geometry import SpacecraftGeometry
from leo_station_keeping.models.spacecraft_geometry_dimension import SpacecraftGeometryDimension
from typing import Optional, Set
from typing_extensions import Self

class BoxSpacecraftGeometry(SpacecraftGeometry):
    """
    Represent your spacecraft by a parallelepiped, specifying its width, height and depth. This oriented shape is used to define the location and orientation of all subsystems.  
    """ # noqa: E501
    dimensions: Optional[SpacecraftGeometryDimension] = None
    thruster_axis: Optional[Axis] = Field(default=None, alias="thrusterAxis")
    solar_array: Optional[SolarArray] = Field(default=None, alias="solarArray")
    __properties: ClassVar[List[str]] = ["type", "dimensions", "thrusterAxis", "solarArray"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BoxSpacecraftGeometry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dimensions
        if self.dimensions:
            _dict['dimensions'] = self.dimensions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of thruster_axis
        if self.thruster_axis:
            _dict['thrusterAxis'] = self.thruster_axis.to_dict()
        # override the default output from pydantic by calling `to_dict()` of solar_array
        if self.solar_array:
            _dict['solarArray'] = self.solar_array.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BoxSpacecraftGeometry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "dimensions": SpacecraftGeometryDimension.from_dict(obj["dimensions"]) if obj.get("dimensions") is not None else None,
            "thrusterAxis": Axis.from_dict(obj["thrusterAxis"]) if obj.get("thrusterAxis") is not None else None,
            "solarArray": SolarArray.from_dict(obj["solarArray"]) if obj.get("solarArray") is not None else None
        })
        return _obj


