# coding: utf-8

"""
    LEO Station Keeping API

    This mission allows to estimate the cost of station keeping maneuvers needed  to counter the effects of the atmospheric drag on the semi-major axis of a  spacecraft in low Earth orbit (up to an altitude of 1000 km).   <b>CHANGELOG</b> <ul>   <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li> </ul> 

    The version of the OpenAPI document: 1.0.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from leo_station_keeping.models.orbit import Orbit
from typing import Optional, Set
from typing_extensions import Self

class AnalyticalLeoStationKeepingResponse(BaseModel):
    """
    AnalyticalLeoStationKeepingResponse
    """ # noqa: E501
    delta_v: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total delta-V (in m/s) required to reach the target orbit. ", alias="deltaV")
    maneuvering_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The maneuvering duration (in seconds). ", alias="maneuveringDuration")
    mission_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The simulation duration (in seconds). ", alias="missionDuration")
    thrust_duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The average thrust duration (in seconds). ", alias="thrustDuration")
    thruster_mean_duty_cycle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The mean duty cycle. ", alias="thrusterMeanDutyCycle")
    total_impulse: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total impulse (in N.s). ", alias="totalImpulse")
    used_propellant: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The used propellant (in kg). ", alias="usedPropellant")
    number_of_burns: Optional[StrictInt] = Field(default=None, description="The total number of burns required to reach the target orbit. ", alias="numberOfBurns")
    mean_burn_duration_estimation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The mean burn duration estimation (in seconds). ", alias="meanBurnDurationEstimation")
    drag_perturbation_enabled: Optional[StrictBool] = Field(default=None, description="Indicates whether the drag perturbation is enabled or not. ", alias="dragPerturbationEnabled")
    mean_atmospheric_density: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The mean atmospheric density (in kg/m^3). ", alias="meanAtmosphericDensity")
    mean_drag: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The mean drag (in N). ", alias="meanDrag")
    mean_drag_acceleration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The mean drag acceleration (in m/s^2). ", alias="meanDragAcceleration")
    drag_to_thrust_ratio: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The drag to thrust ratio. ", alias="dragToThrustRatio")
    drag_delta_v: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The drag delta-V (in m/s). ", alias="dragDeltaV")
    maneuver_model: Optional[StrictStr] = Field(default=None, description="The maneuver model", alias="maneuverModel")
    final_orbit: Optional[Orbit] = Field(default=None, alias="finalOrbit")
    errors: Optional[List[StrictStr]] = None
    warnings: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["deltaV", "maneuveringDuration", "missionDuration", "thrustDuration", "thrusterMeanDutyCycle", "totalImpulse", "usedPropellant", "numberOfBurns", "meanBurnDurationEstimation", "dragPerturbationEnabled", "meanAtmosphericDensity", "meanDrag", "meanDragAcceleration", "dragToThrustRatio", "dragDeltaV", "maneuverModel", "finalOrbit", "errors", "warnings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalyticalLeoStationKeepingResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of final_orbit
        if self.final_orbit:
            _dict['finalOrbit'] = self.final_orbit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalyticalLeoStationKeepingResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deltaV": obj.get("deltaV"),
            "maneuveringDuration": obj.get("maneuveringDuration"),
            "missionDuration": obj.get("missionDuration"),
            "thrustDuration": obj.get("thrustDuration"),
            "thrusterMeanDutyCycle": obj.get("thrusterMeanDutyCycle"),
            "totalImpulse": obj.get("totalImpulse"),
            "usedPropellant": obj.get("usedPropellant"),
            "numberOfBurns": obj.get("numberOfBurns"),
            "meanBurnDurationEstimation": obj.get("meanBurnDurationEstimation"),
            "dragPerturbationEnabled": obj.get("dragPerturbationEnabled"),
            "meanAtmosphericDensity": obj.get("meanAtmosphericDensity"),
            "meanDrag": obj.get("meanDrag"),
            "meanDragAcceleration": obj.get("meanDragAcceleration"),
            "dragToThrustRatio": obj.get("dragToThrustRatio"),
            "dragDeltaV": obj.get("dragDeltaV"),
            "maneuverModel": obj.get("maneuverModel"),
            "finalOrbit": Orbit.from_dict(obj["finalOrbit"]) if obj.get("finalOrbit") is not None else None,
            "errors": obj.get("errors"),
            "warnings": obj.get("warnings")
        })
        return _obj


