# leo-station-keeping
This mission allows to estimate the cost of station keeping maneuvers needed 
to counter the effects of the atmospheric drag on the semi-major axis of a 
spacecraft in low Earth orbit (up to an altitude of 1000 km). 

<b>CHANGELOG</b>
<ul>
  <li><b>1.0.0</b> - 2024-06-07 - First version of the API</li>
</ul>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.5
- Package version: 1.0.5
- Generator version: 7.7.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import leo_station_keeping
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import leo_station_keeping
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import leo_station_keeping
from leo_station_keeping.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://leo-station-keeping.exoops.57.128.40.142.sslip.io
# See configuration.py for a list of all supported configuration parameters.
configuration = leo_station_keeping.Configuration(
    host = "http://leo-station-keeping.exoops.57.128.40.142.sslip.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = leo_station_keeping.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with leo_station_keeping.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = leo_station_keeping.DefaultApi(api_client)
    analytical_leo_station_keeping_request = leo_station_keeping.AnalyticalLeoStationKeepingRequest() # AnalyticalLeoStationKeepingRequest | 

    try:
        # Analytical LEO Station Keeping
        api_response = api_instance.compute_analytical_leo_station_keeping(analytical_leo_station_keeping_request)
        print("The response of DefaultApi->compute_analytical_leo_station_keeping:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->compute_analytical_leo_station_keeping: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://leo-station-keeping.exoops.57.128.40.142.sslip.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**compute_analytical_leo_station_keeping**](docs/DefaultApi.md#compute_analytical_leo_station_keeping) | **POST** /analytical | Analytical LEO Station Keeping
*DefaultApi* | [**compute_numerical_leo_station_keeping**](docs/DefaultApi.md#compute_numerical_leo_station_keeping) | **POST** /numerical | Numerical LEO Station Keeping


## Documentation For Models

 - [AdvancedOrbitParameters](docs/AdvancedOrbitParameters.md)
 - [AlongTrackTolerance](docs/AlongTrackTolerance.md)
 - [AnalyticalLeoStationKeepingRequest](docs/AnalyticalLeoStationKeepingRequest.md)
 - [AnalyticalLeoStationKeepingRequestDragPerturbation](docs/AnalyticalLeoStationKeepingRequestDragPerturbation.md)
 - [AnalyticalLeoStationKeepingResponse](docs/AnalyticalLeoStationKeepingResponse.md)
 - [Axis](docs/Axis.md)
 - [BodySolarArray](docs/BodySolarArray.md)
 - [BoxSpacecraftGeometry](docs/BoxSpacecraftGeometry.md)
 - [CartesianEphemerides](docs/CartesianEphemerides.md)
 - [CircularAltitudeOrbitParameters](docs/CircularAltitudeOrbitParameters.md)
 - [CircularGroundTrackRepeatedOrbitParameters](docs/CircularGroundTrackRepeatedOrbitParameters.md)
 - [CustomManeuveringStrategy](docs/CustomManeuveringStrategy.md)
 - [DeployableFixedSolarArray](docs/DeployableFixedSolarArray.md)
 - [DeployableRotatingSolarArray](docs/DeployableRotatingSolarArray.md)
 - [DragPerturbation](docs/DragPerturbation.md)
 - [DutyCycleThrustArcDefinition](docs/DutyCycleThrustArcDefinition.md)
 - [EarthPotentialPerturbation](docs/EarthPotentialPerturbation.md)
 - [EllipticalGroundTrackRepeatedEccentricityOrbitParameters](docs/EllipticalGroundTrackRepeatedEccentricityOrbitParameters.md)
 - [EllipticalPerigeeAltApogeeAltOrbitParameters](docs/EllipticalPerigeeAltApogeeAltOrbitParameters.md)
 - [EllipticalPerigeeAltEccentricityOrbitParameters](docs/EllipticalPerigeeAltEccentricityOrbitParameters.md)
 - [EllipticalSmaEccentricityOrbitParameters](docs/EllipticalSmaEccentricityOrbitParameters.md)
 - [KeplerianEphemerides](docs/KeplerianEphemerides.md)
 - [MeanOrOsculatingSpacecraftStates](docs/MeanOrOsculatingSpacecraftStates.md)
 - [MeanOrOsculatingSpacecraftStatesAttitude](docs/MeanOrOsculatingSpacecraftStatesAttitude.md)
 - [MeanOrOsculatingSpacecraftStatesPvCoordinates](docs/MeanOrOsculatingSpacecraftStatesPvCoordinates.md)
 - [NumericalLeoStationKeepingRequest](docs/NumericalLeoStationKeepingRequest.md)
 - [NumericalLeoStationKeepingRequestInputs](docs/NumericalLeoStationKeepingRequestInputs.md)
 - [NumericalLeoStationKeepingRequestOutputs](docs/NumericalLeoStationKeepingRequestOutputs.md)
 - [NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides](docs/NumericalLeoStationKeepingRequestOutputsOrbitalEphemerides.md)
 - [NumericalLeoStationKeepingRequestOutputsSpacecraftStates](docs/NumericalLeoStationKeepingRequestOutputsSpacecraftStates.md)
 - [NumericalLeoStationKeepingRequestOutputsThrustEphemerides](docs/NumericalLeoStationKeepingRequestOutputsThrustEphemerides.md)
 - [NumericalLeoStationKeepingResponse](docs/NumericalLeoStationKeepingResponse.md)
 - [NumericalLeoStationKeepingResponseFieldIndexesInner](docs/NumericalLeoStationKeepingResponseFieldIndexesInner.md)
 - [NumericalLeoStationKeepingResponseOrbitalEphemerides](docs/NumericalLeoStationKeepingResponseOrbitalEphemerides.md)
 - [NumericalLeoStationKeepingResponseOrbitalEphemeridesMean](docs/NumericalLeoStationKeepingResponseOrbitalEphemeridesMean.md)
 - [NumericalLeoStationKeepingResponseOrbitalEphemeridesOsculating](docs/NumericalLeoStationKeepingResponseOrbitalEphemeridesOsculating.md)
 - [NumericalLeoStationKeepingResponseResults](docs/NumericalLeoStationKeepingResponseResults.md)
 - [NumericalLeoStationKeepingResponseSpacecraftStates](docs/NumericalLeoStationKeepingResponseSpacecraftStates.md)
 - [NumericalLeoStationKeepingResponseSpacecraftStatesThrustingInner](docs/NumericalLeoStationKeepingResponseSpacecraftStatesThrustingInner.md)
 - [NumericalLeoStationKeepingResponseThrustEphemerides](docs/NumericalLeoStationKeepingResponseThrustEphemerides.md)
 - [Orbit](docs/Orbit.md)
 - [OrbitParameters](docs/OrbitParameters.md)
 - [Perturbation](docs/Perturbation.md)
 - [Platform](docs/Platform.md)
 - [PropulsionSystem](docs/PropulsionSystem.md)
 - [SmaTolerance](docs/SmaTolerance.md)
 - [SolarArray](docs/SolarArray.md)
 - [SolarArrayFace](docs/SolarArrayFace.md)
 - [SpacecraftGeometry](docs/SpacecraftGeometry.md)
 - [SpacecraftGeometryDimension](docs/SpacecraftGeometryDimension.md)
 - [SphericalSpacecraftGeometry](docs/SphericalSpacecraftGeometry.md)
 - [SrpPerturbation](docs/SrpPerturbation.md)
 - [ThirdBodyPerturbation](docs/ThirdBodyPerturbation.md)
 - [ThrustArcDefinition](docs/ThrustArcDefinition.md)
 - [ThrustArcsPositions](docs/ThrustArcsPositions.md)
 - [ThrustDurationThrustArcDefinition](docs/ThrustDurationThrustArcDefinition.md)
 - [Tolerance](docs/Tolerance.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




