/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.tilings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.Cache;
import org.gavrog.box.collections.CacheMissException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.simple.Tag;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.joss.dsyms.basic.DSMorphism;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Traversal;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.IGraphElement;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;

public class Tiling {
    protected static final Tag TRANSLATION_GROUP = new Tag();
    protected static final Tag TRANSLATION_VECTORS = new Tag();
    protected static final Tag EDGE_TRANSLATIONS = new Tag();
    protected static final Tag CORNER_SHIFTS = new Tag();
    protected static final Tag SKELETON = new Tag();
    protected static final Tag DUAL_SKELETON = new Tag();
    protected static final Tag BARYCENTRIC_POS_BY_VERTEX = new Tag();
    protected static final Tag SPACEGROUP = new Tag();
    protected static final Tag TILES = new Tag();
    protected static final Tag SYMMETRIES = new Tag();
    protected static final Tag COVER_ORIENTATION = new Tag();
    protected final Cache<Tag, Object> cache = new Cache();
    protected final DelaneySymbol<Integer> ds;
    protected final DSCover<Integer> cov;
    private final Map<Object, Integer> chamber2tile = new HashMap<Object, Integer>();
    private final Map<Object, Integer> chamber2kind = new HashMap<Object, Integer>();
    private final Map<Object, Integer> chamber2facet = new HashMap<Object, Integer>();

    public Tiling(DelaneySymbol<Integer> delaneySymbol) {
        this(delaneySymbol, null);
    }

    public Tiling(DelaneySymbol<Integer> delaneySymbol, DSCover<Integer> dSCover) {
        DSCover<Integer> dSCover2;
        if (!delaneySymbol.isComplete()) {
            throw new IllegalArgumentException("symbol must be complete");
        }
        if (!delaneySymbol.isConnected()) {
            throw new IllegalArgumentException("symbol must be connected");
        }
        this.ds = delaneySymbol;
        int n = delaneySymbol.dim();
        if (n == 2) {
            dSCover2 = Covers.toroidalCover2D(delaneySymbol);
        } else if (n == 3) {
            dSCover2 = Covers.pseudoToroidalCover3D(delaneySymbol);
        } else {
            throw new UnsupportedOperationException("symbol must be 2- or 3-dimensional");
        }
        if (dSCover2 == null) {
            throw new IllegalArgumentException("symbol is not euclidean");
        }
        if (dSCover != null) {
            int n2 = delaneySymbol.elements().next();
            int n3 = dSCover2.getCoverMorphism().getASource(n2);
            int n4 = dSCover.getCoverMorphism().getASource(n2);
            assert (new DSMorphism<Integer, Integer>(dSCover2, dSCover, n3, n4).isIsomorphism());
            new DSMorphism<Integer, Integer>(dSCover, delaneySymbol, n4, n2);
            this.cov = dSCover;
        } else {
            this.cov = dSCover2;
        }
    }

    public DelaneySymbol<Integer> getSymbol() {
        return this.ds;
    }

    public DSCover<Integer> getCover() {
        return this.cov;
    }

    public Map<Integer, Integer> getCoverOrientation() {
        try {
            Map map = (Map)this.cache.get(COVER_ORIENTATION);
            return map;
        }
        catch (CacheMissException cacheMissException) {
            Map<Integer, Integer> map = this.getCover().partialOrientation();
            this.cache.put(COVER_ORIENTATION, map);
            return map;
        }
    }

    public int coverOrientation(Object object) {
        return this.getCoverOrientation().get(object);
    }

    public FundamentalGroup<Integer> getTranslationGroup() {
        try {
            FundamentalGroup fundamentalGroup = (FundamentalGroup)this.cache.get(TRANSLATION_GROUP);
            return fundamentalGroup;
        }
        catch (CacheMissException cacheMissException) {
            FundamentalGroup<Integer> fundamentalGroup = new FundamentalGroup<Integer>(this.getCover());
            this.cache.put(TRANSLATION_GROUP, fundamentalGroup);
            return fundamentalGroup;
        }
    }

    private Vector[] getTranslationVectors() {
        try {
            return (Vector[])this.cache.get(TRANSLATION_VECTORS);
        }
        catch (CacheMissException cacheMissException) {
            Matrix matrix = LinearAlgebra.columnNullSpace(this.getTranslationGroup().getPresentation().relatorMatrix(), true);
            if (matrix.numberOfColumns() != this.getCover().dim()) {
                throw new RuntimeException("could not compute translations");
            }
            Vector[] vectorArray = Vector.fromMatrix(matrix);
            this.cache.put(TRANSLATION_VECTORS, vectorArray);
            return vectorArray;
        }
    }

    public Map<DSPair<Integer>, Vector> getEdgeTranslations() {
        try {
            Map map = (Map)this.cache.get(EDGE_TRANSLATIONS);
            return map;
        }
        catch (CacheMissException cacheMissException) {
            int n = this.getCover().dim();
            Vector[] vectorArray = this.getTranslationVectors();
            Map<DSPair<Integer>, FreeWord<String>> map = this.getTranslationGroup().getEdgeToWord();
            HashMap<DSPair<Integer>, Vector> hashMap = new HashMap<DSPair<Integer>, Vector>();
            for (DSPair<Integer> dSPair : map.keySet()) {
                FreeWord<String> freeWord = map.get(dSPair);
                Vector vector = Vector.zero(n);
                for (int i = 0; i < freeWord.length(); ++i) {
                    int n2 = freeWord.getLetter(i) - 1;
                    int n3 = freeWord.getSign(i);
                    vector = n3 > 0 ? (Vector)vector.plus(vectorArray[n2]) : (Vector)vector.minus(vectorArray[n2]);
                }
                hashMap.put(dSPair, vector);
            }
            Map map2 = Collections.unmodifiableMap(hashMap);
            this.cache.put(EDGE_TRANSLATIONS, map2);
            return map2;
        }
    }

    public Vector edgeTranslation(int n, int n2) {
        return this.getEdgeTranslations().get(new DSPair<Integer>(n, n2));
    }

    public Map<DSPair<Integer>, Vector> getCornerShifts() {
        try {
            Map map = (Map)this.cache.get(CORNER_SHIFTS);
            return map;
        }
        catch (CacheMissException cacheMissException) {
            int n = this.getCover().dim();
            HashMap<DSPair<Integer>, Vector> hashMap = new HashMap<DSPair<Integer>, Vector>();
            for (int i = 0; i <= n; ++i) {
                IndexList indexList = IndexList.except(this.getCover(), i);
                for (DSPair dSPair : new Traversal<IteratorAdapter<Integer>>((DelaneySymbol<IteratorAdapter<Integer>>)this.getCover(), (List<Integer>)indexList, this.getCover().elements())) {
                    int n2 = dSPair.getIndex();
                    int n3 = (Integer)dSPair.getElement();
                    if (n2 < 0) {
                        hashMap.put(new DSPair<Integer>(i, n3), Vector.zero(n));
                        continue;
                    }
                    int n4 = this.getCover().op(n2, (Integer)n3);
                    Vector vector = (Vector)hashMap.get(new DSPair<Integer>(i, n4));
                    hashMap.put(new DSPair<Integer>(i, n3), (Vector)vector.minus(this.edgeTranslation(n2, n4)));
                }
            }
            Map<DSPair<Integer>, Vector> map = Collections.unmodifiableMap(hashMap);
            this.cache.put(CORNER_SHIFTS, map);
            return map;
        }
    }

    public Vector cornerShift(int n, int n2) {
        return this.getCornerShifts().get(new DSPair<Integer>(n, n2));
    }

    public Skeleton getSkeleton() {
        try {
            return (Skeleton)this.cache.get(SKELETON);
        }
        catch (CacheMissException cacheMissException) {
            return (Skeleton)this.cache.put(SKELETON, this.makeSkeleton(false));
        }
    }

    public Skeleton getDualSkeleton() {
        try {
            return (Skeleton)this.cache.get(DUAL_SKELETON);
        }
        catch (CacheMissException cacheMissException) {
            return (Skeleton)this.cache.put(DUAL_SKELETON, this.makeSkeleton(true));
        }
    }

    private Skeleton makeSkeleton(boolean bl) {
        int n;
        DSCover<Integer> dSCover = this.getCover();
        Skeleton skeleton = new Skeleton(bl);
        int n2 = dSCover.dim();
        int n3 = bl ? n2 : 0;
        int n4 = bl ? n2 - 1 : 1;
        IndexList indexList = IndexList.except(dSCover, n3);
        Iterator iterator = dSCover.orbitReps(indexList).iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            skeleton.newNode(n);
        }
        indexList = IndexList.except(dSCover, n4);
        iterator = dSCover.orbitReps(indexList).iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            int n5 = dSCover.op(n3, (Integer)n);
            INode iNode = skeleton.nodeForChamber(n);
            INode iNode2 = skeleton.nodeForChamber(n5);
            Vector vector = this.edgeTranslation(n3, n);
            Vector vector2 = this.cornerShift(n3, n);
            Vector vector3 = this.cornerShift(n3, n5);
            Vector vector4 = (Vector)vector.plus(vector3).minus(vector2);
            skeleton.newEdge(iNode, iNode2, vector4, n);
        }
        return skeleton;
    }

    public Map<DSPair<Integer>, Point> getVertexBarycentricPositions() {
        try {
            Map map = (Map)this.cache.get(BARYCENTRIC_POS_BY_VERTEX);
            return map;
        }
        catch (CacheMissException cacheMissException) {
            Map<DSPair<Integer>, Point> map = this.cornerPositions(this.getSkeleton().barycentricPlacement());
            this.cache.put(BARYCENTRIC_POS_BY_VERTEX, map);
            return map;
        }
    }

    public Map<DSPair<Integer>, Point> cornerPositions(Map<INode, Point> map) {
        Object object;
        DSCover<Integer> dSCover = this.getCover();
        Skeleton skeleton = this.getSkeleton();
        HashMap<DSPair<Integer>, Point> hashMap = new HashMap<DSPair<Integer>, Point>();
        Iterator iterator = ((DelaneySymbol)dSCover).elements().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Point point = map.get(skeleton.nodeForChamber(n));
            object = this.cornerShift(0, n);
            hashMap.put(new DSPair<Integer>(0, n), (Point)point.plus(object));
        }
        int n = ((DelaneySymbol)dSCover).dim();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 1; i <= n; ++i) {
            linkedList.add(i - 1);
            object = dSCover.orbitReps(linkedList).iterator();
            while (object.hasNext()) {
                Vector vector;
                int n2 = (Integer)object.next();
                Matrix matrix = Point.origin(n).getCoordinates();
                int n3 = 0;
                Object object2 = dSCover.orbit(linkedList, n2).iterator();
                while (object2.hasNext()) {
                    int n4 = object2.next();
                    Point point = (Point)hashMap.get(new DSPair<Integer>(0, n4));
                    vector = this.cornerShift(i, n4);
                    Point point2 = (Point)point.minus(vector);
                    matrix = (Matrix)matrix.plus(point2.getCoordinates());
                    ++n3;
                }
                object2 = new Point((Matrix)matrix.dividedBy(n3));
                for (int n5 : dSCover.orbit(linkedList, n2)) {
                    vector = this.cornerShift(i, n5);
                    hashMap.put(new DSPair<Integer>(i, n5), (Point)((Point)object2).plus(vector));
                }
            }
        }
        return hashMap;
    }

    public Point vertexBarycentricPosition(int n, int n2) {
        return this.getVertexBarycentricPositions().get(new DSPair<Integer>(n, n2));
    }

    public SpaceGroup getSpaceGroup() {
        return this.getSkeleton().getSpaceGroup();
    }

    private Matrix spanningMatrix(int n) {
        int n2 = this.getCover().dim();
        Point point = this.vertexBarycentricPosition(0, n);
        Vector[] vectorArray = new Vector[n2];
        for (int i = 0; i < n2; ++i) {
            vectorArray[i] = (Vector)this.vertexBarycentricPosition(i + 1, n).minus(point);
        }
        return Vector.toMatrix(vectorArray);
    }

    public List<Tile> getTiles() {
        try {
            return (List)this.cache.get(TILES);
        }
        catch (CacheMissException cacheMissException) {
            DSCover<Integer> dSCover = this.getCover();
            DelaneySymbol<Integer> delaneySymbol = this.getSymbol();
            IndexList indexList = IndexList.except(dSCover, delaneySymbol.dim());
            int n = 0;
            for (int n2 : delaneySymbol.elements()) {
                if (this.chamber2kind.containsKey(n2)) continue;
                for (int n3 : delaneySymbol.orbit(indexList, n2)) {
                    this.chamber2kind.put(n3, n);
                }
                ++n;
            }
            int n4 = 0;
            Object object = ((DelaneySymbol)dSCover).elements().iterator();
            while (object.hasNext()) {
                int n5 = (Integer)object.next();
                if (this.chamber2tile.containsKey(n5)) continue;
                for (int n6 : dSCover.orbit(indexList, n5)) {
                    this.chamber2tile.put(n6, n4);
                }
                ++n4;
            }
            object = new ArrayList();
            for (INode iNode : this.getDualSkeleton().nodes()) {
                object.add(new Tile(iNode));
            }
            return (List)this.cache.put(TILES, object);
        }
    }

    public class Tile {
        private final int tilingId;
        private final int index;
        private final int kind;
        private final List<Facet> facets;
        private final int[] neighbors;
        private final Vector[] neighborShifts;

        private Tile(INode iNode) {
            this.tilingId = Tiling.this.hashCode();
            int n = Tiling.this.getSymbol().dim();
            DSCover<Integer> dSCover = Tiling.this.getCover();
            Skeleton skeleton = Tiling.this.getDualSkeleton();
            int n2 = skeleton.chamberAtNode(iNode);
            this.index = (Integer)Tiling.this.chamber2tile.get(n2);
            this.kind = (Integer)Tiling.this.chamber2kind.get(dSCover.image(n2));
            int n3 = iNode.degree();
            this.facets = new ArrayList<Facet>();
            this.neighbors = new int[n3];
            this.neighborShifts = new Vector[n3];
            int n4 = 0;
            for (IEdge iEdge : iNode.incidences()) {
                int n5 = skeleton.chamberAtEdge(iEdge);
                if ((Integer)Tiling.this.chamber2tile.get(n5) != this.index) {
                    n5 = dSCover.op(n, (Integer)n5);
                }
                Vector vector = Tiling.this.edgeTranslation(n, n5);
                this.facets.add(new Facet(n5, this.index, n4));
                int n6 = skeleton.chamberAtNode(iEdge.target());
                this.neighbors[n4] = (Integer)Tiling.this.chamber2tile.get(n6);
                this.neighborShifts[n4] = vector;
                ++n4;
                if (!iEdge.source().equals(iEdge.target())) continue;
                n5 = dSCover.op(n, (Integer)n5);
                this.facets.add(new Facet(n5, this.index, n4));
                this.neighbors[n4] = this.index;
                this.neighborShifts[n4] = (Vector)vector.negative();
                ++n4;
            }
        }

        public int getChamber() {
            return this.facet(0).chamber(0);
        }

        public int getIndex() {
            return this.index;
        }

        public int getKind() {
            return this.kind;
        }

        public int size() {
            return this.facets.size();
        }

        public Facet facet(int n) {
            return this.facets.get(n);
        }

        public Tile neighbor(int n) {
            return Tiling.this.getTiles().get(this.neighbors[n]);
        }

        public Vector neighborShift(int n) {
            return this.neighborShifts[n];
        }

        public int hashCode() {
            return this.tilingId * 37 + this.index;
        }

        public boolean equals(Object object) {
            Tile tile = (Tile)object;
            return tile.tilingId == this.tilingId && tile.index == this.index;
        }
    }

    public class Facet {
        private final int tilingId;
        private final List<Integer> chambers;
        private final int tile;
        private final int index;

        private Facet(int n, int n2, int n3) {
            this.tilingId = Tiling.this.hashCode();
            DSCover<Integer> dSCover = Tiling.this.getCover();
            int n4 = dSCover.dim();
            int n5 = Tiling.this.coverOrientation(n) < 0 ? dSCover.op(0, (Integer)n) : n;
            this.chambers = new LinkedList<Integer>();
            if (n4 == 3) {
                int n6 = n5;
                do {
                    this.chambers.add(n6);
                } while ((n6 = dSCover.op(1, dSCover.op(0, (Integer)n6)).intValue()) != n5);
            } else if (n4 == 2) {
                this.chambers.add(n5);
                this.chambers.add(dSCover.op(0, (Integer)n5));
            } else {
                throw new UnsupportedOperationException("dimension must be 2 or 3");
            }
            for (int n7 : this.chambers) {
                Tiling.this.chamber2facet.put(n7, n3);
                Tiling.this.chamber2facet.put(dSCover.op(0, (Integer)n7), n3);
            }
            this.tile = n2;
            this.index = n3;
        }

        public int size() {
            return this.chambers.size();
        }

        public int chamber(int n) {
            return this.chambers.get(n);
        }

        public IEdge edge(int n) {
            return Tiling.this.getSkeleton().edgeForChamber(this.chamber(n));
        }

        public Vector edgeShift(int n) {
            return Tiling.this.cornerShift(0, this.chamber(n));
        }

        public int getChamber() {
            return this.chamber(0);
        }

        public int getIndex() {
            return this.index;
        }

        public int getTileIndex() {
            return this.tile;
        }

        public Tile getTile() {
            return Tiling.this.getTiles().get(this.tile);
        }

        public Facet opposite() {
            DSCover<Integer> dSCover = Tiling.this.getCover();
            int n = ((DelaneySymbol)dSCover).op(((DelaneySymbol)dSCover).dim(), this.getChamber());
            Tile tile = Tiling.this.getTiles().get((Integer)Tiling.this.chamber2tile.get(n));
            return tile.facet((Integer)Tiling.this.chamber2facet.get(n));
        }

        public int hashCode() {
            return (this.tilingId * 37 + this.tile) * 37 + this.index;
        }

        public boolean equals(Object object) {
            Facet facet = (Facet)object;
            return facet.tilingId == this.tilingId && facet.tile == this.tile && facet.index == this.index;
        }
    }

    public class Skeleton
    extends PeriodicGraph {
        private final Map<INode, Integer> node2chamber;
        private final Map<Integer, INode> chamber2node;
        private final Map<IEdge, Integer> edge2chamber;
        private final Map<Integer, IEdge> chamber2edge;
        private final IndexList nodeIdcs;
        private final IndexList halfEdgeIdcs;
        private final boolean dual;

        private Skeleton(boolean bl) {
            super(Tiling.this.getCover().dim());
            this.node2chamber = new HashMap<INode, Integer>();
            this.chamber2node = new HashMap<Integer, INode>();
            this.edge2chamber = new HashMap<IEdge, Integer>();
            this.chamber2edge = new HashMap<Integer, IEdge>();
            DSCover<Integer> dSCover = Tiling.this.getCover();
            int n = ((DelaneySymbol)dSCover).dim();
            if (bl) {
                this.nodeIdcs = IndexList.except(dSCover, n);
                this.halfEdgeIdcs = IndexList.except(dSCover, n, n - 1);
            } else {
                this.nodeIdcs = IndexList.except(dSCover, 0);
                this.halfEdgeIdcs = IndexList.except(dSCover, 0, 1);
            }
            this.dual = bl;
        }

        private INode newNode(int n) {
            DSCover<Integer> dSCover = Tiling.this.getCover();
            INode iNode = super.newNode();
            this.node2chamber.put(iNode, n);
            for (int n2 : dSCover.orbit(this.nodeIdcs, n)) {
                this.chamber2node.put(n2, iNode);
            }
            return iNode;
        }

        private IEdge newEdge(INode iNode, INode iNode2, Vector vector, int n) {
            int n2;
            DSCover<Integer> dSCover = Tiling.this.getCover();
            IEdge iEdge = super.newEdge(iNode, iNode2, vector, !this.dual);
            this.edge2chamber.put(iEdge, n);
            Object object = dSCover.orbit(this.halfEdgeIdcs, n).iterator();
            while (object.hasNext()) {
                n2 = object.next();
                this.chamber2edge.put(n2, iEdge);
            }
            object = iEdge.reverse();
            n2 = this.dual ? dSCover.op(dSCover.dim(), (Integer)n) : dSCover.op(0, (Integer)n);
            this.edge2chamber.put((IEdge)object, n2);
            for (int n3 : dSCover.orbit(this.halfEdgeIdcs, n2)) {
                this.chamber2edge.put(n3, (IEdge)object);
            }
            return iEdge;
        }

        @Override
        public Set<Morphism> symmetries() {
            try {
                Set set = (Set)this.cache.get(SYMMETRIES);
                return set;
            }
            catch (CacheMissException cacheMissException) {
                int n;
                DSCover<Integer> dSCover = Tiling.this.getCover();
                int n2 = 0;
                Object object = dSCover.elements().iterator();
                while (object.hasNext()) {
                    n = object.next();
                    if (Tiling.this.spanningMatrix(n).determinant().isZero()) continue;
                    n2 = n;
                    break;
                }
                if (n2 == 0) {
                    throw new RuntimeException("all chambers have zero volume");
                }
                object = new HashSet();
                n = dSCover.image(n2);
                Object object2 = dSCover.elements().iterator();
                while (object2.hasNext()) {
                    int n3 = object2.next();
                    if (dSCover.image(n3) != n) continue;
                    object.add(this.derivedMorphism(n2, n3));
                }
                object2 = Collections.unmodifiableSet(object);
                this.cache.put(SYMMETRIES, object2);
                return object2;
            }
        }

        private Morphism derivedMorphism(int n, int n2) {
            DSCover<Integer> dSCover = Tiling.this.getCover();
            DSMorphism<Integer, Integer> dSMorphism = new DSMorphism<Integer, Integer>(dSCover, dSCover, n, n2);
            Operator operator = Operator.fromLinear((Matrix)Tiling.this.spanningMatrix(n).inverse().times(Tiling.this.spanningMatrix(n2)));
            HashMap<IGraphElement, IGraphElement> hashMap = new HashMap<IGraphElement, IGraphElement>();
            HashMap<IGraphElement, IGraphElement> hashMap2 = new HashMap<IGraphElement, IGraphElement>();
            for (int n3 : dSCover.elements()) {
                int n4 = dSMorphism.get(n3);
                INode iNode = this.nodeForChamber(n3);
                INode iNode2 = this.nodeForChamber(n4);
                hashMap.put(iNode, iNode2);
                hashMap2.put(iNode2, iNode);
                IEdge iEdge = this.edgeForChamber(n3).oriented();
                IEdge iEdge2 = this.edgeForChamber(n4).oriented();
                hashMap.put(iEdge, iEdge2);
                hashMap2.put(iEdge2, iEdge);
            }
            return new Morphism(hashMap, hashMap2, operator, true);
        }

        public int chamberAtNode(INode iNode) {
            return this.node2chamber.get(iNode);
        }

        public INode nodeForChamber(Object object) {
            return this.chamber2node.get(object);
        }

        public int chamberAtEdge(IEdge iEdge) {
            return this.edge2chamber.get(iEdge);
        }

        public boolean isDual() {
            return this.dual;
        }

        public IEdge edgeForChamber(Object object) {
            return this.chamber2edge.get(object);
        }

        public void delete(IGraphElement iGraphElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IEdge newEdge(INode iNode, INode iNode2, int[] nArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IEdge newEdge(INode iNode, INode iNode2, Vector vector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IEdge newEdge(INode iNode, INode iNode2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public INode newNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shiftNode(INode iNode, Vector vector) {
            throw new UnsupportedOperationException();
        }
    }
}

