/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.tilings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.Real;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.io.GenericParser;
import org.gavrog.joss.pgraphs.io.NetParser;
import org.gavrog.joss.tilings.Tiling;

public class FaceList {
    private static final boolean DEBUG = false;
    private final List<NetParser.Face> faces;
    private final List<List<Pair<NetParser.Face, Vector>>> tiles;
    private final Map<NetParser.Face, List<Pair<Integer, Vector>>> tilesAtFace;
    private final Map<Integer, Point> indexToPos;
    private final int dim;
    private final DSymbol ds;
    private final DSCover<Integer> cover;
    private final Map<Integer, Point> positions;
    private final Matrix cellGramMatrix;

    public FaceList(NetParser.FaceListDescriptor faceListDescriptor) {
        Object object;
        List<Object> list = faceListDescriptor.faceLists;
        Map<Integer, Point> map = faceListDescriptor.indexToPosition;
        if (list == null || list.size() < 1) {
            throw new IllegalArgumentException("no data given");
        }
        if (list.get(0) instanceof List) {
            this.tiles = new ArrayList<List<Pair<NetParser.Face, Vector>>>();
            this.tilesAtFace = new HashMap<NetParser.Face, List<Pair<Integer, Vector>>>();
            for (int i = 0; i < list.size(); ++i) {
                List object32 = (List)list.get(i);
                ArrayList<Pair<NetParser.Face, Vector>> arrayList = new ArrayList<Pair<NetParser.Face, Vector>>();
                for (Pair pair : object32) {
                    NetParser.Face face = (NetParser.Face)pair.getFirst();
                    Pair<NetParser.Face, Vector> pair2 = NetParser.normalizedFace(face);
                    object = (Vector)((Vector)pair.getSecond()).plus(pair2.getSecond());
                    if (!this.tilesAtFace.containsKey(face)) {
                        this.tilesAtFace.put(face, new ArrayList());
                    }
                    this.tilesAtFace.get(face).add(new Pair<Integer, Vector>(i, (Vector)object));
                    arrayList.add(new Pair<NetParser.Face, Vector>(face, (Vector)object));
                }
                this.tiles.add(arrayList);
            }
            for (List list2 : this.tilesAtFace.values()) {
                int n = list2.size();
                if (n == 2) continue;
                throw new IllegalArgumentException("Face incident to " + n + " tile" + (n == 1 ? "" : "s") + ".");
            }
            this.faces = new ArrayList<NetParser.Face>();
            this.faces.addAll(this.tilesAtFace.keySet());
        } else {
            this.tiles = null;
            this.tilesAtFace = null;
            this.faces = new ArrayList<NetParser.Face>();
            for (Object object2 : list) {
                this.faces.add((NetParser.Face)object2);
            }
        }
        NetParser.Face face = this.faces.get(0);
        if (face.size() < 3) {
            throw new IllegalArgumentException("minimal face-size is 3");
        }
        this.dim = face.shift(0).getDimension();
        if (this.dim != 3) {
            throw new UnsupportedOperationException("dimension must be 3");
        }
        this.indexToPos = map;
        HashMap<NetParser.Face, List<Integer>> hashMap = new HashMap<NetParser.Face, List<Integer>>();
        DynamicDSymbol dynamicDSymbol = new DynamicDSymbol(this.dim);
        for (NetParser.Face face2 : this.faces) {
            int n;
            int n2 = face2.size();
            int n3 = 2 * n2;
            object = dynamicDSymbol.grow(4 * n2);
            hashMap.put(face2, (List<Integer>)object);
            for (n = 0; n < 4 * n2; n += 2) {
                dynamicDSymbol.redefineOp(0, (Integer)object.get(n), (Integer)object.get(n + 1));
            }
            for (n = 1; n < n3; n += 2) {
                int n4 = (n + 1) % n3;
                dynamicDSymbol.redefineOp(1, (Integer)object.get(n), (Integer)object.get(n4));
                dynamicDSymbol.redefineOp(1, (Integer)object.get(n + n3), (Integer)object.get(n4 + n3));
            }
            for (n = 0; n < n3; ++n) {
                dynamicDSymbol.redefineOp(3, (Integer)object.get(n), (Integer)object.get(n + n3));
            }
        }
        if (this.tiles == null) {
            this.set2opPlainMode(dynamicDSymbol, hashMap);
        } else {
            this.set2opTileMode(dynamicDSymbol, hashMap);
        }
        for (int i = 0; i < this.dim; ++i) {
            for (int n : dynamicDSymbol.elements()) {
                if (dynamicDSymbol.definesV(i, i + 1, n)) continue;
                dynamicDSymbol.redefineV(i, i + 1, n, 1);
            }
        }
        this.assertCompleteness(dynamicDSymbol);
        if (!dynamicDSymbol.isConnected()) {
            throw new RuntimeException("Built non-connected symbol.");
        }
        if (!dynamicDSymbol.isLocallyEuclidean3D()) {
            throw new RuntimeException("Built non-manifold symbol.");
        }
        if (!dynamicDSymbol.isLocallyEuclidean3D()) {
            throw new RuntimeException("Built non-manifold symbol.");
        }
        this.ds = new DSymbol(dynamicDSymbol);
        Tiling tiling = new Tiling(this.ds);
        this.cover = tiling.getCover();
        Tiling.Skeleton skeleton = tiling.getSkeleton();
        this.positions = new HashMap<Integer, Point>();
        Pair<List<Pair<Vector, Vector>>, Map<Integer, Pair<Vector, Vector>>> pair = this.shiftCorrespondences(this.faces, tiling, hashMap);
        List<Pair<Vector, Vector>> list3 = pair.getFirst();
        object = this.tilingBasis(list3);
        Operator operator = Operator.fromLinear((Matrix)object);
        CoordinateChange coordinateChange = new CoordinateChange(operator);
        Matrix matrix = (Matrix)((Matrix)object).inverse();
        this.cellGramMatrix = faceListDescriptor.cellGramMatrix == null ? null : ((Matrix)matrix.times(faceListDescriptor.cellGramMatrix).times(matrix.transposed())).symmetric();
        Map<Integer, Pair<Vector, Vector>> map2 = pair.getSecond();
        for (NetParser.Face face3 : this.faces) {
            int n = face3.size();
            List list4 = (List)hashMap.get(face3);
            for (int i = 0; i < 4 * n; ++i) {
                int n5 = (i % (2 * n) + 1) / 2 % n;
                int n6 = (Integer)list4.get(i);
                assert (this.cover.image(n6) == n6);
                INode iNode = skeleton.nodeForChamber(n6);
                if (n6 != skeleton.chamberAtNode(iNode)) continue;
                Point point = map.get(face3.vertex(n5));
                Vector vector = map2.get(n6).getFirst();
                Vector vector2 = face3.shift(n5);
                Point point2 = (Point)point.plus(vector2).minus(vector).times(coordinateChange);
                Vector vector3 = map2.get(n6).getSecond();
                Vector vector4 = tiling.cornerShift(0, n6);
                this.positions.put(n6, (Point)point2.plus(vector3).minus(vector4));
            }
        }
    }

    private Matrix tilingBasis(List<Pair<Vector, Vector>> list) {
        int n = list.size();
        for (int i = 0; i < n - 2; ++i) {
            Vector vector = list.get(i).getFirst();
            for (int j = i + 1; j < n - 1; ++j) {
                Vector vector2 = list.get(j).getFirst();
                for (int k = j + 1; k < n; ++k) {
                    Vector vector3 = list.get(k).getFirst();
                    if (Vector.volume3D(vector, vector2, vector3).isZero()) continue;
                    ArrayList<Vector> arrayList = new ArrayList<Vector>();
                    arrayList.add(vector);
                    arrayList.add(vector2);
                    arrayList.add(vector3);
                    Matrix matrix = Vector.toMatrix(arrayList);
                    ArrayList<Vector> arrayList2 = new ArrayList<Vector>();
                    arrayList2.add(list.get(i).getSecond());
                    arrayList2.add(list.get(j).getSecond());
                    arrayList2.add(list.get(k).getSecond());
                    Matrix matrix2 = Vector.toMatrix(arrayList2);
                    return (Matrix)matrix.inverse().times(matrix2);
                }
            }
        }
        return null;
    }

    private Pair<List<Pair<Vector, Vector>>, Map<Integer, Pair<Vector, Vector>>> shiftCorrespondences(List<NetParser.Face> list, Tiling tiling, Map<NetParser.Face, List<Integer>> map) {
        Map<Integer, Vector> map2 = this.chamberShifts(list, map);
        DSCover<Integer> dSCover = tiling.getCover();
        Map map3 = dSCover.partialOrientation();
        IndexList indexList = new IndexList(0, 1, 3);
        int n = dSCover.elements().next();
        HashSet<Integer> hashSet = new HashSet<Integer>(Iterators.asList(dSCover.orbit(indexList, n)));
        LinkedList<Thing> linkedList = new LinkedList<Thing>();
        linkedList.addLast(new Thing(n));
        HashMap<Integer, Pair<Vector, Vector>> hashMap = new HashMap<Integer, Pair<Vector, Vector>>();
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            Vector vector = (Vector)tiling.cornerShift(2, n2).minus(tiling.cornerShift(2, n));
            hashMap.put(n2, new Pair<Vector, Vector>(Vector.zero(3), vector));
        }
        object = new ArrayList();
        while (!linkedList.isEmpty()) {
            Thing thing = (Thing)linkedList.removeFirst();
            int n3 = thing.D;
            Vector vector = thing.inputShift;
            Vector vector2 = thing.tilingShift;
            for (int n4 : dSCover.orbit(indexList, n3)) {
                Vector vector3;
                Object object2;
                if (map3.get(n4) < 0) continue;
                int n5 = dSCover.op(2, (Integer)n4);
                Vector vector4 = (Vector)vector.plus(map2.get(n5)).minus(map2.get(n4));
                Vector vector5 = (Vector)vector2.minus(tiling.edgeTranslation(2, n4)).plus(tiling.cornerShift(2, n4)).minus(tiling.cornerShift(2, n3));
                if (!hashMap.containsKey(n5)) {
                    linkedList.addLast(new Thing(n5, vector4, vector5));
                    object2 = dSCover.orbit(indexList, n5).iterator();
                    while (object2.hasNext()) {
                        int n6 = (Integer)object2.next();
                        vector3 = (Vector)vector5.plus(tiling.cornerShift(2, n6)).minus(tiling.cornerShift(2, n5));
                        hashMap.put(n6, new Pair<Vector, Vector>(vector4, vector3));
                    }
                    continue;
                }
                if (vector5.equals(((Pair)hashMap.get(n5)).getFirst())) continue;
                object2 = (Pair)hashMap.get(n5);
                Vector vector6 = (Vector)vector4.minus(((Pair)object2).getFirst());
                vector3 = (Vector)vector5.minus(((Pair)object2).getSecond());
                object.add(new Pair<Vector, Vector>(vector6, vector3));
            }
        }
        return new Pair(object, hashMap);
    }

    private Map<Integer, Vector> chamberShifts(List<NetParser.Face> list, Map<NetParser.Face, List<Integer>> map) {
        HashMap<Integer, Vector> hashMap = new HashMap<Integer, Vector>();
        for (NetParser.Face face : list) {
            int n = face.size();
            List<Integer> list2 = map.get(face);
            for (int i = 0; i < 2 * n; i += 2) {
                int n2 = i / 2;
                Vector vector = face.shift(n2);
                int n3 = list2.get(i);
                int n4 = list2.get((i + 2 * n - 1) % (2 * n));
                int n5 = list2.get(i + 2 * n);
                int n6 = list2.get((i + 2 * n - 1) % (2 * n) + 2 * n);
                hashMap.put(n3, vector);
                hashMap.put(n4, vector);
                hashMap.put(n5, vector);
                hashMap.put(n6, vector);
            }
        }
        return hashMap;
    }

    public FaceList(GenericParser.Block block) {
        this(NetParser.parseFaceList(block));
    }

    private static Vector[] sectorNormals(NetParser.Face face, Map<Integer, Point> map) {
        int n = face.size();
        ArithmeticBase arithmeticBase = null;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            Point point;
            int n2 = face.vertex(i);
            Vector vector = face.shift(i);
            pointArray[i] = point = (Point)vector.plus(map.get(n2));
            arithmeticBase = arithmeticBase == null ? point.getCoordinates() : (Matrix)((Matrix)arithmeticBase).plus(point.getCoordinates());
        }
        Point point = new Point((Matrix)arithmeticBase.dividedBy(n));
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            int n3 = (i + 1) % n;
            Vector vector = (Vector)pointArray[i].minus(point);
            Vector vector2 = (Vector)pointArray[n3].minus(pointArray[i]);
            vectorArray[i] = Vector.unit(Vector.crossProduct3D(vector, vector2));
        }
        return vectorArray;
    }

    private static Map<?, List<Incidence>> collectEdges(List<?> list, boolean bl) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            Vector vector;
            NetParser.Face face;
            if (bl) {
                Pair pair = (Pair)list.get(i);
                face = (NetParser.Face)pair.getFirst();
                vector = (Vector)pair.getSecond();
            } else {
                face = (NetParser.Face)list.get(i);
                vector = null;
            }
            int n = face.size();
            for (int j = 0; j < n; ++j) {
                Object object;
                boolean bl2;
                int n2 = (j + 1) % n;
                int n3 = face.vertex(j);
                int n4 = face.vertex(n2);
                Vector vector2 = (Vector)face.shift(n2).minus(face.shift(j));
                Edge edge = new Edge(n3, n4, vector2);
                boolean bl3 = bl2 = edge.source != n3 || !edge.shift.equals(vector2);
                if (bl) {
                    Vector vector3 = bl2 ? face.shift(n2) : face.shift(j);
                    object = new Pair<Edge, Vector>(edge, (Vector)vector.plus(vector3));
                } else {
                    object = edge;
                }
                if (!hashMap.containsKey(object)) {
                    hashMap.put((Edge)object, new ArrayList());
                }
                ((List)hashMap.get(object)).add(new Incidence(i, j, bl2));
            }
        }
        return hashMap;
    }

    private void set2opPlainMode(DynamicDSymbol dynamicDSymbol, Map<NetParser.Face, List<Integer>> map) {
        HashMap<NetParser.Face, Vector[]> hashMap = new HashMap<NetParser.Face, Vector[]>();
        for (NetParser.Face object : this.faces) {
            hashMap.put(object, FaceList.sectorNormals(object, this.indexToPos));
        }
        Map<?, List<Incidence>> map2 = FaceList.collectEdges(this.faces, false);
        for (Object k : map2.keySet()) {
            Comparable<Object> comparable;
            Edge edge = (Edge)k;
            Point point = this.indexToPos.get(edge.source);
            Point point2 = this.indexToPos.get(edge.target);
            Vector vector = Vector.unit((Vector)point2.plus(edge.shift).minus(point));
            List list = (List)map2.get(edge);
            Vector vector2 = null;
            for (int i = 0; i < list.size(); ++i) {
                double incidence2;
                Incidence incidence = (Incidence)list.get(i);
                comparable = ((Vector[])hashMap.get(this.faces.get(incidence.faceIndex)))[incidence.edgeIndex];
                if (incidence.reverse) {
                    comparable = (Vector)comparable.negative();
                }
                if (i == 0) {
                    vector2 = comparable;
                    incidence2 = 0.0;
                } else {
                    double list3 = ((Real)Vector.dot(vector2, comparable)).doubleValue();
                    list3 = Math.max(Math.min(list3, 1.0), -1.0);
                    incidence2 = Math.acos(list3);
                    if (Vector.volume3D(vector, vector2, comparable).isNegative()) {
                        incidence2 = Math.PI * 2 - incidence2;
                    }
                }
                list.set(i, new Incidence(incidence, incidence2));
            }
            Collections.sort(list);
            Incidence i = (Incidence)list.get(0);
            list.add(new Incidence(i, i.angle + Math.PI * 2));
            for (int incidence = 0; incidence < list.size() - 1; ++incidence) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                comparable = (Incidence)list.get(incidence);
                Incidence incidence2 = (Incidence)list.get(incidence + 1);
                if (incidence2.angle - ((Incidence)comparable).angle < 0.001) {
                    throw new RuntimeException("tiny dihedral angle");
                }
                List<Integer> list2 = map.get(this.faces.get(((Incidence)comparable).faceIndex));
                List<Integer> list3 = map.get(this.faces.get(incidence2.faceIndex));
                if (((Incidence)comparable).reverse) {
                    n5 = 2 * (((Incidence)comparable).edgeIndex + this.faces.get(((Incidence)comparable).faceIndex).size());
                    n4 = list2.get(n5 + 1);
                    n3 = list2.get(n5);
                } else {
                    n5 = 2 * ((Incidence)comparable).edgeIndex;
                    n4 = list2.get(n5);
                    n3 = list2.get(n5 + 1);
                }
                if (incidence2.reverse) {
                    n5 = 2 * incidence2.edgeIndex;
                    n2 = list3.get(n5 + 1);
                    n = list3.get(n5);
                } else {
                    n5 = 2 * (incidence2.edgeIndex + this.faces.get(incidence2.faceIndex).size());
                    n2 = list3.get(n5);
                    n = list3.get(n5 + 1);
                }
                dynamicDSymbol.redefineOp(2, n4, n2);
                dynamicDSymbol.redefineOp(2, n3, n);
            }
        }
    }

    private void set2opTileMode(DynamicDSymbol dynamicDSymbol, Map<NetParser.Face, List<Integer>> map) {
        for (int i = 0; i < this.tiles.size(); ++i) {
            List<Pair<NetParser.Face, Vector>> list = this.tiles.get(i);
            Map<?, List<Incidence>> map2 = FaceList.collectEdges(list, true);
            for (List<Incidence> list2 : map2.values()) {
                Object object;
                if (list2.size() != 2) {
                    object = list2.size() + " faces at an edge";
                    throw new UnsupportedOperationException((String)object);
                }
                object = new int[2];
                int[] nArray = new int[2];
                boolean bl = false;
                for (int j = 0; j <= 1; ++j) {
                    Incidence incidence = list2.get(j);
                    Pair<NetParser.Face, Vector> pair = list.get(incidence.faceIndex);
                    NetParser.Face face = pair.getFirst();
                    Vector vector = pair.getSecond();
                    List<Pair<Integer, Vector>> list3 = this.tilesAtFace.get(face);
                    int n = list3.indexOf(new Pair<Integer, Vector>(i, vector));
                    int n2 = 2 * (n * face.size() + incidence.edgeIndex);
                    object[j] = map.get(face).get(n2);
                    nArray[j] = map.get(face).get(n2 + 1);
                    if (!incidence.reverse) continue;
                    bl = !bl;
                }
                if (bl) {
                    dynamicDSymbol.redefineOp(2, object[0], nArray[1]);
                    dynamicDSymbol.redefineOp(2, object[1], nArray[0]);
                    continue;
                }
                dynamicDSymbol.redefineOp(2, object[0], object[1]);
                dynamicDSymbol.redefineOp(2, nArray[0], nArray[1]);
            }
        }
    }

    private void assertCompleteness(DelaneySymbol<Integer> delaneySymbol) {
        IndexList indexList = new IndexList(delaneySymbol);
        for (int n : delaneySymbol.elements()) {
            for (int i = 0; i < indexList.size() - 1; ++i) {
                int n2 = (Integer)indexList.get(i);
                if (!delaneySymbol.definesOp(n2, n)) {
                    throw new AssertionError((Object)("op(" + n2 + ", " + n + ") undefined"));
                }
                for (int j = i + 1; j < indexList.size(); ++j) {
                    int n3 = (Integer)indexList.get(j);
                    if (!delaneySymbol.definesV(n2, n3, n)) {
                        throw new AssertionError((Object)("v(" + n2 + ", " + n3 + ", " + n + ") undefined"));
                    }
                }
            }
        }
    }

    public DSymbol getSymbol() {
        return this.ds;
    }

    public DSCover<Integer> getCover() {
        return this.cover;
    }

    public Map<Integer, Point> getPositions() {
        return this.positions;
    }

    public Matrix getGramMatrix() {
        return this.cellGramMatrix;
    }

    private static class Thing {
        public final int D;
        public final Vector inputShift;
        public final Vector tilingShift;

        public Thing(int n, Vector vector, Vector vector2) {
            this.D = n;
            this.inputShift = vector;
            this.tilingShift = vector2;
        }

        public Thing(int n) {
            this(n, Vector.zero(3), Vector.zero(3));
        }

        public int hashCode() {
            return (this.D * 37 + this.inputShift.hashCode()) * 37 + this.tilingShift.hashCode();
        }
    }

    private static class Incidence
    implements Comparable<Incidence> {
        public final int faceIndex;
        public final int edgeIndex;
        public final boolean reverse;
        public final double angle;

        public Incidence(int n, int n2, boolean bl, double d) {
            this.faceIndex = n;
            this.edgeIndex = n2;
            this.reverse = bl;
            this.angle = d;
        }

        public Incidence(int n, int n2, boolean bl) {
            this(n, n2, bl, 0.0);
        }

        public Incidence(Incidence incidence, double d) {
            this(incidence.faceIndex, incidence.edgeIndex, incidence.reverse, d);
        }

        @Override
        public int compareTo(Incidence incidence) {
            if (this.angle < incidence.angle) {
                return -1;
            }
            if (this.angle > incidence.angle) {
                return 1;
            }
            if (this.faceIndex != incidence.faceIndex) {
                return this.faceIndex - incidence.faceIndex;
            }
            if (this.edgeIndex != incidence.edgeIndex) {
                return this.edgeIndex - incidence.edgeIndex;
            }
            if (!this.reverse && incidence.reverse) {
                return -1;
            }
            if (this.reverse && !incidence.reverse) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "(" + this.faceIndex + "," + this.edgeIndex + "," + this.reverse + "," + this.angle + ")";
        }
    }

    private static class Edge
    implements Comparable<Edge> {
        public final int source;
        public final int target;
        public final Vector shift;

        public Edge(int n, int n2, Vector vector) {
            if (n < n2 || n == n2 && vector.isNonNegative()) {
                this.source = n;
                this.target = n2;
                this.shift = vector;
            } else {
                this.source = n2;
                this.target = n;
                this.shift = (Vector)vector.negative();
            }
        }

        public int hashCode() {
            return this.source * 37 + this.target * 127 + this.shift.hashCode();
        }

        public boolean equals(Object object) {
            Edge edge = (Edge)object;
            return this.source == edge.source && this.target == edge.target && this.shift.equals(edge.shift);
        }

        @Override
        public int compareTo(Edge edge) {
            if (this.source != edge.source) {
                return this.source - edge.source;
            }
            if (this.target != edge.target) {
                return this.target - edge.target;
            }
            return this.shift.compareTo(edge.shift);
        }

        public String toString() {
            return "(" + this.source + "," + this.target + "," + this.shift + ")";
        }
    }
}

