/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.io.Archive;
import org.gavrog.joss.pgraphs.io.NetParser;

public class TestArchive
extends TestCase {
    final PeriodicGraph srs = NetParser.stringToNet("PERIODIC_GRAPH\n  1 2  0 0 0\n  1 3  0 0 0\n  1 4  0 0 0\n  2 3  1 0 0\n  2 4  0 1 0\n  3 4  0 0 1\nEND\n");
    final String srs_key = "3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 3 0 1 0 2 4 1 0 0 3 4 0 0 1";
    final String keyVersion;
    final String srs_name = "srs";
    final String srs_digest = "d01d26b1ad1122626f6c4c98415129f8";
    final String srs_entry;

    public TestArchive() {
        this.keyVersion = this.srs.invariantVersion;
        this.srs_name = "srs";
        this.srs_digest = "d01d26b1ad1122626f6c4c98415129f8";
        this.srs_entry = "key      3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 3 0 1 0 2 4 1 0 0 3 4 0 0 1\nversion  " + this.keyVersion + "\n" + "id       " + "srs" + "\n" + "checksum " + "d01d26b1ad1122626f6c4c98415129f8" + "\n" + "ref      " + "\n" + "desc     " + "\n" + "end\n";
    }

    public void testEntryChecksum() {
        Archive.Entry entry1 = new Archive.Entry("3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 3 0 1 0 2 4 1 0 0 3 4 0 0 1", this.keyVersion, "srs");
        TestArchive.assertEquals((String)"d01d26b1ad1122626f6c4c98415129f8", (String)entry1.getDigestString());
        Archive.Entry entry2 = new Archive.Entry(this.srs, "srs");
        TestArchive.assertEquals((String)"d01d26b1ad1122626f6c4c98415129f8", (String)entry2.getDigestString());
    }

    public void testToString() {
        TestArchive.assertEquals((String)this.srs_entry, (String)new Archive.Entry(this.srs, "srs").toString());
    }

    public void testEntryRead() {
        BufferedReader input = new BufferedReader(new StringReader(this.srs_entry));
        Archive.Entry entry = Archive.Entry.read(input);
        TestArchive.assertEquals((String)"srs", (String)entry.getName());
        TestArchive.assertEquals((String)"3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 3 0 1 0 2 4 1 0 0 3 4 0 0 1", (String)entry.getKey());
        TestArchive.assertEquals((String)"d01d26b1ad1122626f6c4c98415129f8", (String)entry.getDigestString());
        TestArchive.assertEquals((String)this.keyVersion, (String)entry.getKeyVersion());
        TestArchive.assertNull((Object)Archive.Entry.read(input));
    }

    public void testArchiveRead() {
        Archive rcsr = new Archive("1.0");
        String path = "org/gavrog/apps/systre/rcsr.arc";
        InputStream stream = ClassLoader.getSystemResourceAsStream("org/gavrog/apps/systre/rcsr.arc");
        rcsr.addAll(new BufferedReader(new InputStreamReader(stream)));
        String key = this.srs.getSystreKey();
        Archive.Entry entry = rcsr.get(key);
        TestArchive.assertEquals((String)"srs", (String)entry.getName());
        TestArchive.assertEquals((String)"3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 3 0 1 0 2 4 1 0 0 3 4 0 0 1", (String)entry.getKey());
        TestArchive.assertEquals((String)"d01d26b1ad1122626f6c4c98415129f8", (String)entry.getDigestString());
        TestArchive.assertEquals((String)this.keyVersion, (String)entry.getKeyVersion());
        TestArchive.assertEquals((Object)rcsr.get("srs"), (Object)entry);
    }
}

