/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Pair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.generators.InputIterator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.io.Archive;
import org.gavrog.joss.pgraphs.io.GenericParser;
import org.gavrog.joss.pgraphs.io.NetParser;
import org.gavrog.joss.tilings.FaceList;
import org.gavrog.joss.tilings.Tiling;

public class Net
extends PeriodicGraph {
    private final String name;
    private final String givenGroup;
    private final Map<INode, String> nodeToName = new HashMap<INode, String>();
    private final Map<Pair<INode, Object>, Object> nodeInfo = new HashMap<Pair<INode, Object>, Object>();
    private final List<Exception> errors = new ArrayList<Exception>();
    private final List<String> warnings = new ArrayList<String>();

    public Net(int n, String string, String string2) {
        super(n);
        this.name = string;
        this.givenGroup = string2;
    }

    public Net(PeriodicGraph periodicGraph, String string, String string2) {
        super(periodicGraph.getDimension());
        HashMap<INode, INode> hashMap = new HashMap<INode, INode>();
        for (INode iGraphElement : periodicGraph.nodes()) {
            hashMap.put(iGraphElement, this.newNode());
        }
        for (IEdge iEdge : periodicGraph.edges()) {
            INode iNode = (INode)hashMap.get(iEdge.source());
            INode iNode2 = (INode)hashMap.get(iEdge.target());
            this.newEdge(iNode, iNode2, periodicGraph.getShift(iEdge));
        }
        this.name = string;
        this.givenGroup = string2;
    }

    public String getGivenGroup() {
        return this.givenGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setNodeInfo(INode iNode, Object object, Object object2) {
        assert (this.hasNode(iNode));
        this.nodeInfo.put(new Pair<INode, Object>(iNode, object), object2);
    }

    public Object getNodeInfo(INode iNode, Object object) {
        assert (this.hasNode(iNode));
        return this.nodeInfo.get(new Pair<INode, Object>(iNode, object));
    }

    public String getNodeName(INode iNode) {
        assert (this.hasNode(iNode));
        return this.nodeToName.get(iNode);
    }

    public Map<INode, String> getNodeToNameMap() {
        return new HashMap<INode, String>(this.nodeToName);
    }

    @Override
    public INode newNode() {
        INode iNode = super.newNode();
        this.nodeToName.put(iNode, "V" + iNode.id());
        return iNode;
    }

    public INode newNode(String string) {
        INode iNode = super.newNode();
        this.nodeToName.put(iNode, string);
        return iNode;
    }

    @Override
    public void delete(INode iNode) {
        this.nodeToName.remove(iNode);
        super.delete(iNode);
    }

    public boolean isOk() {
        return this.errors.isEmpty();
    }

    public Iterator<Exception> getErrors() {
        return this.errors.iterator();
    }

    public void logError(Exception exception) {
        this.errors.add(exception);
    }

    public Iterator<String> getWarnings() {
        return this.warnings.iterator();
    }

    public void addWarning(String string) {
        this.warnings.add(string);
    }

    public static Iterator<Net> iterator(String string) throws FileNotFoundException {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        final BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        if ("cgd".equals(string2) || "pgr".equals(string2)) {
            final NetParser netParser = new NetParser(bufferedReader);
            return new Iterator<Net>(){

                @Override
                public boolean hasNext() {
                    return !netParser.atEnd();
                }

                @Override
                public Net next() {
                    return Net.extract(netParser);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("not supported");
                }
            };
        }
        if ("ds".equals(string2) || "tgs".equals(string2)) {
            return new FilteredIterator<Net, DSymbol>((Iterator)new InputIterator(bufferedReader)){

                @Override
                public Net filter(DSymbol dSymbol) {
                    Tiling.Skeleton skeleton = new Tiling(dSymbol).getSkeleton();
                    String string = dSymbol.dim() == 3 ? "P1" : "p1";
                    return new Net(skeleton, null, string);
                }
            };
        }
        if ("arc".equals(string2)) {
            return new IteratorAdapter<Net>(){

                @Override
                protected Net findNext() throws NoSuchElementException {
                    Archive.Entry entry = Archive.Entry.read(bufferedReader);
                    if (entry == null) {
                        throw new NoSuchElementException("at end");
                    }
                    String string = entry.getKey();
                    PeriodicGraph periodicGraph = PeriodicGraph.fromInvariantString(string);
                    String string2 = periodicGraph.getDimension() == 3 ? "P1" : "p1";
                    return new Net(periodicGraph, entry.getName(), string2);
                }
            };
        }
        throw new IllegalFileNameException("Unrecognized extension \"." + string2 + "\"");
    }

    private static Net extract(NetParser netParser) {
        GenericParser.Block block = netParser.parseDataBlock();
        if (block.getType().toLowerCase().equals("tiling")) {
            FaceList faceList = new FaceList(block);
            Tiling tiling = new Tiling(faceList.getSymbol());
            Map<Integer, Point> map = faceList.getPositions();
            Tiling.Skeleton skeleton = tiling.getSkeleton();
            Net net = new Net(skeleton.getDimension(), block.getEntriesAsString("name"), "P1");
            HashMap<INode, INode> hashMap = new HashMap<INode, INode>();
            for (INode iGraphElement : skeleton.nodes()) {
                hashMap.put(iGraphElement, net.newNode());
            }
            for (IEdge iEdge : skeleton.edges()) {
                INode iNode = (INode)hashMap.get(iEdge.source());
                INode iNode2 = (INode)hashMap.get(iEdge.target());
                net.newEdge(iNode, iNode2, skeleton.getShift(iEdge));
            }
            Iterator<Object> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                net.setNodeInfo((INode)hashMap.get(skeleton.nodeForChamber(n)), NetParser.POSITION, map.get(n));
            }
            return net;
        }
        return netParser.parseNet(block);
    }

    public static class IllegalFileNameException
    extends RuntimeException {
        private static final long serialVersionUID = 4776009175735945241L;

        public IllegalFileNameException(String string) {
            super(string);
        }
    }
}

