/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.basic;

import junit.framework.TestCase;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;

public class TestMorphism
extends TestCase {
    private PeriodicGraph cds;
    private PeriodicGraph dia;
    private PeriodicGraph x;
    private PeriodicGraph y;
    private INode v1;
    private INode v2;
    private INode w1;
    private INode w2;
    private INode x1;
    private INode x2;
    private INode y1;
    private IEdge e1;
    private IEdge e2;
    private IEdge e3;
    private IEdge e4;
    private Operator inversion;
    private Operator rot_xyz;
    private Operator rot_y;
    private Operator stretch_x;
    private Morphism autoDia1;
    private Morphism autoDia2;
    private Morphism autoCds1;
    private Morphism nonInjective;

    protected void setUp() throws Exception {
        super.setUp();
        this.cds = new PeriodicGraph(3);
        this.v1 = this.cds.newNode();
        this.v2 = this.cds.newNode();
        this.e1 = this.cds.newEdge(this.v1, this.v2);
        int[] nArray = new int[3];
        nArray[0] = 1;
        this.e2 = this.cds.newEdge(this.v2, this.v2, nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = -1;
        this.e3 = this.cds.newEdge(this.v2, this.v1, nArray2);
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        this.e4 = this.cds.newEdge(this.v1, this.v1, nArray3);
        this.dia = new PeriodicGraph(3);
        this.w1 = this.dia.newNode();
        this.w2 = this.dia.newNode();
        this.dia.newEdge(this.w1, this.w2, new int[3]);
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        this.dia.newEdge(this.w1, this.w2, nArray4);
        int[] nArray5 = new int[3];
        nArray5[1] = -1;
        this.dia.newEdge(this.w1, this.w2, nArray5);
        int[] nArray6 = new int[3];
        nArray6[2] = -1;
        this.dia.newEdge(this.w1, this.w2, nArray6);
        this.x = new PeriodicGraph(2);
        this.x1 = this.x.newNode();
        this.x2 = this.x.newNode();
        this.x.newEdge(this.x1, this.x2, new int[2]);
        int[] nArray7 = new int[2];
        nArray7[0] = -1;
        this.x.newEdge(this.x1, this.x2, nArray7);
        int[] nArray8 = new int[2];
        nArray8[1] = 1;
        this.x.newEdge(this.x1, this.x1, nArray8);
        int[] nArray9 = new int[2];
        nArray9[1] = 1;
        this.x.newEdge(this.x2, this.x2, nArray9);
        this.y = new PeriodicGraph(2);
        this.y1 = this.y.newNode();
        int[] nArray10 = new int[2];
        nArray10[0] = 1;
        this.y.newEdge(this.y1, this.y1, nArray10);
        int[] nArray11 = new int[2];
        nArray11[1] = 1;
        this.y.newEdge(this.y1, this.y1, nArray11);
        this.inversion = new Operator("-x,-y,-z");
        this.rot_xyz = new Operator("z,x,y");
        this.rot_y = new Operator("-z,y,x");
        this.stretch_x = new Operator("2x,y");
        this.autoDia1 = new Morphism(this.w1, this.w2, this.inversion);
        this.autoDia2 = new Morphism(this.w1, this.w1, this.rot_xyz);
        this.autoCds1 = new Morphism(this.v1, this.v2, this.rot_y);
        this.nonInjective = new Morphism(this.x1, this.y1, this.stretch_x);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMorphismINodeINodeMatrix() {
        try {
            new Morphism(this.w1, this.w1, this.inversion);
            TestMorphism.fail((String)"should throw a NoSuchMorphismException");
        }
        catch (Morphism.NoSuchMorphismException noSuchMorphismException) {
            // empty catch block
        }
        try {
            new Morphism(this.w1, this.w2, this.rot_xyz);
            TestMorphism.fail((String)"should throw a NoSuchMorphismException");
        }
        catch (Morphism.NoSuchMorphismException noSuchMorphismException) {
            // empty catch block
        }
    }

    public void testMorphismMorphism() {
        Morphism map = new Morphism(this.autoDia1);
        TestMorphism.assertTrue((boolean)map.isIsomorphism());
        TestMorphism.assertEquals((int)10, (int)map.size());
        TestMorphism.assertEquals((Object)this.w1, (Object)map.get(map.getASource(this.w1)));
    }

    public void testInverse() {
        Morphism map = this.autoDia1.inverse();
        TestMorphism.assertTrue((boolean)map.isIsomorphism());
        TestMorphism.assertEquals((int)10, (int)map.size());
        IteratorAdapter<INode> nodes = this.dia.nodes();
        while (nodes.hasNext()) {
            INode v = (INode)nodes.next();
            TestMorphism.assertEquals((Object)v, (Object)map.get(this.autoDia1.get(v)));
            TestMorphism.assertEquals((Object)v, (Object)this.autoDia1.get(map.get(v)));
        }
        IteratorAdapter<IEdge> edges = this.dia.edges();
        while (edges.hasNext()) {
            IEdge e = ((IEdge)edges.next()).oriented();
            IEdge r = e.reverse();
            TestMorphism.assertEquals((Object)e, (Object)map.get(this.autoDia1.get(e)));
            TestMorphism.assertEquals((Object)e, (Object)this.autoDia1.get(map.get(e)));
            TestMorphism.assertEquals((Object)r, (Object)map.get(this.autoDia1.get(r)));
            TestMorphism.assertEquals((Object)r, (Object)this.autoDia1.get(map.get(r)));
        }
        try {
            this.nonInjective.inverse();
            TestMorphism.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestMorphism.assertEquals((Object)this.autoDia1, (Object)map);
        TestMorphism.assertEquals((int)this.autoDia1.hashCode(), (int)map.hashCode());
        TestMorphism.assertFalse((boolean)this.autoDia2.equals(this.autoDia2.inverse()));
    }

    public void testTimes() {
        Morphism map = this.autoDia1.times(this.autoDia2);
        TestMorphism.assertTrue((boolean)map.isIsomorphism());
        TestMorphism.assertEquals((int)10, (int)map.size());
        IteratorAdapter<INode> nodes = this.dia.nodes();
        while (nodes.hasNext()) {
            INode v = (INode)nodes.next();
            TestMorphism.assertEquals((Object)this.autoDia2.get(this.autoDia1.get(v)), (Object)map.get(v));
            TestMorphism.assertEquals((Object)this.autoDia1.getASource(this.autoDia2.getASource(v)), (Object)map.getASource(v));
        }
        IteratorAdapter<IEdge> edges = this.dia.edges();
        while (edges.hasNext()) {
            IEdge e = ((IEdge)edges.next()).oriented();
            IEdge r = e.reverse();
            TestMorphism.assertEquals((Object)this.autoDia2.get(this.autoDia1.get(e)), (Object)map.get(e));
            TestMorphism.assertEquals((Object)this.autoDia1.getASource(this.autoDia2.getASource(e)), (Object)map.getASource(e));
            TestMorphism.assertEquals((Object)this.autoDia2.get(this.autoDia1.get(r)), (Object)map.get(r));
            TestMorphism.assertEquals((Object)this.autoDia1.getASource(this.autoDia2.getASource(r)), (Object)map.getASource(r));
        }
    }

    public void testIsIsomorphism() {
        TestMorphism.assertTrue((boolean)this.autoCds1.isIsomorphism());
        TestMorphism.assertTrue((boolean)this.autoDia1.isIsomorphism());
        TestMorphism.assertTrue((boolean)this.autoDia2.isIsomorphism());
        TestMorphism.assertFalse((boolean)this.nonInjective.isIsomorphism());
    }

    public void testGetASource() {
        IEdge r;
        IEdge e;
        INode v;
        IteratorAdapter<INode> nodes = this.dia.nodes();
        while (nodes.hasNext()) {
            v = (INode)nodes.next();
            TestMorphism.assertEquals((Object)v, (Object)this.autoDia1.get(this.autoDia1.getASource(v)));
            TestMorphism.assertEquals((Object)v, (Object)this.autoDia2.get(this.autoDia2.getASource(v)));
        }
        IteratorAdapter<IEdge> edges = this.dia.edges();
        while (edges.hasNext()) {
            e = ((IEdge)edges.next()).oriented();
            r = e.reverse();
            TestMorphism.assertEquals((Object)e, (Object)this.autoDia1.get(this.autoDia1.getASource(e)));
            TestMorphism.assertEquals((Object)e, (Object)this.autoDia2.get(this.autoDia2.getASource(e)));
            TestMorphism.assertEquals((Object)r, (Object)this.autoDia1.get(this.autoDia1.getASource(r)));
            TestMorphism.assertEquals((Object)r, (Object)this.autoDia2.get(this.autoDia2.getASource(r)));
        }
        nodes = this.cds.nodes();
        while (nodes.hasNext()) {
            v = (INode)nodes.next();
            TestMorphism.assertEquals((Object)v, (Object)this.autoCds1.get(this.autoCds1.getASource(v)));
        }
        edges = this.cds.edges();
        while (edges.hasNext()) {
            e = ((IEdge)edges.next()).oriented();
            r = e.reverse();
            TestMorphism.assertEquals((Object)e, (Object)this.autoCds1.get(this.autoCds1.getASource(e)));
            TestMorphism.assertEquals((Object)r, (Object)this.autoCds1.get(this.autoCds1.getASource(r)));
        }
        nodes = this.y.nodes();
        while (nodes.hasNext()) {
            v = (INode)nodes.next();
            TestMorphism.assertEquals((Object)v, (Object)this.nonInjective.get(this.nonInjective.getASource(v)));
        }
        edges = this.y.edges();
        while (edges.hasNext()) {
            e = ((IEdge)edges.next()).oriented();
            r = e.reverse();
            TestMorphism.assertEquals((Object)e, (Object)this.nonInjective.get(this.nonInjective.getASource(e)));
            TestMorphism.assertEquals((Object)r, (Object)this.nonInjective.get(this.nonInjective.getASource(r)));
        }
    }

    public void testGetLinearOperator() {
        TestMorphism.assertEquals((Object)this.inversion, (Object)this.autoDia1.getLinearOperator());
        TestMorphism.assertEquals((Object)this.rot_xyz, (Object)this.autoDia2.getLinearOperator());
        TestMorphism.assertEquals((Object)this.rot_y, (Object)this.autoCds1.getLinearOperator());
    }

    public void testGetTranslation() {
        Vector t1 = (Vector)new Vector(1, 1, 1).dividedBy(4L);
        Vector t2 = new Vector(0, 0, 0);
        Vector t3 = (Vector)new Vector(0, 1, 0).dividedBy(2L);
        TestMorphism.assertEquals((Object)t1, (Object)this.autoDia1.getTranslation());
        TestMorphism.assertEquals((Object)t2, (Object)this.autoDia2.getTranslation());
        TestMorphism.assertEquals((Object)t3, (Object)this.autoCds1.getTranslation());
    }

    public void testGetAffineOperator() {
        TestMorphism.assertEquals((Object)new Operator("1/4-x,1/4-y,1/4-z"), (Object)this.autoDia1.getAffineOperator());
        TestMorphism.assertEquals((Object)this.rot_xyz, (Object)this.autoDia2.getAffineOperator());
        TestMorphism.assertEquals((Object)new Operator("-z,y+1/2,x"), (Object)this.autoCds1.getAffineOperator());
    }

    public void testSize() {
        TestMorphism.assertEquals((int)10, (int)this.autoDia1.size());
        TestMorphism.assertEquals((int)10, (int)this.autoDia2.size());
        TestMorphism.assertEquals((int)10, (int)this.autoCds1.size());
        TestMorphism.assertEquals((int)10, (int)this.nonInjective.size());
    }

    public void testContainsKey() {
        IteratorAdapter<INode> nodes = this.dia.nodes();
        while (nodes.hasNext()) {
            INode v = (INode)nodes.next();
            TestMorphism.assertTrue((boolean)this.autoDia1.containsKey(v));
            TestMorphism.assertTrue((boolean)this.autoDia2.containsKey(v));
        }
        IteratorAdapter<IEdge> edges = this.dia.edges();
        while (edges.hasNext()) {
            IEdge e = (IEdge)edges.next();
            IEdge o = e.oriented();
            IEdge r = o.reverse();
            TestMorphism.assertTrue((boolean)this.autoDia1.containsKey(o));
            TestMorphism.assertTrue((boolean)this.autoDia2.containsKey(o));
            TestMorphism.assertTrue((boolean)this.autoDia1.containsKey(r));
            TestMorphism.assertTrue((boolean)this.autoDia2.containsKey(r));
            TestMorphism.assertFalse((boolean)this.autoDia1.containsKey(e));
            TestMorphism.assertFalse((boolean)this.autoDia2.containsKey(e));
        }
    }

    public void testContainsValue() {
        IteratorAdapter<INode> nodes = this.dia.nodes();
        while (nodes.hasNext()) {
            INode v = (INode)nodes.next();
            TestMorphism.assertTrue((boolean)this.autoDia1.containsValue(v));
            TestMorphism.assertTrue((boolean)this.autoDia2.containsValue(v));
        }
        IteratorAdapter<IEdge> edges = this.dia.edges();
        while (edges.hasNext()) {
            IEdge e = (IEdge)edges.next();
            IEdge o = e.oriented();
            IEdge r = o.reverse();
            TestMorphism.assertTrue((boolean)this.autoDia1.containsValue(o));
            TestMorphism.assertTrue((boolean)this.autoDia2.containsValue(o));
            TestMorphism.assertTrue((boolean)this.autoDia1.containsValue(r));
            TestMorphism.assertTrue((boolean)this.autoDia2.containsValue(r));
            TestMorphism.assertFalse((boolean)this.autoDia1.containsValue(e));
            TestMorphism.assertFalse((boolean)this.autoDia2.containsValue(e));
        }
    }

    public void testGet() {
        TestMorphism.assertEquals((Object)this.w2, (Object)this.autoDia1.get(this.w1));
        TestMorphism.assertEquals((Object)this.w1, (Object)this.autoDia1.get(this.w2));
        TestMorphism.assertEquals((Object)this.w1, (Object)this.autoDia2.get(this.w1));
        TestMorphism.assertEquals((Object)this.w2, (Object)this.autoDia2.get(this.w2));
        TestMorphism.assertEquals((Object)this.v2, (Object)this.autoCds1.get(this.v1));
        TestMorphism.assertEquals((Object)this.v1, (Object)this.autoCds1.get(this.v2));
        IEdge e1o = this.e1.oriented();
        IEdge e2o = this.e2.oriented();
        IEdge e3o = this.e3.oriented();
        IEdge e4o = this.e4.oriented();
        TestMorphism.assertEquals((Object)e3o, (Object)this.autoCds1.get(e1o));
        TestMorphism.assertEquals((Object)e4o, (Object)this.autoCds1.get(e2o));
        TestMorphism.assertEquals((Object)e4o.reverse(), (Object)this.autoCds1.get(e2o.reverse()));
        TestMorphism.assertEquals((Object)e1o, (Object)this.autoCds1.get(e3o));
        TestMorphism.assertEquals((Object)e2o.reverse(), (Object)this.autoCds1.get(e4o));
        TestMorphism.assertEquals((Object)e2o, (Object)this.autoCds1.get(e4o.reverse()));
    }
}

