/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import junit.framework.TestCase;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.OperatorType;

public class TestOperatorType
extends TestCase {
    final OperatorType ot0 = new OperatorType(3, true, 3, true);
    final OperatorType ot1 = new OperatorType(new Operator("-y,x"));
    final OperatorType ot2 = new OperatorType(new Operator("y,x"));
    final OperatorType ot3 = new OperatorType(new Operator("z,x,y"));
    final OperatorType ot4 = new OperatorType(new Operator("y,z,x"));
    final OperatorType ot5 = new OperatorType(new Operator("x,y"));
    final OperatorType ot6 = new OperatorType(new Operator("x,y,z"));
    final OperatorType ot7 = new OperatorType(new Operator("y,-x"));
    final OperatorType ot8 = new OperatorType(new Operator("-y,-z,-x"));
    final OperatorType ot9 = new OperatorType(new Operator("-y,x-y,z"));

    public void testGetDimension() {
        TestOperatorType.assertEquals((int)3, (int)this.ot0.getDimension());
        TestOperatorType.assertEquals((int)2, (int)this.ot1.getDimension());
        TestOperatorType.assertEquals((int)2, (int)this.ot2.getDimension());
        TestOperatorType.assertEquals((int)3, (int)this.ot3.getDimension());
        TestOperatorType.assertEquals((int)3, (int)this.ot4.getDimension());
        TestOperatorType.assertEquals((int)2, (int)this.ot5.getDimension());
        TestOperatorType.assertEquals((int)3, (int)this.ot6.getDimension());
        TestOperatorType.assertEquals((int)2, (int)this.ot7.getDimension());
        TestOperatorType.assertEquals((int)3, (int)this.ot8.getDimension());
        TestOperatorType.assertEquals((int)3, (int)this.ot9.getDimension());
    }

    public void testIsClockwise() {
        TestOperatorType.assertTrue((boolean)this.ot0.isClockwise());
        TestOperatorType.assertTrue((boolean)this.ot1.isClockwise());
        TestOperatorType.assertFalse((boolean)this.ot2.isClockwise());
        TestOperatorType.assertTrue((boolean)this.ot3.isClockwise());
        TestOperatorType.assertFalse((boolean)this.ot4.isClockwise());
        TestOperatorType.assertTrue((boolean)this.ot5.isClockwise());
        TestOperatorType.assertTrue((boolean)this.ot6.isClockwise());
        TestOperatorType.assertFalse((boolean)this.ot7.isClockwise());
        TestOperatorType.assertFalse((boolean)this.ot8.isClockwise());
        TestOperatorType.assertTrue((boolean)this.ot9.isClockwise());
    }

    public void testGetOrder() {
        TestOperatorType.assertEquals((int)3, (int)this.ot0.getOrder());
        TestOperatorType.assertEquals((int)4, (int)this.ot1.getOrder());
        TestOperatorType.assertEquals((int)2, (int)this.ot2.getOrder());
        TestOperatorType.assertEquals((int)3, (int)this.ot3.getOrder());
        TestOperatorType.assertEquals((int)3, (int)this.ot4.getOrder());
        TestOperatorType.assertEquals((int)1, (int)this.ot5.getOrder());
        TestOperatorType.assertEquals((int)1, (int)this.ot6.getOrder());
        TestOperatorType.assertEquals((int)4, (int)this.ot7.getOrder());
        TestOperatorType.assertEquals((int)3, (int)this.ot8.getOrder());
        TestOperatorType.assertEquals((int)3, (int)this.ot9.getOrder());
    }

    public void testIsOrientationPreserving() {
        TestOperatorType.assertTrue((boolean)this.ot0.isOrientationPreserving());
        TestOperatorType.assertTrue((boolean)this.ot1.isOrientationPreserving());
        TestOperatorType.assertFalse((boolean)this.ot2.isOrientationPreserving());
        TestOperatorType.assertTrue((boolean)this.ot3.isOrientationPreserving());
        TestOperatorType.assertTrue((boolean)this.ot4.isOrientationPreserving());
        TestOperatorType.assertTrue((boolean)this.ot5.isOrientationPreserving());
        TestOperatorType.assertTrue((boolean)this.ot6.isOrientationPreserving());
        TestOperatorType.assertTrue((boolean)this.ot7.isOrientationPreserving());
        TestOperatorType.assertFalse((boolean)this.ot8.isOrientationPreserving());
        TestOperatorType.assertTrue((boolean)this.ot9.isOrientationPreserving());
    }

    public void testEquals() {
        TestOperatorType.assertFalse((boolean)this.ot1.equals(this.ot2));
        TestOperatorType.assertTrue((boolean)this.ot3.equals(this.ot0));
        TestOperatorType.assertFalse((boolean)this.ot3.equals(this.ot1));
        TestOperatorType.assertFalse((boolean)this.ot3.equals(this.ot4));
        TestOperatorType.assertFalse((boolean)this.ot3.equals(this.ot8));
        TestOperatorType.assertTrue((boolean)this.ot3.equals(this.ot9));
        TestOperatorType.assertTrue((boolean)this.ot0.equals(this.ot9));
    }

    public void testHashCode() {
        TestOperatorType.assertEquals((int)this.ot0.hashCode(), (int)this.ot3.hashCode());
        TestOperatorType.assertEquals((int)this.ot0.hashCode(), (int)this.ot9.hashCode());
    }
}

