/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import junit.framework.TestCase;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Lattices;
import org.gavrog.joss.geometry.Vector;

public class TestLattices
extends TestCase {
    public void testIsBasis() {
        Vector[] a = new Vector[]{new Vector(new int[]{1, 2, 3}), new Vector(new int[]{4, 5, 6}), new Vector(new int[]{7, 8, 9})};
        TestLattices.assertFalse((boolean)Lattices.isBasis(a));
        Vector[] b = new Vector[]{new Vector(new int[]{1, 2}), new Vector(new int[]{4, 5})};
        TestLattices.assertTrue((boolean)Lattices.isBasis(b));
        Vector[] c = new Vector[]{new Vector(new int[]{1, 2, 3}), new Vector(new int[]{4, 5, 6}), new Vector(new int[]{7, 8, 8})};
        TestLattices.assertTrue((boolean)Lattices.isBasis(c));
    }

    public void testGaussReduced() {
        Matrix G = new Matrix(new int[][]{{4, 1}, {1, 5}});
        Vector[] b = new Vector[]{new Vector(new int[]{1, 2}), new Vector(new int[]{4, 5})};
        Vector[] v = Lattices.gaussReduced(b, G);
        TestLattices.assertTrue((boolean)Lattices.isBasis(v));
        Vector[] w = new Vector[]{v[0], v[1], (Vector)v[0].negative().minus(v[1])};
        int i = 0;
        while (i < 2) {
            int j = i + 1;
            while (j < 3) {
                TestLattices.assertFalse((boolean)Vector.dot(w[i], w[j], G).isPositive());
                ++j;
            }
            ++i;
        }
        Matrix A = (Matrix)Vector.toMatrix(v).dividedBy(Vector.toMatrix(b));
        TestLattices.assertTrue((boolean)A.determinant().abs().isOne());
        int i2 = 0;
        while (i2 < 2) {
            int j = 0;
            while (j < 2) {
                TestLattices.assertTrue((boolean)(A.get(i2, j) instanceof Whole));
                ++j;
            }
            ++i2;
        }
    }

    public void testSellingReduced() {
        Matrix G = new Matrix(new int[][]{{4, 1, 3}, {1, 5, 2}, {3, 2, 6}});
        Vector[] b = new Vector[]{new Vector(new int[]{1, 2, 3}), new Vector(new int[]{4, 5, 6}), new Vector(new int[]{7, 8, 8})};
        Vector[] v = Lattices.sellingReduced(b, G);
        TestLattices.assertTrue((boolean)Lattices.isBasis(v));
        Vector[] w = new Vector[]{v[0], v[1], v[2], (Vector)v[0].negative().minus(v[1]).minus(v[2])};
        int i = 0;
        while (i < 3) {
            int j = i + 1;
            while (j < 4) {
                TestLattices.assertFalse((boolean)Vector.dot(w[i], w[j], G).isPositive());
                ++j;
            }
            ++i;
        }
        Matrix A = (Matrix)Vector.toMatrix(v).dividedBy(Vector.toMatrix(b));
        TestLattices.assertTrue((boolean)A.determinant().abs().isOne());
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                TestLattices.assertTrue((boolean)(A.get(i2, j) instanceof Whole));
                ++j;
            }
            ++i2;
        }
    }

    public void testReducedBasis() {
        Matrix G = new Matrix(new int[][]{{4, 1, 3}, {1, 5, 2}, {3, 2, 6}});
        Vector[] b = new Vector[]{new Vector(new int[]{1, 2, 3}), new Vector(new int[]{4, 5, 6}), new Vector(new int[]{7, 8, 8})};
        Vector[] v = Lattices.reducedLatticeBasis(b, G);
        TestLattices.assertTrue((boolean)Lattices.isBasis(v));
        Matrix A = (Matrix)Vector.toMatrix(v).dividedBy(Vector.toMatrix(b));
        TestLattices.assertTrue((boolean)A.determinant().isOne());
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                TestLattices.assertTrue((boolean)(A.get(i, j) instanceof Whole));
                ++j;
            }
            ++i;
        }
    }
}

