/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;

public class Lattices {
    public static boolean isBasis(Vector[] vectorArray) {
        return !Vector.toMatrix(vectorArray).determinant().isZero();
    }

    public static Vector[] gaussReduced(Vector[] vectorArray, Matrix matrix) {
        int n;
        int n2;
        if (vectorArray.length != 2) {
            throw new IllegalArgumentException("first argument must contain 2 vectors");
        }
        if (!matrix.equals(matrix.transposed())) {
            throw new IllegalArgumentException("second argument must be a symmetric 2x2 matrix");
        }
        FloatingPoint floatingPoint = new FloatingPoint(1.0E-12);
        IArithmetic[] iArithmeticArray = new IArithmetic[]{Vector.dot(vectorArray[0], vectorArray[0], matrix), Vector.dot(vectorArray[1], vectorArray[1], matrix)};
        do {
            n = iArithmeticArray[0].isLessThan(iArithmeticArray[1]) ? 0 : 1;
            n2 = 1 - n;
            IArithmetic iArithmetic = Vector.dot(vectorArray[n], vectorArray[n2], matrix).dividedBy(iArithmeticArray[n]).round();
            vectorArray[n2] = (Vector)vectorArray[n2].minus(iArithmetic.times(vectorArray[n]));
            iArithmeticArray[n2] = Vector.dot(vectorArray[n2], vectorArray[n2], matrix);
        } while (!iArithmeticArray[n2].isGreaterOrEqual(iArithmeticArray[n].minus(floatingPoint)));
        if (Vector.dot(vectorArray[0], vectorArray[1], matrix).isPositive()) {
            vectorArray[1] = (Vector)vectorArray[1].negative();
        }
        return vectorArray;
    }

    private static boolean sellingStep(Vector[] vectorArray, Matrix matrix) {
        FloatingPoint floatingPoint = new FloatingPoint(1.0E-12);
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                if (!Vector.dot(vectorArray[i], vectorArray[j], matrix).isGreaterThan(floatingPoint)) continue;
                for (int k = 0; k < 4; ++k) {
                    if (k == i || k == j) continue;
                    vectorArray[k] = (Vector)vectorArray[k].plus(vectorArray[i]);
                }
                vectorArray[i] = (Vector)vectorArray[i].negative();
                return true;
            }
        }
        return false;
    }

    public static Vector[] sellingReduced(Vector[] vectorArray, Matrix matrix) {
        if (vectorArray.length != 3) {
            throw new IllegalArgumentException("first argument must contain 3 vectors");
        }
        if (!matrix.equals(matrix.transposed())) {
            throw new IllegalArgumentException("second argument must be a symmetric matrix");
        }
        Vector[] vectorArray2 = new Vector[]{vectorArray[0], vectorArray[1], vectorArray[2], (Vector)vectorArray[0].plus(vectorArray[1]).plus(vectorArray[2]).negative()};
        while (Lattices.sellingStep(vectorArray2, matrix)) {
        }
        return new Vector[]{vectorArray2[0], vectorArray2[1], vectorArray2[2]};
    }

    public static Vector[] dirichletVectors(Vector[] vectorArray, Matrix matrix) {
        int n = vectorArray.length;
        if (!matrix.equals(matrix.transposed())) {
            String string = "second argument must be symmetric, but was " + matrix;
            throw new IllegalArgumentException(string);
        }
        switch (n) {
            case 0: {
                return new Vector[0];
            }
            case 1: {
                return new Vector[]{vectorArray[0]};
            }
            case 2: {
                Vector[] vectorArray2 = Lattices.gaussReduced(vectorArray, matrix);
                return new Vector[]{vectorArray2[0], vectorArray2[1], (Vector)vectorArray2[0].plus(vectorArray2[1])};
            }
            case 3: {
                Vector[] vectorArray3 = Lattices.sellingReduced(vectorArray, matrix);
                return new Vector[]{vectorArray3[0], vectorArray3[1], vectorArray3[2], (Vector)vectorArray3[0].plus(vectorArray3[1]), (Vector)vectorArray3[0].plus(vectorArray3[2]), (Vector)vectorArray3[1].plus(vectorArray3[2]), (Vector)vectorArray3[0].plus(vectorArray3[1]).plus(vectorArray3[2])};
            }
        }
        throw new UnsupportedOperationException("only dimensions up to 3 work");
    }

    public static Vector[] reducedLatticeBasis(Vector[] vectorArray, final Matrix matrix) {
        Vector[] vectorArray2 = Lattices.dirichletVectors(vectorArray, matrix);
        Arrays.sort(vectorArray2, new Comparator<Vector>(){

            @Override
            public int compare(Vector vector, Vector vector2) {
                int n = Vector.dot(vector, vector, matrix).compareTo(Vector.dot(vector2, vector2, matrix));
                if (n == 0) {
                    return vector2.abs().compareTo(vector.abs());
                }
                return n;
            }
        });
        int n = vectorArray[0].getDimension();
        Vector[] vectorArray3 = new Vector[n];
        Matrix matrix2 = Matrix.zero(n, n).mutableClone();
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            while (n2 < vectorArray2.length) {
                vectorArray3[i] = vectorArray2[n2];
                if (vectorArray3[i].isNegative()) {
                    vectorArray3[i] = (Vector)vectorArray3[i].negative();
                }
                if (i > 0 && Vector.dot(vectorArray3[0], vectorArray3[i], matrix).isPositive()) {
                    vectorArray3[i] = (Vector)vectorArray3[i].negative();
                }
                matrix2.setRow(i, vectorArray3[i].getCoordinates());
                if (Lattices.fuzzy_rank(matrix2, 1.0E-8) > i) continue block0;
                ++n2;
            }
        }
        return vectorArray3;
    }

    private static int fuzzy_rank(Matrix matrix, double d) {
        Matrix matrix2 = matrix.mutableClone();
        Matrix.triangulate(matrix2, null, false, false);
        int n = 0;
        for (int i = 0; i < matrix2.numberOfColumns(); ++i) {
            boolean bl;
            if (n >= matrix2.numberOfRows()) continue;
            IArithmetic iArithmetic = matrix2.get(n, i);
            if (iArithmetic.isExact()) {
                bl = iArithmetic.isZero();
            } else {
                boolean bl2 = bl = ((Real)iArithmetic.abs()).doubleValue() < Math.abs(d);
            }
            if (bl) continue;
            ++n;
        }
        return n;
    }

    public static Vector[] dirichletShifts(Point point, Vector[] vectorArray, Matrix matrix, int n) {
        IArithmetic iArithmetic;
        IArithmetic iArithmetic2;
        IArithmetic iArithmetic3;
        boolean bl;
        int n2 = point.getDimension();
        Fraction fraction = new Fraction(1L, 2L);
        Fraction fraction2 = new Fraction(-1L, 2L);
        Vector vector = (Vector)point.minus(Point.origin(n2));
        Vector vector2 = Vector.zero(n2);
        do {
            bl = false;
            for (int i = 0; i < vectorArray.length; ++i) {
                Vector vector3 = (Vector)vectorArray[i].times(n);
                iArithmetic3 = Vector.dot(vector3, vector3, matrix);
                iArithmetic2 = (Vector)vector.plus(vector2);
                iArithmetic = Vector.dot(iArithmetic2, vector3, matrix).dividedBy(iArithmetic3);
                if (iArithmetic.isGreaterThan(fraction.plus(1.0E-8))) {
                    vector2 = (Vector)vector2.minus(vector3.times(iArithmetic.plus(fraction).floor()));
                    bl = true;
                    continue;
                }
                if (!iArithmetic.isLessOrEqual(fraction2)) continue;
                vector2 = (Vector)vector2.minus(vector3.times(iArithmetic.plus(fraction).minus(1.0E-8).floor()));
                bl = true;
            }
        } while (bl);
        Vector vector4 = (Vector)vector.plus(vector2);
        HashSet<Vector> hashSet = new HashSet<Vector>();
        hashSet.add(vector2);
        for (int i = 0; i < vectorArray.length; ++i) {
            iArithmetic3 = (Vector)vectorArray[i].times(n);
            iArithmetic2 = Vector.dot((Vector)iArithmetic3, (Vector)iArithmetic3, matrix);
            iArithmetic = Vector.dot(vector4, (Vector)iArithmetic3, matrix).dividedBy(iArithmetic2);
            if (iArithmetic.isGreaterThan(fraction.minus(0.01))) {
                hashSet.add((Vector)vector2.minus(iArithmetic3));
                continue;
            }
            if (!iArithmetic.isLessThan(fraction2.plus(0.01))) continue;
            hashSet.add((Vector)vector2.plus(iArithmetic3));
        }
        Vector[] vectorArray2 = new Vector[hashSet.size()];
        hashSet.toArray(vectorArray2);
        return vectorArray2;
    }
}

