/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.experiments;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Partition;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.io.Net;
import org.gavrog.joss.pgraphs.io.NetParser;
import org.gavrog.joss.pgraphs.io.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ladder {
    private final PeriodicGraph graph;
    private final Partition<INode> rungPartition;
    private final List<Morphism> stileMaps;

    public Ladder(PeriodicGraph G) {
        if (!G.isConnected()) {
            throw new UnsupportedOperationException("graph must be connected");
        }
        if (!G.isLocallyStable()) {
            throw new UnsupportedOperationException("graph must be locally stable");
        }
        this.graph = G;
        Operator I = Operator.identity(G.getDimension());
        Partition<INode> P = new Partition<INode>();
        IteratorAdapter<INode> iter = G.nodes();
        INode start = (INode)iter.next();
        Map<INode, Point> pos = G.barycentricPlacement();
        Point pos0 = pos.get(start);
        while (iter.hasNext()) {
            Morphism iso;
            INode v = (INode)iter.next();
            Point posv = pos.get(v);
            if (!((Vector)posv.minus(pos0)).modZ().isZero() || P.areEquivalent(start, v)) continue;
            try {
                iso = new Morphism(start, v, I);
            }
            catch (Morphism.NoSuchMorphismException ex) {
                continue;
            }
            boolean hasFixedPoints = false;
            for (INode w : G.nodes()) {
                INode u;
                if (!w.equals(u = iso.getImage(w))) continue;
                hasFixedPoints = true;
                break;
            }
            if (hasFixedPoints) continue;
            for (INode w : G.nodes()) {
                P.unite(w, iso.getImage(w));
            }
        }
        this.rungPartition = P;
        LinkedList<Morphism> maps = new LinkedList<Morphism>();
        Iterator classes = P.classes();
        while (classes.hasNext()) {
            Set A = classes.next();
            if (!A.contains(start)) continue;
            for (INode v : A) {
                maps.add(new Morphism(start, v, I));
            }
        }
        this.stileMaps = maps;
    }

    public PeriodicGraph getGraph() {
        return this.graph;
    }

    public List<Morphism> getStileMaps() {
        return this.stileMaps;
    }

    public Partition<INode> getRungPartition() {
        return this.rungPartition;
    }

    public static void main(String[] args) {
        try {
            InputStreamReader r = args.length > 0 ? new FileReader(args[0]) : new InputStreamReader(System.in);
            OutputStreamWriter w = args.length > 1 ? new FileWriter(args[1]) : new OutputStreamWriter(System.out);
            NetParser parser = new NetParser(r);
            while (true) {
                Net net;
                if ((net = parser.parseNet()) == null) {
                    return;
                }
                PeriodicGraph G = net.canonical();
                Ladder ladder = new Ladder(G);
                Output.writePGR(w, G, net.getName());
                ((Writer)w).write(10);
                w.write(String.valueOf(ladder.getRungPartition()));
                ((Writer)w).write(10);
                w.write(String.valueOf(ladder.getStileMaps()));
                w.write("\n\n");
                ((Writer)w).flush();
            }
        }
        catch (IOException ex) {
            System.err.print(ex);
            System.exit(1);
            return;
        }
    }
}

