/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import junit.framework.TestCase;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.generators.TileKTransitive;

public class TestTileKTransitive
extends TestCase {
    public void testTetra2() {
        this.doTest(new DSymbol("1:1,1,1:3,3"), 2, 100, false);
    }

    public void doTest(DSymbol ds, int k, int limit, boolean print) {
        DSymbol minimal = new DSymbol(ds.minimal());
        IndexList idcs = new IndexList(0, 1, 2);
        TileKTransitive iter = new TileKTransitive(ds, 2, false);
        int count = 0;
        while (iter.hasNext()) {
            DSymbol out = (DSymbol)iter.next();
            TestTileKTransitive.assertTrue((boolean)out.isConnected());
            int countTiles = 0;
            IteratorAdapter reps = out.orbitReps(idcs);
            while (reps.hasNext()) {
                ++countTiles;
                TestTileKTransitive.assertEquals((Object)minimal, new Subsymbol<Integer>(out, idcs, (Integer)reps.next()).minimal());
            }
            TestTileKTransitive.assertEquals((int)k, (int)countTiles);
            if (print) {
                System.out.println(out);
            }
            if (limit > 0 && ++count > limit) break;
        }
    }
}

