/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.joss.algorithms.ResumableGenerator;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.generators.CombineTiles;
import org.gavrog.joss.dsyms.generators.TileKTransitive;
import org.gavrog.joss.dsyms.generators.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrankKasperExtended
extends TileKTransitive {
    private static final Set<String> interesting_stabilizers = new HashSet<String>();
    private static final Set<String> allowed_stabilizer_sets = new HashSet<String>();
    private final boolean testParts;
    private boolean testVertexFigures = false;
    private final Stopwatch vertexFigureTestingTimer = new Stopwatch();
    private final Stopwatch extraDeductionsTimer = new Stopwatch();
    private final Stopwatch cutsFindingTimer = new Stopwatch();

    static {
        interesting_stabilizers.addAll(Arrays.asList("*332", "2*2", "222", "2x", "332"));
        allowed_stabilizer_sets.addAll(Arrays.asList("", "*332", "*332/*332", "*332/*332/*332", "*332/*332/*332/*332", "*332/*332/2*2", "*332/*332/2*2/2*2", "*332/2*2", "*332/2*2/2*2", "*332/2*2/222", "*332/2*2/2x", "*332/222", "*332/2x", "2*2", "2*2/2*2", "2*2/2*2/2*2", "2*2/2*2/2*2/2*2", "2*2/2*2/2*2/2*2/222", "2*2/2*2/2*2/2*2/222/222", "2*2/2*2/2*2/222", "2*2/2*2/2*2/222/222", "2*2/2*2/222", "2*2/2*2/222/222", "2*2/2*2/222/2x", "2*2/2*2/2x", "2*2/222", "2*2/222/222", "2*2/222/2x", "2*2/2x", "222", "222/222", "222/222/222", "222/222/222/222", "222/222/222/222/222", "222/222/222/222/222/222", "222/222/222/222/222/222/222", "222/222/222/222/222/222/222/222", "222/222/222/222/2x", "222/222/222/222/2x/2x", "222/222/222/2x", "222/222/222/2x/2x", "222/222/222/332", "222/222/2x", "222/222/2x/2x", "222/222/332", "222/222/332/332", "222/2x", "222/2x/2x", "222/2x/2x/332", "222/2x/332", "222/332", "222/332/332", "2x", "2x/2x", "2x/2x/2x", "2x/2x/2x/2x", "2x/2x/332", "2x/2x/332/332", "2x/332", "2x/332/332", "332", "332/332", "332/332/332", "332/332/332/332"));
    }

    public FrankKasperExtended(int k, boolean verbose, boolean testParts) {
        super(new DSymbol("1:1,1,1:3,3"), k, verbose);
        this.testParts = testParts;
    }

    @Override
    protected boolean partsListOkay(List<DSymbol> parts) {
        if (!this.testParts) {
            return true;
        }
        ArrayList<String> stabs = new ArrayList<String>();
        for (DSymbol part : parts) {
            String type = FrankKasperExtended.guessOrbifoldSymbol(part);
            if (!interesting_stabilizers.contains(type)) continue;
            stabs.add(type);
        }
        Collections.sort(stabs);
        StringBuffer buf = new StringBuffer(100);
        for (String type : stabs) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(type);
        }
        return allowed_stabilizer_sets.contains(buf.toString());
    }

    private static String guessOrbifoldSymbol(DSymbol ds) {
        switch (ds.size()) {
            case 1: {
                return "*332";
            }
            case 2: {
                return "332";
            }
            case 3: {
                return "2*2";
            }
            case 4: {
                return "*33";
            }
            case 6: {
                if (ds.isOriented()) {
                    return "222";
                }
                if (ds.isLoopless()) {
                    return "2x";
                }
                return "*22";
            }
            case 8: {
                return "33";
            }
            case 12: {
                if (ds.isOriented()) {
                    return "22";
                }
                return "1*";
            }
            case 24: {
                return "1";
            }
        }
        return null;
    }

    @Override
    protected Iterator<DSymbol> defineBranching(DSymbol ds) {
        final DynamicDSymbol out = new DynamicDSymbol(new DSymbol(ds));
        IndexList idx = new IndexList(0, 2, 3);
        final LinkedList<Integer> choices = new LinkedList<Integer>();
        Iterator iterator = out.orbitReps(idx).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            int D0 = out.op(0, D);
            int r = out.r(2, 3, D);
            if (r == 4 || r == 5) {
                out.redefineV(2, 3, D, 1);
                out.redefineV(2, 3, D0, 1);
                continue;
            }
            if (r == 3 || r == 6) {
                out.redefineV(2, 3, D, 6 / r);
                out.redefineV(2, 3, D0, 6 / r);
                continue;
            }
            if (r == 1 || r == 2) {
                choices.add(D);
                continue;
            }
            throw new RuntimeException("this should not happen: r = " + r + " at D = " + D);
        }
        return new IteratorAdapter<DSymbol>(){
            final int n;
            final Set<DSymbol> seen;
            int[] a;
            {
                this.n = list.size();
                this.seen = new HashSet<DSymbol>();
                this.a = null;
            }

            @Override
            protected DSymbol findNext() throws NoSuchElementException {
                DSymbol res;
                do {
                    int i;
                    if (this.a == null) {
                        this.a = new int[this.n + 1];
                        i = 0;
                        while (i < this.n) {
                            this.choose(i, 4);
                            ++i;
                        }
                    } else {
                        i = this.n - 1;
                        while (i >= 0 && this.a[i] == 6) {
                            --i;
                        }
                        if (i < 0) {
                            throw new NoSuchElementException("at end");
                        }
                        this.choose(i, 6);
                        while (i < this.n - 1) {
                            this.choose(++i, 4);
                        }
                    }
                } while (!(res = new DSymbol(out)).isLocallyEuclidean3D() || this.seen.contains(res));
                this.seen.add(res);
                return res;
            }

            private void choose(int i, int m) {
                int D = (Integer)choices.get(i);
                int D0 = out.op(0, D);
                int r = out.r(2, 3, D);
                out.redefineV(2, 3, D, m / r);
                out.redefineV(2, 3, D0, m / r);
                this.a[i] = m;
            }
        };
    }

    private boolean isComplete(DelaneySymbol<Integer> ds) {
        for (int D : ds.elements()) {
            if (ds.definesOp(3, D)) continue;
            return false;
        }
        for (int D : ds.elements()) {
            if (ds.op(1, ds.op(3, D)).equals(ds.op(3, ds.op(1, D)))) continue;
            return false;
        }
        return true;
    }

    protected boolean vertexFigureOkay(DSymbol ds) {
        return Utils.mayBecomeLocallyEuclidean3D(ds);
    }

    @Override
    protected ResumableGenerator<DSymbol> extendTo3d(DSymbol ds) {
        final IndexList idcs = new IndexList(1, 2, 3);
        return new CombineTiles(ds){

            @Override
            protected List<CombineTiles.Move> getExtraDeductions(DelaneySymbol<Integer> ds, CombineTiles.Move move) {
                int D;
                FrankKasperExtended.this.extraDeductionsTimer.start();
                ArrayList<CombineTiles.Move> out = new ArrayList<CombineTiles.Move>();
                int E = D = move.element;
                int r = 0;
                FrankKasperExtended.this.cutsFindingTimer.start();
                ArrayList<Integer> cuts = new ArrayList<Integer>();
                do {
                    if (ds.definesOp(3, E = ds.op(2, E).intValue())) {
                        E = ds.op(3, E);
                    } else {
                        cuts.add(E);
                    }
                    ++r;
                } while (E != D);
                FrankKasperExtended.this.cutsFindingTimer.stop();
                switch (cuts.size()) {
                    case 0: {
                        if (r > 6) {
                            out = null;
                            break;
                        }
                        if (!FrankKasperExtended.this.testVertexFigures) break;
                        FrankKasperExtended.this.vertexFigureTestingTimer.start();
                        Subsymbol<Integer> sub = new Subsymbol<Integer>(ds, idcs, D);
                        boolean bad = FrankKasperExtended.this.isComplete(sub) && !FrankKasperExtended.this.vertexFigureOkay(new DSymbol(sub));
                        FrankKasperExtended.this.vertexFigureTestingTimer.stop();
                        if (!bad) break;
                        out = null;
                        break;
                    }
                    case 1: {
                        if (r > 6) {
                            out = null;
                            break;
                        }
                        if (r != 6) break;
                        int A = (Integer)cuts.get(0);
                        out.add(new CombineTiles.Move(this, A, A, -1, -1, false, 0));
                        break;
                    }
                    case 2: {
                        if (r > 12) {
                            out = null;
                            break;
                        }
                        if (r != 12) break;
                        int A = (Integer)cuts.get(0);
                        int B = (Integer)cuts.get(1);
                        out.add(new CombineTiles.Move(this, A, B, -1, -1, false, 0));
                        break;
                    }
                    default: {
                        throw new RuntimeException("this should not happen");
                    }
                }
                FrankKasperExtended.this.extraDeductionsTimer.stop();
                return out;
            }
        };
    }

    public boolean getTestVertexFigures() {
        return this.testVertexFigures;
    }

    public void setTestVertexFigures(boolean extraTests) {
        this.testVertexFigures = extraTests;
    }

    public String getTimeForVertexFigureTests() {
        return this.vertexFigureTestingTimer.format();
    }

    public String getTimeForComputingDeductions() {
        return this.extraDeductionsTimer.format();
    }

    public String getTimeForFindingCuts() {
        return this.cutsFindingTimer.format();
    }
}

