/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import buoy.event.EventProcessor;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.joss.algorithms.CheckpointEvent;
import org.gavrog.joss.algorithms.ResumableGenerator;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.generators.CombineTiles;
import org.gavrog.joss.dsyms.generators.TileKTransitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrankKasper
extends TileKTransitive {
    public FrankKasper(int k, boolean verbose) {
        super(new DSymbol("1:1,1,1:3,3"), k, verbose);
    }

    @Override
    protected Iterator<DSymbol> defineBranching(DSymbol ds) {
        DynamicDSymbol out = new DynamicDSymbol(new DSymbol(ds));
        IndexList idx = new IndexList(2, 3);
        Iterator iterator = out.orbitReps(idx).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            int r = out.r(2, 3, D);
            if (r == 5) {
                out.redefineV(2, 3, D, 1);
                continue;
            }
            if (r > 0 && 6 % r == 0) {
                out.redefineV(2, 3, D, 6 / r);
                continue;
            }
            throw new RuntimeException("this should not happen: r = " + r + " at D = " + D);
        }
        if (out.isLocallyEuclidean3D()) {
            return Iterators.singleton(new DSymbol(out));
        }
        return Iterators.empty();
    }

    @Override
    protected ResumableGenerator<DSymbol> extendTo3d(DSymbol ds) {
        return new CombineTiles(ds){

            @Override
            protected List<CombineTiles.Move> getExtraDeductions(DelaneySymbol<Integer> ds, CombineTiles.Move move) {
                int D;
                ArrayList<CombineTiles.Move> out = new ArrayList<CombineTiles.Move>();
                int E = D = move.element;
                int r = 0;
                ArrayList<Integer> cuts = new ArrayList<Integer>();
                do {
                    if (ds.definesOp(3, E = ds.op(2, E).intValue())) {
                        E = ds.op(3, E);
                    } else {
                        cuts.add(E);
                    }
                    ++r;
                } while (E != D);
                switch (cuts.size()) {
                    case 0: {
                        if (r != 4 && r <= 6) break;
                        return null;
                    }
                    case 1: {
                        if (r > 6) {
                            return null;
                        }
                        if (r != 6) break;
                        int A = (Integer)cuts.get(0);
                        out.add(new CombineTiles.Move(this, A, A, -1, -1, false, 0));
                        break;
                    }
                    case 2: {
                        if (r > 12) {
                            return null;
                        }
                        if (r != 12) break;
                        int A = (Integer)cuts.get(0);
                        int B = (Integer)cuts.get(1);
                        out.add(new CombineTiles.Move(this, A, B, -1, -1, false, 0));
                        break;
                    }
                    default: {
                        throw new RuntimeException("this should not happen");
                    }
                }
                return out;
            }
        };
    }

    public static void usage() {
        System.err.print("Usage: java [PATH] [OPTION]... k [FILE]\n\nwhere  PATH = org.gavrog.joss.dsyms.generators.FrankKasper\n  k:     number of tile orbits in each generated tiling\nRecognized options:\n  -e        skip euclidicity test\n  -i N      interval in seconds between writing checkpoints\n  -r A-B-C  resume generation at a checkpoint\n  -v        run in verbose mode\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            boolean verbose = false;
            boolean check = true;
            int checkpointInterval = 3600;
            String resume = null;
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                if (args[i].equals("-v")) {
                    verbose = !verbose;
                } else if (args[i].equals("-e")) {
                    check = !check;
                } else if (args[i].equals("-i")) {
                    checkpointInterval = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-r")) {
                    resume = args[++i];
                } else {
                    FrankKasper.usage();
                }
                ++i;
            }
            if (args.length <= i) {
                FrankKasper.usage();
            }
            int k = Integer.parseInt(args[i]);
            final OutputStreamWriter output = args.length > i + 1 ? new FileWriter(args[i + 1]) : new OutputStreamWriter(System.out);
            int countGood = 0;
            int countAmbiguous = 0;
            Stopwatch timer = new Stopwatch();
            Stopwatch eTestTimer = new Stopwatch();
            timer.start();
            output.write("# Program FrankKasper with k = " + k + ".\n");
            output.write("# Options:\n");
            output.write("#     verbose mode:                    ");
            output.write(String.valueOf(verbose ? "on" : "off") + "\n");
            output.write("#     euclidicity test:                ");
            output.write(String.valueOf(check ? "on" : "off") + "\n");
            output.write("#     checkpoint interval:             ");
            output.write(String.valueOf(checkpointInterval) + "sec\n");
            if (resume != null) {
                output.write(String.format("# Resuming at %s.\n", resume));
            }
            output.write("\n");
            ((Writer)output).flush();
            FrankKasper iter = new FrankKasper(k, verbose);
            final Stopwatch chkptTimer = new Stopwatch();
            final int interval = 1000 * checkpointInterval;
            iter.addEventLink(CheckpointEvent.class, new EventProcessor(){

                public void handleEvent(Object event) {
                    if (((CheckpointEvent)event).getMessage() != null || chkptTimer.elapsed() > (long)interval) {
                        chkptTimer.reset();
                        try {
                            output.write(event + "\n");
                            output.flush();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            });
            chkptTimer.start();
            if (resume != null) {
                iter.setResumePoint(resume);
            }
            for (DSymbol ds : iter) {
                DSymbol out = ds.dual();
                if (check) {
                    eTestTimer.start();
                    EuclidicityTester tester = new EuclidicityTester(out);
                    boolean bad = tester.isBad();
                    boolean ambiguous = tester.isAmbiguous();
                    eTestTimer.stop();
                    if (!bad) {
                        if (ambiguous) {
                            output.write("#@ name euclidicity dubious\n");
                            ++countAmbiguous;
                        }
                        output.write(out + "\n");
                        ++countGood;
                    }
                } else {
                    output.write(out + "\n");
                }
                ((Writer)output).flush();
            }
            timer.stop();
            output.write("\n");
            output.write("# Total execution time in user mode was " + timer.format() + ".\n");
            if (check) {
                output.write("# Time for euclidicity tests was " + eTestTimer.format() + ".\n");
            }
            output.write("\n");
            output.write("# " + iter.statistics() + "\n");
            if (check) {
                output.write("# Of those, " + countGood + " were found euclidean.\n");
                if (countAmbiguous > 0) {
                    output.write("# For " + countAmbiguous + " symbols, euclidicity remains undetermined.\n");
                }
            }
            ((Writer)output).flush();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

