/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.generators.CombineTiles;
import org.gavrog.joss.dsyms.generators.DefineBranching2d;
import org.gavrog.joss.dsyms.generators.DefineBranching3d;
import org.gavrog.joss.dsyms.generators.Faces;
import org.gavrog.joss.dsyms.generators.SplitEdges2d;
import org.gavrog.joss.dsyms.generators.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceTransitive
extends IteratorAdapter<DSymbol> {
    private static final boolean TEST = false;
    private static final IndexList idcsFace2d = new IndexList(0, 1);
    private static final IndexList idcsVert2d = new IndexList(1, 2);
    private static final IndexList idcsFace3d = new IndexList(0, 1, 3);
    private static final IndexList idcsVert3d = new IndexList(1, 2, 3);
    private static final Map<NiftyList<Integer>, List<DSymbol>> singleBases = new HashMap<NiftyList<Integer>, List<DSymbol>>();
    private static final Map<NiftyList<Integer>, List<DSymbol>> doubleBases = new HashMap<NiftyList<Integer>, List<DSymbol>>();
    private final int maxSize;
    private final int minVert;
    private int size;
    private int type;
    private Iterator<DSymbol> faces = Iterators.empty();
    private Iterator<DSymbol> preTilings = Iterators.empty();
    private Iterator<DSymbol> tilings = Iterators.empty();
    private int badVertices = 0;
    private int nonMinimal = 0;
    private int badInvariant = 0;
    private int nonEuclidean = 0;
    private int countSingleFaced = 0;
    private int countDoubleFaced = 0;
    private int countBaseSingleFaced = 0;
    private int countBaseDoubleFaced = 0;
    private int countONE = 0;
    private int countTWO = 0;
    private int countDOUBLE = 0;
    private Stopwatch time4invar = new Stopwatch();
    private Stopwatch time4euclid = new Stopwatch();
    private Stopwatch time4One = new Stopwatch();
    private Stopwatch time4Two = new Stopwatch();
    private Stopwatch time4Double = new Stopwatch();
    private Stopwatch time4SingleFaced = new Stopwatch();
    private Stopwatch time4DoubleFaced = new Stopwatch();
    private Stopwatch time4BaseSingleFaced = new Stopwatch();
    private Stopwatch time4BaseDoubleFaced = new Stopwatch();
    private Stopwatch time4Final = new Stopwatch();

    static final DSymbol baseTile(DSymbol tile) {
        DynamicDSymbol ds = new DynamicDSymbol(tile);
        List reps = Iterators.asList(ds.orbitReps(idcsVert2d));
        Iterator iterator = reps.iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            if (ds.m(1, 2, D) != 2) continue;
            ds.redefineV(1, 2, D, 1);
            ds.collapse(Iterators.asList(ds.orbit(idcsVert2d, D)), 1);
        }
        return new DSymbol(ds);
    }

    public FaceTransitive(int minSize, int maxSize, int minVertexDegree) {
        this.maxSize = minVertexDegree >= 3 && (maxSize > 20 || maxSize < 1) ? 20 : maxSize;
        this.minVert = minVertexDegree;
        this.size = minSize - 1;
        this.type = 3;
    }

    @Override
    protected DSymbol findNext() throws NoSuchElementException {
        while (true) {
            DSymbol ds;
            if (this.moreTilings()) {
                this.time4Final.start();
                ds = this.tilings.next();
                this.time4Final.stop();
                if (!this.isGood(ds)) continue;
                return ds;
            }
            if (this.morePreTilings()) {
                this.startCaseTimer();
                ds = this.preTilings.next();
                this.stopCaseTimer();
                if (ds.numberOfOrbits(idcsFace3d) != 1 || this.hasTrivialVertices(ds)) continue;
                switch (this.type) {
                    case 0: {
                        ++this.countONE;
                        break;
                    }
                    case 1: {
                        ++this.countTWO;
                        break;
                    }
                    case 2: {
                        ++this.countDOUBLE;
                    }
                }
                this.time4Final.start();
                this.tilings = new DefineBranching3d(ds);
                this.time4Final.stop();
                continue;
            }
            if (this.faces.hasNext()) {
                DSymbol face = this.faces.next();
                switch (this.type) {
                    case 0: {
                        this.preTilings = new ONE(face, this.minVert);
                        break;
                    }
                    case 1: {
                        this.preTilings = new TWO(face, this.minVert);
                        break;
                    }
                    case 2: {
                        this.preTilings = new DOUBLE(face, this.minVert);
                    }
                }
                continue;
            }
            if (this.type < 2 && this.size % 2 == 0 || this.type < 0) {
                ++this.type;
                if (this.type == 0) {
                    this.faces = new Faces(this.size, 3, 4);
                    continue;
                }
                this.faces = new Faces(this.size / 2, 3, 4);
                continue;
            }
            if (this.maxSize >= 1 && this.size >= this.maxSize) break;
            ++this.size;
            this.type = -1;
        }
        throw new NoSuchElementException("at end");
    }

    private boolean moreTilings() {
        this.time4Final.start();
        boolean moreTilings = this.tilings.hasNext();
        this.time4Final.stop();
        return moreTilings;
    }

    private void startCaseTimer() {
        switch (this.type) {
            case 0: {
                this.time4One.start();
                break;
            }
            case 1: {
                this.time4Two.start();
                break;
            }
            case 2: {
                this.time4Double.start();
            }
        }
    }

    private void stopCaseTimer() {
        switch (this.type) {
            case 0: {
                this.time4One.stop();
                break;
            }
            case 1: {
                this.time4Two.stop();
                break;
            }
            case 2: {
                this.time4Double.stop();
            }
        }
    }

    private boolean morePreTilings() {
        this.startCaseTimer();
        boolean more = this.preTilings.hasNext();
        this.stopCaseTimer();
        return more;
    }

    private static List<DSymbol> baseFaces(DSymbol face) {
        LinkedList<DSymbol> results = new LinkedList<DSymbol>();
        int v = face.v(0, 1, face.elements().next());
        boolean loopless = face.isLoopless();
        int d = v * (loopless ? 1 : 2);
        int n = 4;
        while (n <= face.size() * d) {
            int size;
            if (n % d == 0 && (size = n / d) <= face.size()) {
                for (DSymbol ds : new Faces(size, 2, 4)) {
                    if (ds.v(0, 1, ds.elements().next()) != v || ds.isLoopless() != loopless) continue;
                    results.add(ds);
                }
            }
            n += 2;
        }
        return results;
    }

    private static int minVert(DSymbol tile) {
        int min = Integer.MAX_VALUE;
        Iterator iterator = tile.orbitReps(idcsVert2d).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            min = Math.min(min, tile.m(1, 2, D));
        }
        return min;
    }

    private boolean hasTrivialVertices(DSymbol ds) {
        Iterator iterator = ds.orbitReps(idcsVert3d).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            boolean bad = true;
            for (int E : ds.orbit(idcsVert3d, D)) {
                if (ds.m(1, 2, E) <= 2) continue;
                bad = false;
                break;
            }
            if (!bad) continue;
            ++this.badVertices;
            return true;
        }
        return false;
    }

    private boolean isGood(DSymbol ds) {
        if (!ds.isMinimal()) {
            ++this.nonMinimal;
            return false;
        }
        this.time4invar.start();
        boolean ok = EuclidicityTester.invariantOkay(ds);
        this.time4invar.stop();
        if (!ok) {
            ++this.badInvariant;
            return false;
        }
        this.time4euclid.start();
        boolean bad = new EuclidicityTester(ds).isBad();
        this.time4euclid.stop();
        if (bad) {
            ++this.nonEuclidean;
            return false;
        }
        return true;
    }

    public int getBadVertices() {
        return this.badVertices;
    }

    public int getBadInvariant() {
        return this.badInvariant;
    }

    public int getNonEuclidean() {
        return this.nonEuclidean;
    }

    public int getNonMinimal() {
        return this.nonMinimal;
    }

    public int getCountSingleFaced() {
        return this.countSingleFaced;
    }

    public int getCountDoubleFaced() {
        return this.countDoubleFaced;
    }

    public int getCountBaseDoubleFaced() {
        return this.countBaseDoubleFaced;
    }

    public int getCountBaseSingleFaced() {
        return this.countBaseSingleFaced;
    }

    public int getCountONE() {
        return this.countONE;
    }

    public int getCountTWO() {
        return this.countTWO;
    }

    public int getCountDOUBLE() {
        return this.countDOUBLE;
    }

    public String timeForInvariantTest() {
        return this.time4invar.format();
    }

    public String timeForEuclidicityTest() {
        return this.time4euclid.format();
    }

    public String timeForCaseOne() {
        return this.time4One.format();
    }

    public String timeForCaseTwo() {
        return this.time4Two.format();
    }

    public String timeForCaseDouble() {
        return this.time4Double.format();
    }

    public String timeForSingleFacedTiles() {
        return this.time4SingleFaced.format();
    }

    public String timeForDoubleFacedTiles() {
        return this.time4DoubleFaced.format();
    }

    public String timeForBaseSingleFacedTiles() {
        return this.time4BaseSingleFaced.format();
    }

    public String timeForBaseDoubleFacedTiles() {
        return this.time4BaseDoubleFaced.format();
    }

    public String timeForFinalBranching() {
        return this.time4Final.format();
    }

    public static void main(String[] args) {
        int n = args.length;
        int minSize = n > 0 ? Integer.parseInt(args[0]) : 1;
        int maxSize = n > 1 ? Integer.parseInt(args[1]) : 8;
        int minVert = n > 2 ? Integer.parseInt(args[2]) : 2;
        System.out.println("# Generated by Gavrog on " + Calendar.getInstance().getTime());
        System.out.println("#");
        System.out.println("# Class: FaceTransitive");
        System.out.print("# Command line arguments:");
        int i = 0;
        while (i < n) {
            System.out.print(" " + args[i]);
            ++i;
        }
        System.out.println();
        System.out.println("#");
        System.out.println("# Running Java " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
        System.out.println("#");
        Stopwatch total = new Stopwatch();
        total.start();
        FaceTransitive symbols = new FaceTransitive(minSize, maxSize, minVert);
        int count = Iterators.print(System.out, symbols, "\n");
        total.stop();
        System.out.println();
        System.out.println("#");
        System.out.println("# Generated " + count + " symbols.");
        System.out.println("# Rejected " + symbols.getBadVertices() + " symbols with trivial vertices,");
        System.out.println("#          " + symbols.getNonMinimal() + " non-minimal symbols,");
        System.out.println("#          " + symbols.getBadInvariant() + " symbols with non-Euclidean orbifold invariants and");
        System.out.println("#          " + symbols.getNonEuclidean() + " further non-Euclidean symbols");
        System.out.println("# Execution time was " + total.format() + ".");
        System.out.println("#     Used " + symbols.timeForInvariantTest() + " for invariant tests.");
        System.out.println("#     Used " + symbols.timeForEuclidicityTest() + " for other Euclidicity tests.");
        System.out.println("#");
        System.out.println("#     Used " + symbols.timeForCaseOne() + " for case ONE producing " + symbols.getCountONE() + " Delaney sets.");
        System.out.println("#     Used " + symbols.timeForCaseTwo() + " for case TWO producing " + symbols.getCountTWO() + " Delaney sets.");
        System.out.println("#     Used " + symbols.timeForCaseDouble() + " for case DOUBLE producing " + symbols.getCountDOUBLE() + " Delaney sets.");
        System.out.println("#");
        System.out.println("#     Used " + symbols.timeForBaseSingleFacedTiles() + " to generate " + symbols.getCountBaseSingleFaced() + " single-faced base tiles.");
        System.out.println("#     Used " + symbols.timeForBaseDoubleFacedTiles() + " to generate " + symbols.getCountBaseDoubleFaced() + " double-faced base tiles.");
        System.out.println("#     Used " + symbols.timeForSingleFacedTiles() + " to generate " + symbols.getCountSingleFaced() + " single-faced tiles.");
        System.out.println("#     Used " + symbols.timeForDoubleFacedTiles() + " to generate " + symbols.getCountDoubleFaced() + " double-faced tiles.");
        System.out.println("#");
        System.out.println("#     Used " + symbols.timeForFinalBranching() + " to generate final branching.");
        System.out.println("#");
        System.out.println("# Program finished on " + Calendar.getInstance().getTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseDoubleFaceTiles
    extends IteratorAdapter<DSymbol> {
        private final int minVert;
        private final Rational minCurv = new Fraction(1L, 12L);
        Iterator<DSymbol> preTiles = Iterators.empty();
        Iterator<DSymbol> tiles = Iterators.empty();

        public BaseDoubleFaceTiles(DSymbol ds, int minVert) {
            FaceTransitive.this.time4BaseDoubleFaced.start();
            this.minVert = minVert;
            boolean good = false;
            Iterator iterator = ds.orbitReps(idcsFace2d).iterator();
            while (iterator.hasNext()) {
                int D = (Integer)iterator.next();
                if (ds.m(0, 1, D) > 5) continue;
                good = true;
            }
            this.preTiles = good ? new CombineTiles(ds) : Iterators.empty();
            FaceTransitive.this.time4BaseDoubleFaced.stop();
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            FaceTransitive.this.time4BaseDoubleFaced.start();
            block0: while (true) {
                DSymbol ds;
                if (this.tiles.hasNext()) {
                    int D;
                    ds = this.tiles.next();
                    if (!ds.isSpherical2D()) continue;
                    Iterator<Integer> iterator = ds.elements().iterator();
                    do {
                        if (!iterator.hasNext()) continue block0;
                    } while (ds.m(1, 2, D = iterator.next().intValue()) <= 2);
                    FaceTransitive.this.time4BaseDoubleFaced.stop();
                    FaceTransitive faceTransitive = FaceTransitive.this;
                    faceTransitive.countBaseDoubleFaced = faceTransitive.countBaseDoubleFaced + 1;
                    return ds;
                }
                if (!this.preTiles.hasNext()) break;
                ds = this.preTiles.next();
                this.tiles = new DefineBranching2d(ds, 2, this.minVert, this.minCurv);
            }
            FaceTransitive.this.time4BaseDoubleFaced.stop();
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseSingleFaceTiles
    extends IteratorAdapter<DSymbol> {
        private final Rational minCurv = new Fraction(1L, 12L);
        private final int minVert;
        Iterator<DSymbol> preTiles = Iterators.empty();
        Iterator<DSymbol> tiles = Iterators.empty();

        public BaseSingleFaceTiles(DSymbol face, int minVert) {
            FaceTransitive.this.time4BaseSingleFaced.start();
            this.minVert = minVert;
            this.preTiles = minVert >= 3 && face.m(0, 1, face.elements().next()) > 5 ? Iterators.empty() : new CombineTiles(face);
            FaceTransitive.this.time4BaseSingleFaced.stop();
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            FaceTransitive.this.time4BaseSingleFaced.start();
            block0: while (true) {
                DSymbol ds;
                if (this.tiles.hasNext()) {
                    int D;
                    ds = this.tiles.next();
                    if (!ds.isSpherical2D()) continue;
                    Iterator<Integer> iterator = ds.elements().iterator();
                    do {
                        if (!iterator.hasNext()) continue block0;
                    } while (ds.m(1, 2, D = iterator.next().intValue()) <= 2);
                    FaceTransitive.this.time4BaseSingleFaced.stop();
                    FaceTransitive faceTransitive = FaceTransitive.this;
                    faceTransitive.countBaseSingleFaced = faceTransitive.countBaseSingleFaced + 1;
                    return ds;
                }
                if (!this.preTiles.hasNext()) break;
                ds = this.preTiles.next();
                this.tiles = new DefineBranching2d(ds, 2, this.minVert, this.minCurv);
            }
            FaceTransitive.this.time4BaseSingleFaced.stop();
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DOUBLE
    extends IteratorAdapter<DSymbol> {
        Iterator<DSymbol> tiles = Iterators.empty();
        Iterator<DSymbol> tilings = Iterators.empty();
        final Set<DSymbol> testTiles = null;

        public DOUBLE(DSymbol face, int minVert) {
            this.tiles = new DoubleFaceTiles(face, minVert);
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            while (true) {
                if (this.tilings.hasNext()) {
                    return this.tilings.next();
                }
                if (!this.tiles.hasNext()) break;
                DSymbol ds = this.tiles.next();
                this.tilings = new Glue(ds);
            }
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoubleFaceTiles
    extends IteratorAdapter<DSymbol> {
        private final DSymbol inputFace;
        private final int minVert;
        private final int targetSize;
        private final Iterator<Pair<DSymbol, DSymbol>> baseFacePairs;
        private Iterator<DSymbol> baseTiles;
        private Iterator<DSymbol> augmented;

        public DoubleFaceTiles(DSymbol face, int minVert) {
            FaceTransitive.this.time4DoubleFaced.start();
            this.inputFace = face;
            this.minVert = minVert;
            this.targetSize = 2 * face.size();
            if (minVert >= 3) {
                this.baseFacePairs = Iterators.singleton(new Pair<DSymbol, DSymbol>(face, face));
            } else {
                DSymbol[] a = new DSymbol[FaceTransitive.baseFaces(face).size()];
                IteratorAdapter<List<DSymbol>> pairs = Iterators.selections(FaceTransitive.baseFaces(face).toArray(a), 2);
                this.baseFacePairs = new FilteredIterator<Pair<DSymbol, DSymbol>, List<DSymbol>>(pairs){

                    @Override
                    public Pair<DSymbol, DSymbol> filter(List<DSymbol> item) {
                        return new Pair<DSymbol, DSymbol>(item.get(0), item.get(1));
                    }
                };
            }
            this.baseTiles = Iterators.empty();
            this.augmented = Iterators.empty();
            FaceTransitive.this.time4DoubleFaced.stop();
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            FaceTransitive.this.time4DoubleFaced.start();
            while (true) {
                if (this.augmented.hasNext()) {
                    DSymbol ds = this.augmented.next();
                    boolean okay = true;
                    Iterator iterator = ds.orbitReps(idcsFace2d).iterator();
                    while (iterator.hasNext()) {
                        int D = (Integer)iterator.next();
                        DSymbol face = new DSymbol(new Subsymbol<Integer>(ds, idcsFace2d, D));
                        if (face.equals(this.inputFace)) continue;
                        okay = false;
                        break;
                    }
                    if (!okay) continue;
                    FaceTransitive.this.time4DoubleFaced.stop();
                    FaceTransitive faceTransitive = FaceTransitive.this;
                    faceTransitive.countDoubleFaced = faceTransitive.countDoubleFaced + 1;
                    return ds;
                }
                if (this.baseTiles.hasNext()) {
                    DSymbol tile = this.baseTiles.next();
                    if (this.minVert >= 3) {
                        if (this.minVert > FaceTransitive.minVert(tile)) continue;
                        return tile;
                    }
                    this.augmented = new SplitEdges2d(tile, this.targetSize);
                    continue;
                }
                if (!this.baseFacePairs.hasNext()) break;
                Pair<DSymbol, DSymbol> item = this.baseFacePairs.next();
                DSymbol f1 = item.getFirst();
                DSymbol f2 = item.getSecond();
                DynamicDSymbol tmp = new DynamicDSymbol(f1);
                tmp.append(f2);
                DSymbol ds = new DSymbol(tmp);
                NiftyList<Integer> invariant = ds.invariant();
                if (!doubleBases.containsKey(invariant)) {
                    BaseDoubleFaceTiles tiles = new BaseDoubleFaceTiles(ds, 3);
                    doubleBases.put(invariant, Iterators.asList(tiles));
                }
                this.baseTiles = ((List)doubleBases.get(invariant)).iterator();
            }
            FaceTransitive.this.time4DoubleFaced.stop();
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Glue
    extends IteratorAdapter<DSymbol> {
        final DSymbol ds;
        final int D0;
        final Iterator<Integer> targets;
        final Set<DSymbol> seen = new HashSet<DSymbol>();

        public Glue(DSymbol ds) {
            int targetRep;
            this.ds = ds;
            IteratorAdapter reps = ds.orbitReps(idcsFace2d);
            int firstRep = (Integer)reps.next();
            int n = targetRep = reps.hasNext() ? (Integer)reps.next() : firstRep;
            if (ds.orbitIsLoopless(idcsFace2d, firstRep)) {
                this.D0 = firstRep;
                this.targets = ds.orbit(idcsFace2d, targetRep);
            } else {
                ArrayList<Integer> loops0 = new ArrayList<Integer>();
                ArrayList<Integer> loops1 = new ArrayList<Integer>();
                for (int D : ds.orbit(idcsFace2d, firstRep)) {
                    if (D == ds.op(0, D)) {
                        loops0.add(D);
                        continue;
                    }
                    if (D != ds.op(1, D)) continue;
                    loops1.add(D);
                }
                int type = loops0.size();
                this.D0 = type > 0 ? ((Integer)loops0.get(0)).intValue() : ((Integer)loops1.get(0)).intValue();
                loops0.clear();
                loops1.clear();
                for (int D : ds.orbit(idcsFace2d, targetRep)) {
                    if (D == ds.op(0, D)) {
                        loops0.add(D);
                        continue;
                    }
                    if (D != ds.op(1, D)) continue;
                    loops1.add(D);
                }
                this.targets = type > 0 ? loops0.iterator() : loops1.iterator();
            }
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            while (this.targets.hasNext()) {
                DSymbol res;
                int E0 = this.targets.next();
                DynamicDSymbol tmp = new DynamicDSymbol(3);
                tmp.append(this.ds);
                int D = this.D0;
                int E = E0;
                do {
                    int k = 0;
                    while (k <= 1) {
                        tmp.redefineOp(3, D, E);
                        D = tmp.op(k, D);
                        E = tmp.op(k, E);
                        ++k;
                    }
                } while (D != this.D0);
                boolean bad = false;
                for (int elm : tmp.elements()) {
                    if (tmp.definesOp(3, elm)) continue;
                    bad = true;
                    break;
                }
                if (bad || this.seen.contains(res = new DSymbol(tmp))) continue;
                this.seen.add(res);
                if (!Utils.mayBecomeLocallyEuclidean3D(res)) continue;
                return res;
            }
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ONE
    extends IteratorAdapter<DSymbol> {
        Iterator<DSymbol> tiles = Iterators.empty();
        Iterator<DSymbol> tilings = Iterators.empty();

        public ONE(DSymbol face, int minVert) {
            this.tiles = new SingleFaceTiles(face, minVert);
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            while (true) {
                if (this.tilings.hasNext()) {
                    return this.tilings.next();
                }
                if (!this.tiles.hasNext()) break;
                DSymbol ds = this.tiles.next();
                this.tilings = new Glue(ds);
            }
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleDoubleFaceTiles
    extends IteratorAdapter<DSymbol> {
        private final int minVert;
        private final Rational minCurv = new Fraction(1L, 12L);
        Iterator<DSymbol> preTiles = Iterators.empty();
        Iterator<DSymbol> tiles = Iterators.empty();

        public SimpleDoubleFaceTiles(DSymbol face, int minVert) {
            this.minVert = minVert;
            DynamicDSymbol ds = new DynamicDSymbol(face);
            ds.append(face);
            this.preTiles = new CombineTiles(new DSymbol(ds));
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            block0: while (true) {
                DSymbol ds;
                if (this.tiles.hasNext()) {
                    int D;
                    ds = this.tiles.next();
                    if (!ds.isSpherical2D()) continue;
                    Iterator<Integer> iterator = ds.elements().iterator();
                    do {
                        if (!iterator.hasNext()) continue block0;
                    } while (ds.m(1, 2, D = iterator.next().intValue()) <= 2);
                    return ds;
                }
                if (!this.preTiles.hasNext()) break;
                ds = this.preTiles.next();
                this.tiles = new DefineBranching2d(ds, 3, this.minVert, this.minCurv);
            }
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleFaceTiles
    extends IteratorAdapter<DSymbol> {
        private final DSymbol inputFace;
        private final int minVert;
        private final int targetSize;
        private final Iterator<DSymbol> baseFaces;
        private Iterator<DSymbol> baseTiles;
        private Iterator<DSymbol> augmented;

        public SingleFaceTiles(DSymbol face, int minVert) {
            FaceTransitive.this.time4SingleFaced.start();
            this.inputFace = face;
            this.minVert = minVert;
            this.targetSize = face.size();
            this.baseFaces = minVert >= 3 ? Iterators.singleton(face) : FaceTransitive.baseFaces(face).iterator();
            this.baseTiles = Iterators.empty();
            this.augmented = Iterators.empty();
            FaceTransitive.this.time4SingleFaced.stop();
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            FaceTransitive.this.time4SingleFaced.start();
            while (true) {
                if (this.augmented.hasNext()) {
                    DSymbol ds = this.augmented.next();
                    int D = ds.elements().next();
                    DSymbol face = new DSymbol(new Subsymbol<Integer>(ds, idcsFace2d, D));
                    if (!face.equals(this.inputFace)) continue;
                    FaceTransitive.this.time4SingleFaced.stop();
                    FaceTransitive faceTransitive = FaceTransitive.this;
                    faceTransitive.countSingleFaced = faceTransitive.countSingleFaced + 1;
                    return ds;
                }
                if (this.baseTiles.hasNext()) {
                    DSymbol tile = this.baseTiles.next();
                    if (this.minVert >= 3) {
                        if (this.minVert > FaceTransitive.minVert(tile)) continue;
                        return tile;
                    }
                    this.augmented = new SplitEdges2d(tile, this.targetSize);
                    continue;
                }
                if (!this.baseFaces.hasNext()) break;
                DSymbol face = this.baseFaces.next();
                NiftyList<Integer> invariant = face.invariant();
                if (!singleBases.containsKey(invariant)) {
                    BaseSingleFaceTiles tiles = new BaseSingleFaceTiles(face, 3);
                    singleBases.put(invariant, Iterators.asList(tiles));
                }
                this.baseTiles = ((List)singleBases.get(invariant)).iterator();
            }
            FaceTransitive.this.time4SingleFaced.stop();
            throw new NoSuchElementException("at end");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TWO
    extends IteratorAdapter<DSymbol> {
        final List<DSymbol> tiles;
        int i;
        int j;
        Iterator<DSymbol> tilings = Iterators.empty();

        public TWO(DSymbol face, int minVert) {
            this.tiles = Iterators.asList(new SingleFaceTiles(face, minVert));
            this.j = 0;
            this.i = 0;
        }

        @Override
        protected DSymbol findNext() throws NoSuchElementException {
            while (true) {
                if (this.tilings.hasNext()) {
                    return this.tilings.next();
                }
                if (this.i >= this.tiles.size()) break;
                DSymbol t1 = this.tiles.get(this.i);
                DSymbol t2 = this.tiles.get(this.j);
                ++this.j;
                if (this.j >= this.tiles.size()) {
                    this.j = ++this.i;
                }
                DynamicDSymbol ds = new DynamicDSymbol(t1);
                ds.append(t2);
                this.tilings = new Glue(new DSymbol(ds));
            }
            throw new NoSuchElementException("at end");
        }
    }
}

