/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import buoy.event.EventProcessor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.List;
import org.gavrog.box.collections.Iterators;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.algorithms.BranchAndCut;
import org.gavrog.joss.algorithms.CheckpointEvent;
import org.gavrog.joss.dsyms.basic.DSMorphism;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.generators.InputIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineBranching2d
extends BranchAndCut<DSymbol> {
    private final int minFaceDeg;
    private final int minVertDeg;
    private final Rational minCurv;
    private DynamicDSymbol current;
    private List<DSMorphism<Integer, Integer>> inputAutomorphisms;

    public <T> DefineBranching2d(DelaneySymbol<T> ds, int minFaceDeg, int minVertDeg, Rational minCurv) {
        this.minFaceDeg = minFaceDeg;
        this.minVertDeg = minVertDeg;
        this.minCurv = minCurv;
        this.current = new DynamicDSymbol(new DSymbol(ds.canonical()));
        this.current.setVDefaultToOne(true);
        this.current.setVDefaultToOne(false);
        this.inputAutomorphisms = DSMorphism.automorphisms(this.current);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected BranchAndCut.Move nextChoice(BranchAndCut.Move previous) {
        ds = this.current;
        i = 0;
        D = 1;
        if (previous == null) ** GOTO lbl14
        i = ((BMove)previous).index;
        D = ((BMove)previous).element + 1;
        ** GOTO lbl14
        {
            ++D;
            do {
                if (D <= ds.size() && ds.definesV(i, i + 1, new Integer(D))) continue block0;
                if (D <= ds.size()) break block0;
                ++i;
                D = 1;
lbl14:
                // 3 sources

            } while (i < ds.dim());
        }
        if (i >= ds.dim()) {
            return null;
        }
        return new BMove(i, D, 0);
    }

    @Override
    protected BranchAndCut.Move nextDecision(BranchAndCut.Move previous) {
        int next;
        BMove move = (BMove)previous;
        int v = move.value;
        if (v < 4) {
            next = v + 1;
        } else if (v == 4) {
            next = 6;
        } else {
            return null;
        }
        return new BMove(move.index, move.element, next);
    }

    @Override
    protected BranchAndCut.Status checkMove(BranchAndCut.Move move) {
        int idx = ((BMove)move).index;
        Integer D = new Integer(((BMove)move).element);
        int val = ((BMove)move).value;
        if (idx == 0 && this.current.r(idx, idx + 1, D) * val < this.minFaceDeg) {
            return BranchAndCut.Status.ILLEGAL;
        }
        if (idx == 1 && this.current.r(idx, idx + 1, D) * val < this.minVertDeg) {
            return BranchAndCut.Status.ILLEGAL;
        }
        return BranchAndCut.Status.OK;
    }

    @Override
    protected void performMove(BranchAndCut.Move move) {
        int idx = ((BMove)move).index;
        Integer D = new Integer(((BMove)move).element);
        this.current.redefineV(idx, idx + 1, D, ((BMove)move).value);
    }

    @Override
    protected void undoMove(BranchAndCut.Move move) {
        int idx = ((BMove)move).index;
        int elm = ((BMove)move).element;
        this.current.undefineV(idx, idx + 1, new Integer(elm));
    }

    @Override
    protected List<BranchAndCut.Move> deductions(BranchAndCut.Move move) {
        return null;
    }

    @Override
    protected boolean isValid() {
        DynamicDSymbol ds = this.current;
        ds.setVDefaultToOne(true);
        Rational curv = ds.curvature2D();
        ds.setVDefaultToOne(false);
        if (curv.isLessThan(this.minCurv)) {
            return false;
        }
        for (DSMorphism<Integer, Integer> map : this.inputAutomorphisms) {
            if (DefineBranching2d.compareWithPermuted(this.current, map) <= 0) continue;
            return false;
        }
        return true;
    }

    private static int compareWithPermuted(DelaneySymbol<Integer> ds, DSMorphism<Integer, Integer> map) {
        for (int D1 : ds.elements()) {
            int D2 = map.getASource(D1);
            int i = 0;
            while (i < ds.dim()) {
                int v2;
                int v1 = ds.definesV(i, i + 1, D1) ? ds.v(i, i + 1, D1) : 0;
                int n = v2 = ds.definesV(i, i + 1, D2) ? ds.v(i, i + 1, D2) : 0;
                if (v1 != v2) {
                    if (v1 == 0) {
                        return 1;
                    }
                    if (v2 == 0) {
                        return -1;
                    }
                    return v1 - v2;
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    protected boolean isComplete() {
        DynamicDSymbol ds = this.current;
        int i = 0;
        while (i < ds.dim()) {
            int D = 1;
            while (D <= ds.size()) {
                if (!ds.definesV(i, i + 1, D)) {
                    return false;
                }
                ++D;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected DSymbol makeResult() {
        return new DSymbol(this.current);
    }

    public static void main(String[] args) {
        InputIterator syms;
        String filename = null;
        String resume = null;
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            if (args[i].equals("-i")) {
                filename = args[++i];
            } else if (args[i].equals("-r")) {
                resume = args[++i];
            } else {
                System.err.println("Unknown option '" + args[i] + "'");
            }
            ++i;
        }
        if (args.length > i) {
            DSymbol ds = new DSymbol(args[i]);
            syms = Iterators.singleton(ds);
        } else if (filename != null) {
            try {
                syms = new InputIterator(new BufferedReader(new FileReader(filename)));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace(System.err);
                return;
            }
        } else {
            syms = new InputIterator(new BufferedReader(new InputStreamReader(System.in)));
        }
        int inCount = 0;
        int outCount = 0;
        while (syms.hasNext()) {
            DSymbol ds = (DSymbol)syms.next();
            ++inCount;
            DefineBranching2d iter = new DefineBranching2d(ds, 3, 2, Whole.ZERO);
            iter.setResumePoint(resume);
            iter.addEventLink(CheckpointEvent.class, new EventProcessor(){

                public void handleEvent(Object event) {
                    System.out.println(event);
                    System.out.flush();
                }
            });
            try {
                for (DSymbol out : iter) {
                    if (!out.curvature2D().isZero()) continue;
                    ++outCount;
                    System.out.println(out);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        System.out.println("# Processed " + inCount + " input symbols.");
        System.out.println("# Produced " + outCount + " output symbols.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BMove
    implements BranchAndCut.Move {
        public final int index;
        public final int element;
        public final int value;

        public BMove(int index, int element, int value) {
            this.index = index;
            this.element = element;
            this.value = value;
        }

        public String toString() {
            return String.format("(%d, %d, %d)", this.index, this.element, this.value);
        }
    }
}

