/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.filters;

import java.util.LinkedList;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;
import org.gavrog.joss.dsyms.generators.InputIterator;

public class FilterEuclidean {
    public static void main(String[] args) {
        String filename = args[0];
        int f = args.length > 1 ? Integer.parseInt(args[1]) : 10000;
        LinkedList<Integer> good = new LinkedList<Integer>();
        LinkedList<Pair<Integer, DelaneySymbol<Integer>>> ambiguous = new LinkedList<Pair<Integer, DelaneySymbol<Integer>>>();
        int count = 0;
        Stopwatch timer = new Stopwatch();
        timer.start();
        for (DSymbol dSymbol : new InputIterator(filename)) {
            ++count;
            EuclidicityTester tester = new EuclidicityTester(dSymbol, true, f);
            if (tester.isGood()) {
                System.out.println("#Symbol " + count + " is good: " + tester.getCause());
                good.add(count);
                System.out.println(dSymbol);
            } else if (tester.isBad()) {
                System.out.println("#Symbol " + count + " is bad: " + tester.getCause());
            } else {
                System.out.println("#Symbol " + count + " is ambiguous: " + tester.getCause());
                ambiguous.add(new Pair<Integer, DelaneySymbol<Integer>>(count, tester.getOutcome()));
                System.out.println("#??? " + dSymbol);
            }
            System.out.flush();
        }
        timer.stop();
        System.out.print("### " + good.size() + " good symbols:");
        for (Integer n : good) {
            System.out.print(" " + n);
        }
        System.out.println();
        System.out.println("### " + ambiguous.size() + " ambiguous symbols:");
        for (Pair pair : ambiguous) {
            int n = (Integer)pair.getFirst();
            DelaneySymbol ds = (DelaneySymbol)pair.getSecond();
            FpGroup<String> G = new FundamentalGroup(ds).getPresentation();
            System.out.println("#   " + n + ":  " + ds.canonical());
            System.out.println("#       " + G);
            System.out.println("#       (abelian invariants: " + G.abelianInvariants() + ")");
        }
        System.out.println("### Running time was " + timer.format() + ".");
    }
}

