/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.filters;

import java.util.Iterator;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.generators.InputIterator;

public class Filter3Coordinated {
    public static void main(String[] args) {
        String filename = args[0];
        int inCount = 0;
        int outCount = 0;
        for (DSymbol ds : new InputIterator(filename)) {
            DSymbol dual = ds.dual();
            ++inCount;
            if (Filter3Coordinated.is3coordinated(ds)) {
                ++outCount;
                System.out.println(ds.canonical());
            }
            if (ds.equals(dual) || !Filter3Coordinated.is3coordinated(dual)) continue;
            ++outCount;
            System.out.println(dual.canonical());
        }
        System.err.println("Read " + inCount + " symbols. Found " + outCount + " 3-coordinated symbols, including duals.");
    }

    private static boolean is3coordinated(DSymbol ds) {
        IndexList idcs = new IndexList(1, 2, 3);
        Iterator iterator = ds.orbitReps(idcs).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            DSymbol sub = new DSymbol(new Subsymbol<Integer>(ds, idcs, D));
            DSymbol cov = new DSymbol(Covers.finiteUniversalCover(sub));
            int nrEdges = cov.numberOfOrbits(new IndexList(1, 2));
            if (nrEdges == 3) continue;
            return false;
        }
        return true;
    }
}

