/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.filters;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.generators.InputIterator;

public class Filter {
    public static void main(String[] args) {
        try {
            boolean unique = false;
            boolean canonical = false;
            boolean minimize = false;
            boolean sort = false;
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-c")) {
                    canonical = !canonical;
                } else if (args[i].equalsIgnoreCase("-m")) {
                    minimize = !minimize;
                } else if (args[i].equalsIgnoreCase("-s")) {
                    sort = !sort;
                } else if (args[i].equalsIgnoreCase("-u")) {
                    unique = !unique;
                } else {
                    System.err.println("Unknown option '" + args[i] + "'");
                }
                ++i;
            }
            InputStreamReader in = args.length > i ? new FileReader(args[i]) : new InputStreamReader(System.in);
            OutputStreamWriter out = args.length > i + 1 ? new FileWriter(args[i + 1]) : new OutputStreamWriter(System.out);
            int inCount = 0;
            int outCount = 0;
            ArrayList<DelaneySymbol<Object>> syms = new ArrayList<DelaneySymbol<Object>>();
            for (DSymbol dSymbol : new InputIterator(in)) {
                DelaneySymbol ds = dSymbol;
                ++inCount;
                if (minimize) {
                    ds = ds.minimal();
                }
                if (canonical) {
                    ds = ds.canonical();
                }
                syms.add(ds);
            }
            if (unique) {
                HashSet<DelaneySymbol<Object>> hashSet = new HashSet<DelaneySymbol<Object>>();
                hashSet.addAll(syms);
                syms.clear();
                syms.addAll(hashSet);
            }
            if (sort) {
                Collections.sort(syms, new Comparator<DelaneySymbol<Integer>>(){

                    @Override
                    public int compare(DelaneySymbol<Integer> ds1, DelaneySymbol<Integer> ds2) {
                        if (ds1.size() == ds2.size()) {
                            return ds1.compareTo(ds2);
                        }
                        return ds1.size() - ds2.size();
                    }
                });
            }
            for (DelaneySymbol delaneySymbol : syms) {
                out.write(delaneySymbol.toString());
                ++outCount;
                out.write("\n");
            }
            out.write("### Read " + inCount + " and wrote " + outCount + " symbols.\n");
            ((Writer)out).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

