/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.collections.Partition;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbifoldGraph {
    private final String[] stabilizers;
    private final List<int[]> edges;
    private final List<List<Integer>> neighbors;

    public <T> OrbifoldGraph(DelaneySymbol<T> input) {
        Iterator ilj;
        DSymbol ds = new DSymbol(input);
        if (ds.dim() != 3) {
            String msg = "symbol must be 3-dimensional";
            throw new UnsupportedOperationException("symbol must be 3-dimensional");
        }
        if (!ds.isLocallyEuclidean3D()) {
            String msg = "symbol must be locally euclidean";
            throw new UnsupportedOperationException("symbol must be locally euclidean");
        }
        int d = ds.dim();
        HashMap<Orbit, Object> edges = new HashMap<Orbit, Object>();
        final HashMap<Orbit, String> orb2type = new HashMap<Orbit, String>();
        HashMap<Orbit, Orbit> orb2rep = new HashMap<Orbit, Orbit>();
        HashMap<Orbit, List<Integer>> orb2elms = new HashMap<Orbit, List<Integer>>();
        int i = 0;
        while (i <= d) {
            for (int D : ds.elements()) {
                if (!ds.op(i, D).equals(D)) continue;
                Orbit orb = new Orbit(new IndexList(i), D);
                orb2type.put(orb, "1*");
                edges.put(orb, new ArrayList());
            }
            ++i;
        }
        i = 0;
        while (i < d) {
            IndexList ili = new IndexList(i);
            int j = i + 1;
            while (j <= d) {
                ilj = new IndexList(j);
                IndexList idcs = new IndexList(i, j);
                Iterator iterator = ds.orbitReps(idcs).iterator();
                while (iterator.hasNext()) {
                    int D = (Integer)iterator.next();
                    ArrayList<Orbit> cuts = new ArrayList<Orbit>();
                    for (int E : ds.orbit(idcs, D)) {
                        Orbit ci = new Orbit(ili, E);
                        Orbit cj = new Orbit((IndexList)((Object)ilj), E);
                        if (orb2type.containsKey(ci)) {
                            cuts.add(ci);
                        }
                        if (!orb2type.containsKey(cj)) continue;
                        cuts.add(cj);
                    }
                    int v = ds.v(i, j, D);
                    String type = cuts.size() > 0 ? (v > 1 ? "*" + v + v : "1*") : (v > 1 ? "" + v + v : "");
                    Orbit orb = new Orbit(idcs, D);
                    orb2elms.put(orb, Iterators.asList(ds.orbit(idcs, D)));
                    Iterator<Object> iterator2 = ds.orbit(idcs, D).iterator();
                    while (iterator2.hasNext()) {
                        int E = (Integer)iterator2.next();
                        orb2rep.put(new Orbit(idcs, E), orb);
                    }
                    if (type.length() <= 0) continue;
                    orb2type.put(orb, type);
                    if (cuts.size() > 0) {
                        Orbit ca = (Orbit)cuts.get(0);
                        Orbit cb = (Orbit)cuts.get(1);
                        ((List)edges.get(ca)).add(orb);
                        ((List)edges.get(cb)).add(orb);
                        edges.put(orb, cuts);
                        continue;
                    }
                    edges.put(orb, new ArrayList());
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= 3) {
            IndexList idcs = new IndexList(ds);
            idcs.remove(new Integer(i));
            ilj = ds.orbitReps(idcs).iterator();
            while (ilj.hasNext()) {
                String type;
                Iterator ilnm;
                int E = (Integer)ilj.next();
                List<Integer> sub = Iterators.asList(ds.orbit(idcs, E));
                ArrayList<String> cones = new ArrayList<String>();
                ArrayList corners = new ArrayList();
                ArrayList neighbors = new ArrayList();
                int j = 0;
                while (j <= 2) {
                    int n = (Integer)idcs.get((j + 1) % 3);
                    int m = (Integer)idcs.get((j + 2) % 3);
                    ilnm = new IndexList(Math.min(n, m), Math.max(n, m));
                    HashSet seen = new HashSet();
                    for (int D2 : sub) {
                        if (seen.contains(D2)) continue;
                        Orbit orb = (Orbit)orb2rep.get(new Orbit((IndexList)((Object)ilnm), D2));
                        String t = (String)orb2type.get(orb);
                        seen.addAll((Collection)orb2elms.get(orb));
                        if (t == null) continue;
                        if (t.charAt(0) == '*') {
                            corners.add(t.substring(1, 2));
                        } else if (t.charAt(0) != '1') {
                            cones.add(t.substring(0, 1));
                        }
                        neighbors.add(orb);
                        seen.addAll((Collection)orb2elms.get(orb));
                    }
                    ++j;
                }
                Collections.sort(cones);
                Collections.reverse(cones);
                Collections.sort(corners);
                Collections.reverse(corners);
                int D = sub.get(0);
                StringBuffer buf = new StringBuffer(20);
                for (String s : cones) {
                    buf.append(s);
                }
                if (!ds.orbitIsLoopless(idcs, D)) {
                    buf.append('*');
                    ilnm = corners.iterator();
                    while (ilnm.hasNext()) {
                        String s = (String)ilnm.next();
                        buf.append(s);
                    }
                }
                if (!ds.orbitIsWeaklyOriented(idcs, D)) {
                    buf.append('x');
                }
                if ((type = buf.toString()).equals("*") || type.equals("x")) {
                    type = "1" + type;
                }
                if (type.length() == 0) continue;
                Orbit orb = new Orbit(idcs, D);
                orb2type.put(orb, type);
                edges.put(orb, neighbors);
                Iterator D2 = neighbors.iterator();
                while (D2.hasNext()) {
                    Orbit n = (Orbit)D2.next();
                    ((List)edges.get(n)).add(orb);
                }
            }
            ++i;
        }
        ArrayList orbs = new ArrayList();
        orbs.addAll(orb2type.keySet());
        Collections.sort(orbs, new Comparator<Orbit>(){

            @Override
            public int compare(Orbit arg0, Orbit arg1) {
                String type0 = (String)orb2type.get(arg0);
                String type1 = (String)orb2type.get(arg1);
                return type0.compareTo(type1);
            }
        });
        Partition<Orbit> p = new Partition<Orbit>();
        for (Orbit orb : orbs) {
            p.unite(orb, orb);
            String type = (String)orb2type.get(orb);
            for (Orbit n : (List)edges.get(orb)) {
                if (!type.equals(orb2type.get(n))) continue;
                p.unite(orb, n);
            }
        }
        Map reps = p.representativeMap();
        HashMap<Orbit, Integer> orb2class = new HashMap<Orbit, Integer>();
        HashMap<Orbit, Integer> class2nr = new HashMap<Orbit, Integer>();
        int nrOfClasses = 0;
        for (Orbit orb : orbs) {
            Orbit cl = (Orbit)reps.get(orb);
            if (!class2nr.containsKey(cl)) {
                class2nr.put(cl, nrOfClasses);
                ++nrOfClasses;
            }
            orb2class.put(orb, (Integer)class2nr.get(cl));
        }
        String[] class2type = new String[nrOfClasses];
        boolean[][] adj = new boolean[nrOfClasses][nrOfClasses];
        for (Orbit orb : orb2class.keySet()) {
            int cl = (Integer)orb2class.get(orb);
            class2type[cl] = (String)orb2type.get(orb);
            for (Orbit n : (List)edges.get(orb)) {
                int v = (Integer)orb2class.get(n);
                adj[cl][v] = true;
                adj[v][cl] = true;
            }
        }
        int i2 = 0;
        while (i2 < nrOfClasses) {
            if (class2type[i2].equals("1*")) {
                int j = 0;
                while (j < nrOfClasses) {
                    String t = class2type[j];
                    if (t.length() == 4 || t.charAt(0) != '*') {
                        adj[i2][j] = false;
                        adj[j][i2] = false;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        ArrayList<int[]> edgeList = new ArrayList<int[]>();
        LinkedList<List<Integer>> neighbors = new LinkedList<List<Integer>>();
        int i3 = 0;
        while (i3 < nrOfClasses) {
            neighbors.add(new ArrayList());
            ++i3;
        }
        i3 = 0;
        while (i3 < nrOfClasses) {
            int j = i3 + 1;
            while (j < nrOfClasses) {
                if (adj[i3][j]) {
                    edgeList.add(new int[]{i3, j});
                    ((List)neighbors.get(i3)).add(j);
                    ((List)neighbors.get(j)).add(i3);
                }
                ++j;
            }
            ++i3;
        }
        this.stabilizers = class2type;
        this.edges = edgeList;
        this.neighbors = neighbors;
    }

    public String[] getStabilizers() {
        return this.stabilizers;
    }

    public List<int[]> getEdges() {
        return this.edges;
    }

    public List<List<Integer>> getNeighbors() {
        return this.neighbors;
    }

    public static void main(String[] args) {
        String code = "36 3:1 2 3 5 6 8 9 11 12 13 14 15 16 17 18 19 20 21 23 24 25 26 27 28 29 30 31 32 33 34 35 36,2 5 12 8 13 11 27 33 16 18 20 23 26 25 30 36 32 35,3 6 7 8 31 11 19 20 16 18 33 24 23 26 32 34 30 36,18 17 26 23 22 9 10 11 21 27 36 25 24 35 34 32 33 31:4 4 4 4 8 4 4 4 4 4 6 8 6 4,3 3 3 3 3 3,3 4 4 4 3";
        DSymbol ds = new DSymbol("36 3:1 2 3 5 6 8 9 11 12 13 14 15 16 17 18 19 20 21 23 24 25 26 27 28 29 30 31 32 33 34 35 36,2 5 12 8 13 11 27 33 16 18 20 23 26 25 30 36 32 35,3 6 7 8 31 11 19 20 16 18 33 24 23 26 32 34 30 36,18 17 26 23 22 9 10 11 21 27 36 25 24 35 34 32 33 31:4 4 4 4 8 4 4 4 4 4 6 8 6 4,3 3 3 3 3 3,3 4 4 4 3");
        OrbifoldGraph og = new OrbifoldGraph(ds);
        String[] stabs = og.getStabilizers();
        System.out.println(String.valueOf(stabs.length) + " nodes");
        System.out.println(Arrays.asList(stabs));
        System.out.println(String.valueOf(og.getEdges().size()) + " edges");
        for (int[] nArray : og.getEdges()) {
            System.out.println(String.valueOf(nArray[0]) + "(" + stabs[nArray[0]] + ") <-> " + nArray[1] + "(" + stabs[nArray[1]] + ")");
        }
        for (List list : og.getNeighbors()) {
            System.out.println(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Orbit
    extends Pair<IndexList, Integer> {
        public Orbit(IndexList idcs, int elm) {
            super(idcs, elm);
        }
    }
}

