/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.Traversal;
import org.gavrog.joss.dsyms.derived.Boundary;

public class FundamentalEdges<T>
extends IteratorAdapter<DSPair<T>> {
    private final DelaneySymbol<T> ds;
    private final Boundary<T> boundary;
    private final Traversal<T> traversal;
    private final LinkedList<Boundary.Face<T>> Q;

    public FundamentalEdges(DelaneySymbol<T> delaneySymbol) {
        this(delaneySymbol, new Traversal<T>(delaneySymbol));
    }

    public FundamentalEdges(DelaneySymbol<T> delaneySymbol, Traversal<T> traversal) {
        if (delaneySymbol == null) {
            throw new NullPointerException("null argument");
        }
        this.ds = delaneySymbol;
        this.traversal = traversal;
        this.boundary = new Boundary<T>(this.ds);
        this.Q = new LinkedList();
    }

    @Override
    protected DSPair<T> findNext() {
        int n;
        T t;
        Object object;
        while (this.Q.size() > 0) {
            object = this.Q.removeFirst();
            t = ((Boundary.Face)object).getElement();
            n = ((Boundary.Face)object).getFirstIndex();
            int n2 = ((Boundary.Face)object).getSecondIndex();
            if (!this.boundary.isOnBoundary(n, t) || this.boundary.glueCountAtRidge(n, t, n2) != 2 * this.ds.m(n, n2, t)) continue;
            this.boundary.glueAndEnqueue(n, t, this.Q);
            return new DSPair<T>(n, t);
        }
        while (this.traversal.hasNext()) {
            object = (DSPair)this.traversal.next();
            t = ((DSPair)object).getElement();
            n = ((DSPair)object).getIndex();
            if (n < 0) continue;
            if (!this.boundary.isOnBoundary(n, t)) {
                throw new RuntimeException("this should not happen");
            }
            this.boundary.glueAndEnqueue(n, t, this.Q);
            return new DSPair<T>(n, t);
        }
        throw new NoSuchElementException("at end");
    }
}

